/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import java.util.Objects;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.persistence.manager.PersistenceManager;
import org.jboss.logging.Logger;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.health.LoadBalancerCheckProvider;

public class InfinispanMultiSiteLoadBalancerCheckProvider
implements LoadBalancerCheckProvider {
    private static final Logger LOG = Logger.getLogger(InfinispanMultiSiteLoadBalancerCheckProvider.class);
    private final InfinispanConnectionProvider connectionProvider;

    public InfinispanMultiSiteLoadBalancerCheckProvider(InfinispanConnectionProvider connectionProvider) {
        Objects.requireNonNull(connectionProvider, "connectionProvider");
        this.connectionProvider = connectionProvider;
    }

    public boolean isDown() {
        for (String cacheName : InfinispanConnectionProvider.ALL_CACHES_NAME) {
            Cache cache = this.connectionProvider.getCache(cacheName, false);
            if (cache == null || !cache.getStatus().allowInvocations()) {
                LOG.debugf("Cache '%s' is not started yet.", (Object)cacheName);
                return true;
            }
            PersistenceManager persistenceManager = (PersistenceManager)ComponentRegistry.componentOf(cache, PersistenceManager.class);
            if (persistenceManager != null && !persistenceManager.isAvailable()) {
                LOG.debugf("PersistenceManager for cache '%s' is down.", (Object)cacheName);
                return true;
            }
            LOG.debugf("Cache '%s' is up.", (Object)cacheName);
        }
        return false;
    }

    public void close() {
    }
}

