/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.concurrent.ArrayBlockingQueue;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.PersistentUserSessionProvider;
import org.keycloak.models.sessions.infinispan.SessionFunction;
import org.keycloak.models.sessions.infinispan.changes.PersistentSessionsChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.PersistentUpdate;
import org.keycloak.models.sessions.infinispan.changes.SerializeExecutionsByKey;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheInvoker;

public class UserSessionPersistentChangelogBasedTransaction
extends PersistentSessionsChangelogBasedTransaction<String, UserSessionEntity> {
    private static final Logger LOG = Logger.getLogger(UserSessionPersistentChangelogBasedTransaction.class);

    public UserSessionPersistentChangelogBasedTransaction(KeycloakSession session, Cache<String, SessionEntityWrapper<UserSessionEntity>> cache, Cache<String, SessionEntityWrapper<UserSessionEntity>> offlineCache, RemoteCacheInvoker remoteCacheInvoker, SessionFunction<UserSessionEntity> lifespanMsLoader, SessionFunction<UserSessionEntity> maxIdleTimeMsLoader, SessionFunction<UserSessionEntity> offlineLifespanMsLoader, SessionFunction<UserSessionEntity> offlineMaxIdleTimeMsLoader, ArrayBlockingQueue<PersistentUpdate> batchingQueue, SerializeExecutionsByKey<String> serializerOnline, SerializeExecutionsByKey<String> serializerOffline) {
        super(session, cache, offlineCache, remoteCacheInvoker, lifespanMsLoader, maxIdleTimeMsLoader, offlineLifespanMsLoader, offlineMaxIdleTimeMsLoader, batchingQueue, serializerOnline, serializerOffline);
    }

    public SessionEntityWrapper<UserSessionEntity> get(RealmModel realm, String key, boolean offline) {
        SessionUpdatesList<Object> myUpdates = this.getUpdates(offline).get(key);
        if (myUpdates == null) {
            SessionEntityWrapper<UserSessionEntity> wrappedEntity = null;
            wrappedEntity = (SessionEntityWrapper<UserSessionEntity>)this.getCache(offline).get((Object)key);
            if (wrappedEntity == null) {
                LOG.debugf("user-session not found in cache for sessionId=%s offline=%s, loading from persister", (Object)key, (Object)offline);
                wrappedEntity = this.getSessionEntityFromPersister(realm, key, offline);
            } else {
                LOG.debugf("user-session found in cache for sessionId=%s offline=%s %s", (Object)key, (Object)offline, (Object)((UserSessionEntity)wrappedEntity.getEntity()).getLastSessionRefresh());
            }
            if (wrappedEntity == null) {
                LOG.debugf("user-session not found in persister for sessionId=%s offline=%s", (Object)key, (Object)offline);
                return null;
            }
            wrappedEntity.getEntity().setOffline(offline);
            RealmModel realmFromSession = this.kcSession.realms().getRealm(wrappedEntity.getEntity().getRealmId());
            if (!realmFromSession.getId().equals(realm.getId())) {
                LOG.warnf("Realm mismatch for session %s. Expected realm %s, but found realm %s", (Object)wrappedEntity.getEntity(), (Object)realm.getId(), (Object)realmFromSession.getId());
                return null;
            }
            myUpdates = new SessionUpdatesList<UserSessionEntity>(realm, wrappedEntity);
            this.getUpdates(offline).put(key, myUpdates);
            return wrappedEntity;
        }
        boolean scheduledForRemove = myUpdates.getUpdateTasks().stream().map(SessionUpdateTask::getOperation).anyMatch(SessionUpdateTask.CacheOperation.REMOVE::equals);
        return scheduledForRemove ? null : myUpdates.getEntityWrapper();
    }

    private SessionEntityWrapper<UserSessionEntity> getSessionEntityFromPersister(RealmModel realm, String key, boolean offline) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.kcSession.getProvider(UserSessionPersisterProvider.class);
        UserSessionModel persistentUserSession = persister.loadUserSession(realm, key, offline);
        if (persistentUserSession == null) {
            return null;
        }
        return this.importUserSession(persistentUserSession);
    }

    private SessionEntityWrapper<UserSessionEntity> importUserSession(UserSessionModel persistentUserSession) {
        boolean offline;
        String sessionId = persistentUserSession.getId();
        if (this.isScheduledForRemove(sessionId, offline = persistentUserSession.isOffline())) {
            return null;
        }
        LOG.debugf("Attempting to import user-session for sessionId=%s offline=%s", (Object)sessionId, (Object)offline);
        SessionEntityWrapper<UserSessionEntity> ispnUserSessionEntity = ((PersistentUserSessionProvider)this.kcSession.getProvider(UserSessionProvider.class)).importUserSession(persistentUserSession, offline);
        if (ispnUserSessionEntity != null) {
            LOG.debugf("user-session found after import for sessionId=%s offline=%s", (Object)sessionId, (Object)offline);
            return ispnUserSessionEntity;
        }
        LOG.debugf("user-session could not be found after import for sessionId=%s offline=%s", (Object)sessionId, (Object)offline);
        return null;
    }

    public boolean isScheduledForRemove(String key, boolean offline) {
        return UserSessionPersistentChangelogBasedTransaction.isScheduledForRemove(this.getUpdates(offline).get(key));
    }

    private static <V extends SessionEntity> boolean isScheduledForRemove(SessionUpdatesList<V> myUpdates) {
        if (myUpdates == null) {
            return false;
        }
        return myUpdates.getUpdateTasks().stream().anyMatch(task -> task.getOperation() == SessionUpdateTask.CacheOperation.REMOVE);
    }
}

