/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan.remote;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ExecutionResult;
import org.keycloak.cluster.infinispan.LockEntry;
import org.keycloak.cluster.infinispan.TaskCallback;
import org.keycloak.cluster.infinispan.remote.RemoteInfinispanClusterProviderFactory;
import org.keycloak.cluster.infinispan.remote.RemoteInfinispanNotificationManager;
import org.keycloak.common.util.Retry;

public class RemoteInfinispanClusterProvider
implements ClusterProvider {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private final SharedData data;

    public RemoteInfinispanClusterProvider(SharedData data) {
        this.data = Objects.requireNonNull(data);
    }

    public int getClusterStartupTime() {
        return this.data.clusterStartupTime();
    }

    public <T> ExecutionResult<T> executeIfNotExecuted(String taskKey, int taskTimeoutInSeconds, Callable<T> task) {
        String cacheKey = "task::" + taskKey;
        boolean locked = this.tryLock(cacheKey, taskTimeoutInSeconds);
        if (locked) {
            try {
                T result = task.call();
                ExecutionResult executionResult = ExecutionResult.executed(result);
                return executionResult;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected exception when executed task " + taskKey, e);
            }
            finally {
                this.removeFromCache(cacheKey);
            }
        }
        return ExecutionResult.notExecuted();
    }

    public Future<Boolean> executeIfNotExecutedAsync(String taskKey, int taskTimeoutInSeconds, Callable task) {
        TaskCallback newCallback = new TaskCallback();
        TaskCallback callback = this.data.notificationManager().registerTaskCallback("task::" + taskKey, newCallback);
        if (newCallback == callback) {
            Supplier<Boolean> wrappedTask = () -> {
                boolean executed = this.executeIfNotExecuted(taskKey, taskTimeoutInSeconds, task).isExecuted();
                if (!executed) {
                    logger.infof("Task already in progress on other cluster node. Will wait until it's finished", new Object[0]);
                }
                try {
                    callback.getTaskCompletedLatch().await(taskTimeoutInSeconds, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return callback.isSuccess();
            };
            callback.setFuture(CompletableFuture.supplyAsync(wrappedTask, this.data.executor()));
        } else {
            logger.infof("Task already in progress on this cluster node. Will wait until it's finished", new Object[0]);
        }
        return callback.getFuture();
    }

    public void registerListener(String taskKey, ClusterListener task) {
        this.data.notificationManager().registerListener(taskKey, task);
    }

    public void notify(String taskKey, ClusterEvent event, boolean ignoreSender, ClusterProvider.DCNotify dcNotify) {
        this.data.notificationManager().notify(taskKey, Collections.singleton(event), ignoreSender, dcNotify);
    }

    public void notify(String taskKey, Collection<? extends ClusterEvent> events, boolean ignoreSender, ClusterProvider.DCNotify dcNotify) {
        this.data.notificationManager().notify(taskKey, events, ignoreSender, dcNotify);
    }

    public void close() {
    }

    private boolean tryLock(String cacheKey, int taskTimeoutInSeconds) {
        LockEntry myLock = this.createLockEntry();
        LockEntry existingLock = RemoteInfinispanClusterProviderFactory.putIfAbsentWithRetries(this.data.cache(), cacheKey, myLock, taskTimeoutInSeconds);
        if (existingLock != null) {
            if (logger.isTraceEnabled()) {
                logger.tracef("Task %s in progress already by node %s. Ignoring task.", (Object)cacheKey, (Object)existingLock.node());
            }
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.tracef("Successfully acquired lock for task %s. Our node is %s", (Object)cacheKey, (Object)myLock.node());
        }
        return true;
    }

    private LockEntry createLockEntry() {
        return new LockEntry(this.data.notificationManager().getMyNodeName());
    }

    private void removeFromCache(String cacheKey) {
        Retry.executeWithBackoff(iteration -> {
            this.data.cache().remove((Object)cacheKey);
            if (logger.isTraceEnabled()) {
                logger.tracef("Task %s removed from the cache", (Object)cacheKey);
            }
        }, (int)10, (int)10);
    }

    public static interface SharedData {
        public int clusterStartupTime();

        public RemoteCache<String, LockEntry> cache();

        public RemoteInfinispanNotificationManager notificationManager();

        public Executor executor();
    }
}

