/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.jpa.entities.PermissionTicketEntity;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.authorization.jpa.store.ResourceServerAdapter;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelException;
import org.keycloak.storage.StorageId;

public class JPAResourceServerStore
implements ResourceServerStore {
    private final EntityManager entityManager;
    private final AuthorizationProvider provider;

    public JPAResourceServerStore(EntityManager entityManager, AuthorizationProvider provider) {
        this.entityManager = entityManager;
        this.provider = provider;
    }

    public ResourceServer create(ClientModel client) {
        String clientId = client.getId();
        if (!StorageId.isLocalStorage((String)clientId)) {
            throw new ModelException("Creating resource server from federated ClientModel not supported");
        }
        ResourceServerEntity entity = new ResourceServerEntity();
        entity.setId(clientId);
        this.entityManager.persist((Object)entity);
        return new ResourceServerAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public void delete(ClientModel client) {
        String id = client.getId();
        ResourceServerEntity entity = (ResourceServerEntity)this.entityManager.find(ResourceServerEntity.class, (Object)id);
        if (entity == null) {
            return;
        }
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByServerId", String.class);
        query.setParameter("serverId", (Object)id);
        List result = query.getResultList();
        for (String policyId : result) {
            this.entityManager.remove(this.entityManager.getReference(PolicyEntity.class, (Object)policyId));
        }
        query = this.entityManager.createNamedQuery("findPermissionTicketIdByServerId", String.class);
        query.setParameter("serverId", (Object)id);
        result = query.getResultList();
        for (String permissionId : result) {
            this.entityManager.remove(this.entityManager.getReference(PermissionTicketEntity.class, (Object)permissionId));
        }
        query = this.entityManager.createNamedQuery("findResourceIdByServerId", String.class);
        query.setParameter("serverId", (Object)id);
        result = query.getResultList();
        for (String resourceId : result) {
            this.entityManager.remove(this.entityManager.getReference(ResourceEntity.class, (Object)resourceId));
        }
        query = this.entityManager.createNamedQuery("findScopeIdByResourceServer", String.class);
        query.setParameter("serverId", (Object)id);
        result = query.getResultList();
        for (String scopeId : result) {
            this.entityManager.remove(this.entityManager.getReference(ScopeEntity.class, (Object)scopeId));
        }
        this.entityManager.remove((Object)entity);
        this.entityManager.flush();
        this.entityManager.detach((Object)entity);
    }

    public ResourceServer findById(String id) {
        ResourceServerEntity entity = (ResourceServerEntity)this.entityManager.find(ResourceServerEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new ResourceServerAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public ResourceServer findByClient(ClientModel client) {
        return this.findById(client.getId());
    }
}

