/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo2_2_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("2.2.0");
    private static final Logger LOG = Logger.getLogger(MigrateTo2_2_0.class);

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(this::addIdentityProviderAuthenticator);
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.addIdentityProviderAuthenticator(realm);
    }

    private void addIdentityProviderAuthenticator(RealmModel realm) {
        String defaultProvider = realm.getIdentityProvidersStream().filter(IdentityProviderModel::isEnabled).filter(IdentityProviderModel::isAuthenticateByDefault).map(IdentityProviderModel::getAlias).findFirst().orElse(null);
        DefaultAuthenticationFlows.addIdentityProviderAuthenticator((RealmModel)realm, (String)defaultProvider);
    }
}

