/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.Calendar;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.PrioritizedComponentModel;
import org.keycloak.models.cache.CachedObject;

public class CacheableStorageProviderModel
extends PrioritizedComponentModel {
    public static final String CACHE_POLICY = "cachePolicy";
    public static final String MAX_LIFESPAN = "maxLifespan";
    public static final String EVICTION_HOUR = "evictionHour";
    public static final String EVICTION_MINUTE = "evictionMinute";
    public static final String EVICTION_DAY = "evictionDay";
    public static final String CACHE_INVALID_BEFORE = "cacheInvalidBefore";
    public static final String ENABLED = "enabled";
    private transient CachePolicy cachePolicy;
    private transient long maxLifespan = -1L;
    private transient int evictionHour = -1;
    private transient int evictionMinute = -1;
    private transient int evictionDay = -1;
    private transient long cacheInvalidBefore = -1L;
    private transient Boolean enabled;

    public CacheableStorageProviderModel() {
    }

    public CacheableStorageProviderModel(ComponentModel copy) {
        super(copy);
    }

    public CachePolicy getCachePolicy() {
        if (this.cachePolicy == null) {
            String str = (String)this.getConfig().getFirst((Object)CACHE_POLICY);
            if (str == null) {
                return null;
            }
            this.cachePolicy = CachePolicy.valueOf(str);
        }
        return this.cachePolicy;
    }

    public void setCachePolicy(CachePolicy cachePolicy) {
        this.cachePolicy = cachePolicy;
        if (cachePolicy == null) {
            this.getConfig().remove((Object)CACHE_POLICY);
        } else {
            this.getConfig().putSingle((Object)CACHE_POLICY, (Object)cachePolicy.name());
        }
    }

    public long getMaxLifespan() {
        if (this.maxLifespan < 0L) {
            String str = (String)this.getConfig().getFirst((Object)MAX_LIFESPAN);
            if (str == null) {
                return -1L;
            }
            this.maxLifespan = Long.valueOf(str);
        }
        return this.maxLifespan;
    }

    public void setMaxLifespan(long maxLifespan) {
        this.maxLifespan = maxLifespan;
        this.getConfig().putSingle((Object)MAX_LIFESPAN, (Object)Long.toString(maxLifespan));
    }

    public int getEvictionHour() {
        if (this.evictionHour < 0) {
            String str = (String)this.getConfig().getFirst((Object)EVICTION_HOUR);
            if (str == null) {
                return -1;
            }
            this.evictionHour = Integer.valueOf(str);
        }
        return this.evictionHour;
    }

    public void setEvictionHour(int evictionHour) {
        if (evictionHour > 23 || evictionHour < 0) {
            throw new IllegalArgumentException("Must be between 0 and 23");
        }
        this.evictionHour = evictionHour;
        this.getConfig().putSingle((Object)EVICTION_HOUR, (Object)Integer.toString(evictionHour));
    }

    public int getEvictionMinute() {
        if (this.evictionMinute < 0) {
            String str = (String)this.getConfig().getFirst((Object)EVICTION_MINUTE);
            if (str == null) {
                return -1;
            }
            this.evictionMinute = Integer.valueOf(str);
        }
        return this.evictionMinute;
    }

    public void setEvictionMinute(int evictionMinute) {
        if (evictionMinute > 59 || evictionMinute < 0) {
            throw new IllegalArgumentException("Must be between 0 and 59");
        }
        this.evictionMinute = evictionMinute;
        this.getConfig().putSingle((Object)EVICTION_MINUTE, (Object)Integer.toString(evictionMinute));
    }

    public int getEvictionDay() {
        if (this.evictionDay < 0) {
            String str = (String)this.getConfig().getFirst((Object)EVICTION_DAY);
            if (str == null) {
                return -1;
            }
            this.evictionDay = Integer.valueOf(str);
        }
        return this.evictionDay;
    }

    public void setEvictionDay(int evictionDay) {
        if (evictionDay > 7 || evictionDay < 1) {
            throw new IllegalArgumentException("Must be between 1 and 7");
        }
        this.evictionDay = evictionDay;
        this.getConfig().putSingle((Object)EVICTION_DAY, (Object)Integer.toString(evictionDay));
    }

    public long getCacheInvalidBefore() {
        if (this.cacheInvalidBefore < 0L) {
            String str = (String)this.getConfig().getFirst((Object)CACHE_INVALID_BEFORE);
            if (str == null) {
                return -1L;
            }
            this.cacheInvalidBefore = Long.valueOf(str);
        }
        return this.cacheInvalidBefore;
    }

    public void setCacheInvalidBefore(long cacheInvalidBefore) {
        this.cacheInvalidBefore = cacheInvalidBefore;
        this.getConfig().putSingle((Object)CACHE_INVALID_BEFORE, (Object)Long.toString(cacheInvalidBefore));
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
        this.getConfig().putSingle((Object)ENABLED, (Object)Boolean.toString(flag));
    }

    public boolean isEnabled() {
        if (this.enabled == null) {
            String val = (String)this.getConfig().getFirst((Object)ENABLED);
            this.enabled = val == null ? Boolean.valueOf(true) : Boolean.valueOf(val);
        }
        return this.enabled;
    }

    public long getLifespan() {
        CachePolicy policy = this.getCachePolicy();
        long lifespan = -1L;
        if (policy == null || policy == CachePolicy.DEFAULT) {
            lifespan = -1L;
        } else if (policy == CachePolicy.EVICT_DAILY) {
            if (this.getEvictionHour() > -1 && this.getEvictionMinute() > -1) {
                lifespan = CacheableStorageProviderModel.dailyTimeout(this.getEvictionHour(), this.getEvictionMinute()) - Time.currentTimeMillis();
            }
        } else if (policy == CachePolicy.EVICT_WEEKLY) {
            if (this.getEvictionDay() > 0 && this.getEvictionHour() > -1 && this.getEvictionMinute() > -1) {
                lifespan = CacheableStorageProviderModel.weeklyTimeout(this.getEvictionDay(), this.getEvictionHour(), this.getEvictionMinute()) - Time.currentTimeMillis();
            }
        } else if (policy == CachePolicy.MAX_LIFESPAN) {
            lifespan = this.getMaxLifespan();
        }
        return lifespan;
    }

    public boolean shouldInvalidate(CachedObject cached) {
        boolean invalidate = false;
        if (!this.isEnabled()) {
            invalidate = true;
        } else {
            CachePolicy policy = this.getCachePolicy();
            if (policy != null) {
                if (policy == CachePolicy.NO_CACHE) {
                    invalidate = true;
                } else if (cached.getCacheTimestamp() < this.getCacheInvalidBefore()) {
                    invalidate = true;
                } else if (policy == CachePolicy.MAX_LIFESPAN) {
                    if (cached.getCacheTimestamp() + this.getMaxLifespan() < Time.currentTimeMillis()) {
                        invalidate = true;
                    }
                } else if (policy == CachePolicy.EVICT_DAILY) {
                    long dailyBoundary = CacheableStorageProviderModel.dailyEvictionBoundary(this.getEvictionHour(), this.getEvictionMinute());
                    if (cached.getCacheTimestamp() <= dailyBoundary) {
                        invalidate = true;
                    }
                } else if (policy == CachePolicy.EVICT_WEEKLY) {
                    int oneWeek = 604800000;
                    long weeklyTimeout = CacheableStorageProviderModel.weeklyTimeout(this.getEvictionDay(), this.getEvictionHour(), this.getEvictionMinute());
                    long lastTimeout = weeklyTimeout - (long)oneWeek;
                    if (cached.getCacheTimestamp() <= lastTimeout) {
                        invalidate = true;
                    }
                }
            }
        }
        return invalidate;
    }

    public static long dailyTimeout(int hour, int minute) {
        Calendar cal = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal.setTimeInMillis(Time.currentTimeMillis());
        cal2.setTimeInMillis(Time.currentTimeMillis());
        cal2.set(11, hour);
        cal2.set(12, minute);
        if (cal2.getTimeInMillis() < cal.getTimeInMillis()) {
            int add = 86400000;
            cal.add(14, add);
        } else {
            cal = cal2;
        }
        return cal.getTimeInMillis();
    }

    public static long dailyEvictionBoundary(int hour, int minute) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(Time.currentTimeMillis());
        cal.set(11, hour);
        cal.set(12, minute);
        if (cal.getTimeInMillis() > Time.currentTimeMillis()) {
            cal.add(6, -1);
        }
        return cal.getTimeInMillis();
    }

    public static long weeklyTimeout(int day, int hour, int minute) {
        Calendar cal = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal.setTimeInMillis(Time.currentTimeMillis());
        cal2.setTimeInMillis(Time.currentTimeMillis());
        cal2.set(11, hour);
        cal2.set(12, minute);
        cal2.set(7, day);
        if (cal2.getTimeInMillis() < cal.getTimeInMillis()) {
            int add = 604800000;
            cal2.add(14, add);
        }
        return cal2.getTimeInMillis();
    }

    public static enum CachePolicy {
        NO_CACHE,
        DEFAULT,
        EVICT_DAILY,
        EVICT_WEEKLY,
        MAX_LIFESPAN;

    }
}

