/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.clientscope;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoDocs;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.clientscope.MapClientScopeEntity;
import org.keycloak.models.map.storage.hotRod.client.HotRodClientEntity;
import org.keycloak.models.map.storage.hotRod.client.HotRodProtocolMapperEntity;
import org.keycloak.models.map.storage.hotRod.clientscope.HotRodClientScopeEntityDelegate;
import org.keycloak.models.map.storage.hotRod.clientscope.HotRodClientScopeEntitySchemaImpl;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.CommonPrimitivesProtoSchemaInitializer;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntityNonIndexed;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;

@ProtoDocs(value={@ProtoDoc(value="@Indexed"), @ProtoDoc(value="schema-version: 1")})
public class HotRodClientScopeEntity
extends AbstractHotRodEntity {
    @IgnoreForEntityImplementationGenerator
    public static final int VERSION = 1;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=1)
    public Integer entityVersion = 1;
    @ProtoField(number=2)
    public String id;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=3)
    public String realmId;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=4)
    public String name;
    @ProtoField(number=5)
    public String protocol;
    @ProtoField(number=6)
    public String description;
    @ProtoField(number=7)
    public Collection<String> scopeMappings;
    @ProtoField(number=8)
    public Set<HotRodProtocolMapperEntity> protocolMappers;
    @ProtoField(number=9)
    public Set<HotRodAttributeEntityNonIndexed> attributes;

    public boolean equals(Object o) {
        return HotRodClientScopeEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodClientScopeEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodClientScopeEntityDelegate
    extends UpdatableHotRodEntityDelegateImpl<HotRodClientScopeEntity>
    implements MapClientScopeEntity {
        public String getId() {
            return ((HotRodClientScopeEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodClientScopeEntity entity = (HotRodClientScopeEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            entity.updated = entity.updated | id != null;
        }

        public Optional<MapProtocolMapperEntity> getProtocolMapper(String id) {
            Set mappers = this.getProtocolMappers();
            if (mappers == null || mappers.isEmpty()) {
                return Optional.empty();
            }
            return mappers.stream().filter(m -> Objects.equals(m.getId(), id)).findFirst();
        }

        public void removeProtocolMapper(String id) {
            HotRodClientScopeEntity entity = (HotRodClientScopeEntity)this.getHotRodEntity();
            entity.updated = entity.updated | (entity.protocolMappers != null && entity.protocolMappers.removeIf(m -> Objects.equals(m.id, id)));
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={HotRodClientScopeEntity.class}, schemaFilePath="proto/", schemaPackageName="kc", dependsOn={CommonPrimitivesProtoSchemaInitializer.class, HotRodClientEntity.HotRodClientEntitySchema.class})
    public static interface HotRodClientScopeEntitySchema
    extends GeneratedSchema {
        public static final HotRodClientScopeEntitySchema INSTANCE = new HotRodClientScopeEntitySchemaImpl();
    }
}

