/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.realm.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.realm.entity.MapComponentEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntityNonIndexed;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodComponentEntity;

public class HotRodComponentEntityDelegate
extends UpdatableHotRodEntityDelegateImpl<HotRodComponentEntity>
implements MapComponentEntity {
    private final HotRodComponentEntity hotRodEntity;
    private final DeepCloner cloner;

    public HotRodComponentEntityDelegate() {
        this.cloner = DeepCloner.DUMB_CLONER;
        this.hotRodEntity = new HotRodComponentEntity();
    }

    public HotRodComponentEntityDelegate(HotRodComponentEntity hotRodEntity) {
        Objects.requireNonNull(hotRodEntity);
        this.hotRodEntity = hotRodEntity;
        this.cloner = DeepCloner.DUMB_CLONER;
    }

    public HotRodComponentEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodComponentEntity();
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodComponentEntityDelegate)) {
            return false;
        }
        HotRodComponentEntityDelegate other = (HotRodComponentEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getConfig(), other.getConfig()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getParentId(), other.getParentId()) && Objects.equals(this.getProviderId(), other.getProviderId()) && Objects.equals(this.getProviderType(), other.getProviderType()) && Objects.equals(this.getSubType(), other.getSubType());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodComponentEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodComponentEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodComponentEntity e1 = (HotRodComponentEntity)o1;
        HotRodComponentEntity e2 = (HotRodComponentEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.name, e2.name) && Objects.equals(e1.parentId, e2.parentId) && Objects.equals(e1.providerId, e2.providerId) && Objects.equals(e1.providerType, e2.providerType) && Objects.equals(e1.subType, e2.subType) && Objects.equals(e1.config, e2.config);
    }

    public static int entityHashCode(HotRodComponentEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public <V> V deepClone(V obj) {
        return (V)this.cloner.from(obj);
    }

    public void setId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.id, migrated);
        this.hotRodEntity.id = migrated;
    }

    public String getId() {
        return this.hotRodEntity.id == null ? null : this.hotRodEntity.id;
    }

    public void setConfig(Map<String, List<String>> p0) {
        Map<String, List<String>> map = p0 = p0 == null ? null : (Map<String, List<String>>)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodAttributeEntityNonIndexed> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodAttributeEntityNonIndexedFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.config, migrated);
        this.hotRodEntity.config = migrated;
    }

    public Map<String, List<String>> getConfig() {
        return this.hotRodEntity.config == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.config, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setName(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.name, migrated);
        this.hotRodEntity.name = migrated;
    }

    public String getName() {
        return this.hotRodEntity.name == null ? null : this.hotRodEntity.name;
    }

    public String getParentId() {
        return this.hotRodEntity.parentId == null ? null : this.hotRodEntity.parentId;
    }

    public void setParentId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.parentId, migrated);
        this.hotRodEntity.parentId = migrated;
    }

    public String getProviderId() {
        return this.hotRodEntity.providerId == null ? null : this.hotRodEntity.providerId;
    }

    public void setProviderId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.providerId, migrated);
        this.hotRodEntity.providerId = migrated;
    }

    public void setProviderType(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.providerType, migrated);
        this.hotRodEntity.providerType = migrated;
    }

    public String getProviderType() {
        return this.hotRodEntity.providerType == null ? null : this.hotRodEntity.providerType;
    }

    public void setSubType(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.subType, migrated);
        this.hotRodEntity.subType = migrated;
    }

    public String getSubType() {
        return this.hotRodEntity.subType == null ? null : this.hotRodEntity.subType;
    }

    @Override
    public HotRodComponentEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

