/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.locking;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.Time;
import org.keycloak.models.locking.LockAcquiringTimeoutException;

public class HotRodLocksUtils {
    public static final String SEPARATOR = ";";

    public static void repeatPutIfAbsent(RemoteCache<String, String> locksCache, String lockName, Duration timeout, int repeatInterval, boolean isReentrant) throws LockAcquiringTimeoutException {
        AtomicReference<Object> currentOwnerRef = new AtomicReference<Object>(null);
        try {
            Retry.executeWithBackoff(i -> {
                String curr = (String)locksCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent((Object)lockName, (Object)(Time.currentTimeMillis() + SEPARATOR + HotRodLocksUtils.getKeycloakInstanceIdentifier()));
                currentOwnerRef.set(curr);
                if (!(curr == null || isReentrant && curr.endsWith(SEPARATOR + HotRodLocksUtils.getKeycloakInstanceIdentifier()))) {
                    throw new AssertionError((Object)("Acquiring lock in iteration " + i + " was not successful"));
                }
            }, (Duration)timeout, (int)repeatInterval);
        }
        catch (AssertionError ex) {
            String[] split;
            String currentOwner = currentOwnerRef.get();
            String[] stringArray = split = currentOwner == null ? null : currentOwner.split(SEPARATOR, 2);
            if (currentOwner == null || split.length != 2) {
                throw new IllegalStateException("Bad lock value format found in storage for lock " + lockName + ". It is expected the format to be 'timeAcquired;keycloakInstanceIdentifier' but was " + currentOwner);
            }
            throw new LockAcquiringTimeoutException(lockName, split[1], Instant.ofEpochMilli(Long.parseLong(split[0])));
        }
    }

    private static String getKeycloakInstanceIdentifier() {
        String hostname;
        long pid = ProcessHandle.current().pid();
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "unknown-host";
        }
        String threadName = Thread.currentThread().getName();
        return threadName + "#" + pid + "@" + hostname;
    }

    public static boolean removeWithInstanceIdentifier(ConcurrentMap<String, String> map, String lockName) {
        String value = (String)map.get(lockName);
        if (value != null && value.endsWith(HotRodLocksUtils.getKeycloakInstanceIdentifier())) {
            map.remove(lockName);
            return true;
        }
        return false;
    }
}

