/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.realm.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodPair;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodRequiredActionProviderEntity;

public class HotRodRequiredActionProviderEntityDelegate
extends UpdatableHotRodEntityDelegateImpl<HotRodRequiredActionProviderEntity>
implements MapRequiredActionProviderEntity {
    private final HotRodRequiredActionProviderEntity hotRodEntity;

    public HotRodRequiredActionProviderEntityDelegate() {
        this.hotRodEntity = new HotRodRequiredActionProviderEntity();
    }

    public HotRodRequiredActionProviderEntityDelegate(HotRodRequiredActionProviderEntity hotRodEntity) {
        Objects.requireNonNull(hotRodEntity);
        this.hotRodEntity = hotRodEntity;
    }

    public HotRodRequiredActionProviderEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodRequiredActionProviderEntity();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodRequiredActionProviderEntityDelegate)) {
            return false;
        }
        HotRodRequiredActionProviderEntityDelegate other = (HotRodRequiredActionProviderEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAlias(), other.getAlias()) && Objects.equals(this.getConfig(), other.getConfig()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getPriority(), other.getPriority()) && Objects.equals(this.getProviderId(), other.getProviderId()) && Objects.equals(this.isDefaultAction(), other.isDefaultAction()) && Objects.equals(this.isEnabled(), other.isEnabled());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodRequiredActionProviderEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodRequiredActionProviderEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodRequiredActionProviderEntity e1 = (HotRodRequiredActionProviderEntity)o1;
        HotRodRequiredActionProviderEntity e2 = (HotRodRequiredActionProviderEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.name, e2.name) && Objects.equals(e1.defaultAction, e2.defaultAction) && Objects.equals(e1.enabled, e2.enabled) && Objects.equals(e1.priority, e2.priority) && Objects.equals(e1.alias, e2.alias) && Objects.equals(e1.providerId, e2.providerId) && Objects.equals(e1.config, e2.config);
    }

    public static int entityHashCode(HotRodRequiredActionProviderEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public void setId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.id, migrated);
        this.hotRodEntity.id = migrated;
    }

    public String getId() {
        return this.hotRodEntity.id == null ? null : this.hotRodEntity.id;
    }

    public String getAlias() {
        return this.hotRodEntity.alias == null ? null : this.hotRodEntity.alias;
    }

    public void setAlias(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.alias, migrated);
        this.hotRodEntity.alias = migrated;
    }

    public Map<String, String> getConfig() {
        return this.hotRodEntity.config == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.config, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setConfig(Map<String, String> p0) {
        HashMap hashMap = p0 = p0 == null ? null : new HashMap(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodPair> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodPairFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.config, migrated);
        this.hotRodEntity.config = migrated;
    }

    public Boolean isDefaultAction() {
        return this.hotRodEntity.defaultAction == null ? null : this.hotRodEntity.defaultAction;
    }

    public void setDefaultAction(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.defaultAction, migrated);
        this.hotRodEntity.defaultAction = migrated;
    }

    public Boolean isEnabled() {
        return this.hotRodEntity.enabled == null ? null : this.hotRodEntity.enabled;
    }

    public void setEnabled(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.enabled, migrated);
        this.hotRodEntity.enabled = migrated;
    }

    public void setName(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.name, migrated);
        this.hotRodEntity.name = migrated;
    }

    public String getName() {
        return this.hotRodEntity.name == null ? null : this.hotRodEntity.name;
    }

    public void setPriority(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.priority, migrated);
        this.hotRodEntity.priority = migrated;
    }

    public Integer getPriority() {
        return this.hotRodEntity.priority == null ? null : this.hotRodEntity.priority;
    }

    public void setProviderId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.providerId, migrated);
        this.hotRodEntity.providerId = migrated;
    }

    public String getProviderId() {
        return this.hotRodEntity.providerId == null ? null : this.hotRodEntity.providerId;
    }

    @Override
    public HotRodRequiredActionProviderEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

