/*
 * Copyright 2022 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.keycloak.models.map.storage.hotRod.common;

import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.protostream.annotations.ProtoField;

import java.util.Objects;

/**
 * !!! Please do not change this class !!!
 *
 * If some change is needed please create a new version of this class and solve the migration on top-level entities.
 *
 * Indexed Hot Rod pair entity where both key and value are {@link String} type. The entity should be used when
 * there is a need to search by key or/and value. Otherwise {@link HotRodPair<String, String>} should be used.
 */
@Indexed
public class HotRodStringPair {

    @Basic(sortable = true)
    @ProtoField(number = 1)
    public String key;

    @Basic(sortable = true)
    @ProtoField(number = 2)
    public String value;

    public HotRodStringPair() {}

    public HotRodStringPair(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HotRodStringPair that = (HotRodStringPair) o;
        return Objects.equals(key, that.key) && Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, value);
    }
}
