/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.role;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntityNonIndexed;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;
import org.keycloak.models.map.storage.hotRod.role.HotRodRoleEntity;

public class HotRodRoleEntityDelegate
extends HotRodRoleEntity.AbstractHotRodRoleEntityDelegate
implements MapRoleEntity {
    private final HotRodRoleEntity hotRodEntity;
    private final DeepCloner cloner;

    public HotRodRoleEntityDelegate() {
        this.cloner = DeepCloner.DUMB_CLONER;
        this.hotRodEntity = new HotRodRoleEntity();
    }

    public HotRodRoleEntityDelegate(HotRodRoleEntity hotRodEntity) {
        Objects.requireNonNull(hotRodEntity);
        this.hotRodEntity = hotRodEntity;
        this.cloner = DeepCloner.DUMB_CLONER;
    }

    public HotRodRoleEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodRoleEntity();
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodRoleEntityDelegate)) {
            return false;
        }
        HotRodRoleEntityDelegate other = (HotRodRoleEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getClientId(), other.getClientId()) && Objects.equals(this.getCompositeRoles(), other.getCompositeRoles()) && Objects.equals(this.getDescription(), other.getDescription()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getRealmId(), other.getRealmId());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodRoleEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodRoleEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodRoleEntity e1 = (HotRodRoleEntity)o1;
        HotRodRoleEntity e2 = (HotRodRoleEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.entityVersion, e2.entityVersion) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.realmId, e2.realmId) && Objects.equals(e1.name, e2.name) && Objects.equals(e1.description, e2.description) && Objects.equals(e1.clientId, e2.clientId) && Objects.equals(e1.compositeRoles, e2.compositeRoles) && Objects.equals(e1.attributes, e2.attributes);
    }

    public static int entityHashCode(HotRodRoleEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public <V> V deepClone(V obj) {
        return (V)this.cloner.from(obj);
    }

    public List<String> getAttribute(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setAttribute(String p0, List<String> p1) {
        LinkedList<String> linkedList = p1 = p1 == null ? null : new LinkedList<String>(p1);
        if (p1 != null) {
            p1.removeIf(UndefinedValuesUtils::isUndefined);
        }
        boolean valueUndefined = UndefinedValuesUtils.isUndefined(p1);
        if (this.hotRodEntity.attributes == null && !valueUndefined) {
            this.hotRodEntity.attributes = new HashSet<HotRodAttributeEntityNonIndexed>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.attributes.add(new HotRodAttributeEntityNonIndexed(p0, p1)));
    }

    public Map<String, List<String>> getAttributes() {
        return this.hotRodEntity.attributes == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.attributes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void removeAttribute(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
    }

    public void setAttributes(Map<String, List<String>> p0) {
        Map<String, List<String>> map = p0 = p0 == null ? null : (Map<String, List<String>>)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodAttributeEntityNonIndexed> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodAttributeEntityNonIndexedFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.attributes, migrated);
        this.hotRodEntity.attributes = migrated;
    }

    public String getClientId() {
        return this.hotRodEntity.clientId == null ? null : this.hotRodEntity.clientId;
    }

    public void setCompositeRoles(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.compositeRoles, migrated);
        this.hotRodEntity.compositeRoles = migrated;
    }

    public void addCompositeRole(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.compositeRoles == null) {
            this.hotRodEntity.compositeRoles = new HashSet<String>();
        }
        String migrated = p0;
        this.hotRodEntity.updated |= this.hotRodEntity.compositeRoles.add(migrated);
    }

    public void removeCompositeRole(String p0) {
        if (this.hotRodEntity.compositeRoles == null) {
            return;
        }
        boolean removed = this.hotRodEntity.compositeRoles.remove(p0);
        this.hotRodEntity.updated |= removed;
    }

    public Set<String> getCompositeRoles() {
        return this.hotRodEntity.compositeRoles == null ? null : this.hotRodEntity.compositeRoles;
    }

    public String getDescription() {
        return this.hotRodEntity.description == null ? null : this.hotRodEntity.description;
    }

    public void setDescription(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.description, migrated);
        this.hotRodEntity.description = migrated;
    }

    public String getName() {
        return this.hotRodEntity.name == null ? null : this.hotRodEntity.name;
    }

    public void setRealmId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.realmId, migrated);
        this.hotRodEntity.realmId = migrated;
    }

    public String getRealmId() {
        return this.hotRodEntity.realmId == null ? null : this.hotRodEntity.realmId;
    }

    @Override
    public HotRodRoleEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

