/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.liquibase.extension;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.change.AbstractChange;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ChangeStatus;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.AddColumnChange;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import org.keycloak.models.map.storage.jpa.liquibase.extension.GeneratedColumnStatement;
import org.keycloak.models.map.storage.jpa.liquibase.extension.JsonEnabledColumnConfig;

@DatabaseChange(name="addGeneratedColumn", description="Adds new generated columns to a table. The columns must reference a JSON property inside an existing JSON column.", priority=1, appliesTo={"table"})
public class GeneratedColumnChange
extends AbstractChange
implements ChangeWithColumns<JsonEnabledColumnConfig> {
    private final ExtendedAddColumnChange delegate;
    private Map<String, JsonEnabledColumnConfig> configMap = new HashMap<String, JsonEnabledColumnConfig>();

    public GeneratedColumnChange() {
        this.delegate = new ExtendedAddColumnChange();
    }

    @DatabaseChangeProperty(mustEqualExisting="relation.catalog")
    public String getCatalogName() {
        return this.delegate.getCatalogName();
    }

    public void setCatalogName(String catalogName) {
        this.delegate.setCatalogName(catalogName);
    }

    @DatabaseChangeProperty(mustEqualExisting="relation.schema")
    public String getSchemaName() {
        return this.delegate.getSchemaName();
    }

    public void setSchemaName(String schemaName) {
        this.delegate.setSchemaName(schemaName);
    }

    @DatabaseChangeProperty(mustEqualExisting="table", description="Name of the table to add the generated column to")
    public String getTableName() {
        return this.delegate.getTableName();
    }

    public void setTableName(String tableName) {
        this.delegate.setTableName(tableName);
    }

    public void addColumn(JsonEnabledColumnConfig column) {
        this.delegate.addColumn(column);
        this.configMap.put(column.getName(), column);
    }

    @DatabaseChangeProperty(description="Generated columns information", requiredForDatabase={"all"})
    public List<JsonEnabledColumnConfig> getColumns() {
        return this.delegate.getColumns().stream().map(JsonEnabledColumnConfig.class::cast).collect(Collectors.toList());
    }

    public void setColumns(List<JsonEnabledColumnConfig> columns) {
        columns.forEach(arg_0 -> ((ExtendedAddColumnChange)this.delegate).addColumn(arg_0));
        this.configMap = this.getColumns().stream().collect(Collectors.toMap(ColumnConfig::getName, Function.identity()));
    }

    public SqlStatement[] generateStatements(Database database) {
        AddColumnStatement delegateStatement;
        if (database instanceof PostgresDatabase) {
            for (AddColumnConfig config : this.delegate.getColumns()) {
                String columnType = config.getType();
                if (!columnType.equalsIgnoreCase("JSON")) continue;
                config.setType("JSONB");
            }
        }
        if (!(delegateStatement = (AddColumnStatement)Arrays.stream(this.delegate.generateStatements(database)).findFirst().get()).isMultiple()) {
            AddColumnConfig config;
            config = this.configMap.get(delegateStatement.getColumnName());
            if (config != null) {
                return new SqlStatement[]{new GeneratedColumnStatement(delegateStatement, config.getJsonColumn(), config.getJsonProperty())};
            }
        } else {
            List<GeneratedColumnStatement> generatedColumnStatements = delegateStatement.getColumns().stream().filter(c -> this.configMap.containsKey(c.getColumnName())).map(c -> new GeneratedColumnStatement((AddColumnStatement)c, this.configMap.get(c.getColumnName()).getJsonColumn(), this.configMap.get(c.getColumnName()).getJsonProperty())).collect(Collectors.toList());
            return new SqlStatement[]{new GeneratedColumnStatement(generatedColumnStatements)};
        }
        return new SqlStatement[0];
    }

    protected Change[] createInverses() {
        return this.delegate.createInverses();
    }

    public ChangeStatus checkStatus(Database database) {
        return this.delegate.checkStatus(database);
    }

    public String getConfirmationMessage() {
        return this.delegate.getConfirmationMessage();
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog-ext";
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("columns", (Object)this.delegate.getColumns());
        this.delegate.getColumns().stream().map(JsonEnabledColumnConfig.class::cast).forEach(config -> {
            if (config.isAutoIncrement() != null && config.isAutoIncrement().booleanValue()) {
                validationErrors.addError("Generated column " + config.getName() + " cannot be auto-incremented");
            } else if (config.getValueObject() != null) {
                validationErrors.addError("Generated column " + config.getName() + " cannot be configured with a value");
            } else if (config.getDefaultValueObject() != null) {
                validationErrors.addError("Generated column " + config.getName() + " cannot be configured with a default value");
            }
            validationErrors.checkRequiredField("jsonColumn", (Object)config.getJsonColumn());
            validationErrors.checkRequiredField("jsonProperty", (Object)config.getJsonProperty());
        });
        validationErrors.addAll(super.validate(database));
        return validationErrors;
    }

    private static class ExtendedAddColumnChange
    extends AddColumnChange {
        private ExtendedAddColumnChange() {
        }

        public Change[] createInverses() {
            return super.createInverses();
        }
    }
}

