/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.liquibase.updater;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.CockroachDatabase;
import liquibase.exception.LiquibaseException;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.jpa.liquibase.connection.JdbcConnectionFromPool;
import org.keycloak.models.map.storage.jpa.liquibase.connection.MapLiquibaseConnectionProvider;
import org.keycloak.models.map.storage.jpa.updater.MapJpaUpdaterProvider;

public class MapJpaLiquibaseUpdaterProvider
implements MapJpaUpdaterProvider {
    private static final Logger logger = Logger.getLogger(MapJpaLiquibaseUpdaterProvider.class);
    private final KeycloakSession session;

    public MapJpaLiquibaseUpdaterProvider(KeycloakSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Class<?> modelType, Connection connection, String defaultSchema) {
        Class<MapJpaLiquibaseUpdaterProvider> clazz = MapJpaLiquibaseUpdaterProvider.class;
        synchronized (MapJpaLiquibaseUpdaterProvider.class) {
            this.updateSynch(modelType, connection, null, defaultSchema);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(Class<?> modelType, Connection connection, String defaultSchema, File file) {
        Class<MapJpaLiquibaseUpdaterProvider> clazz = MapJpaLiquibaseUpdaterProvider.class;
        synchronized (MapJpaLiquibaseUpdaterProvider.class) {
            this.updateSynch(modelType, connection, file, defaultSchema);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    protected void updateSynch(Class<?> modelType, Connection connection, File file, String defaultSchema) {
        logger.debug((Object)"Starting database update");
        Writer exportWriter = null;
        try (Liquibase liquibase = this.getLiquibase(modelType, connection, defaultSchema);){
            if (file != null) {
                exportWriter = new FileWriter(file);
            }
            this.updateChangeSet(liquibase);
        }
        catch (IOException | SQLException | LiquibaseException e) {
            logger.error((Object)"Error has occurred while updating the database", e);
            throw new RuntimeException("Failed to update database", e);
        }
        finally {
            if (exportWriter != null) {
                try {
                    exportWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void updateChangeSet(Liquibase liquibase) throws LiquibaseException, SQLException {
        String changelog = liquibase.getChangeLogFile();
        List<ChangeSet> changeSets = this.getLiquibaseUnrunChangeSets(liquibase);
        if (!changeSets.isEmpty()) {
            List ranChangeSets = liquibase.getDatabase().getRanChangeSetList();
            if (ranChangeSets.isEmpty()) {
                logger.infov("Initializing database schema. Using changelog {0}", (Object)changelog);
            } else if (logger.isDebugEnabled()) {
                logger.debugv("Updating database from {0} to {1}. Using changelog {2}", (Object)((RanChangeSet)ranChangeSets.get(ranChangeSets.size() - 1)).getId(), (Object)changeSets.get(changeSets.size() - 1).getId(), (Object)changelog);
            } else {
                logger.infov("Updating database. Using changelog {0}", (Object)changelog);
            }
            liquibase.update((Contexts)null);
            logger.debugv("Completed database update for changelog {0}", (Object)changelog);
        } else {
            logger.debugv("Database is up to date for changelog {0}", (Object)changelog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapJpaUpdaterProvider.Status validate(Class<?> modelType, Connection connection, String defaultSchema) {
        Class<MapJpaLiquibaseUpdaterProvider> clazz = MapJpaLiquibaseUpdaterProvider.class;
        synchronized (MapJpaLiquibaseUpdaterProvider.class) {
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.validateSynch(modelType, connection, defaultSchema);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MapJpaUpdaterProvider.Status validateSynch(Class<?> modelType, Connection connection, String defaultSchema) {
        logger.debug((Object)"Validating if database is updated");
        try (Liquibase liquibase = this.getLiquibase(modelType, connection, defaultSchema);){
            MapJpaUpdaterProvider.Status status2 = this.validateChangeSet(liquibase, liquibase.getChangeLogFile());
            if (status2 == MapJpaUpdaterProvider.Status.VALID) return MapJpaUpdaterProvider.Status.VALID;
            MapJpaUpdaterProvider.Status status = status2;
            return status;
        }
        catch (LiquibaseException e) {
            throw new RuntimeException("Failed to validate database", e);
        }
    }

    protected MapJpaUpdaterProvider.Status validateChangeSet(Liquibase liquibase, String changelog) throws LiquibaseException {
        MapJpaUpdaterProvider.Status result;
        List<ChangeSet> changeSets = this.getLiquibaseUnrunChangeSets(liquibase);
        if (!changeSets.isEmpty()) {
            if (changeSets.size() == liquibase.getDatabaseChangeLog().getChangeSets().size()) {
                result = MapJpaUpdaterProvider.Status.EMPTY;
            } else {
                logger.debugf("Validation failed. Database is not up-to-date for changelog %s", (Object)changelog);
                result = MapJpaUpdaterProvider.Status.OUTDATED;
            }
        } else {
            logger.debugf("Validation passed. Database is up-to-date for changelog %s", (Object)changelog);
            result = MapJpaUpdaterProvider.Status.VALID;
        }
        return result;
    }

    private List<ChangeSet> getLiquibaseUnrunChangeSets(Liquibase liquibase) throws LiquibaseException {
        return liquibase.listUnrunChangeSets(null, new LabelExpression(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Liquibase getLiquibase(Class<?> modelType, Connection connection, String defaultSchema) throws LiquibaseException {
        MapLiquibaseConnectionProvider liquibaseProvider = (MapLiquibaseConnectionProvider)this.session.getProvider(MapLiquibaseConnectionProvider.class);
        String modelName = ModelEntityUtil.getModelName(modelType);
        if (modelName == null) {
            throw new IllegalStateException("Cannot find changlelog for modelClass " + modelType.getName());
        }
        String string = modelName = modelName.startsWith("authz-") ? "authz" : modelName;
        if (modelName.equals("auth-events") || modelName.equals("admin-events")) {
            modelName = "events";
        }
        try (Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnectionFromPool(connection));){
            String changelog = database instanceof CockroachDatabase ? "META-INF/jpa-aggregate-changelog.xml" : "META-INF/jpa-" + modelName + "-changelog.xml";
            Liquibase liquibase = liquibaseProvider.getLiquibaseForCustomUpdate(connection, defaultSchema, changelog, this.getClass().getClassLoader(), "databasechangelog");
            return liquibase;
        }
    }

    public void close() {
    }
}

