/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa;

import javax.persistence.EntityManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.SessionAttributesUtils;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.JpaMapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.JpaTransactionWrapper;

public class JpaMapStorageProvider
implements MapStorageProvider {
    private final JpaMapStorageProviderFactory factory;
    private final KeycloakSession session;
    private final EntityManager em;
    private final int factoryId;

    public JpaMapStorageProvider(JpaMapStorageProviderFactory factory, KeycloakSession session, EntityManager em, boolean jtaEnabled, int factoryId) {
        this.factory = factory;
        this.session = session;
        this.em = em;
        this.factoryId = factoryId;
        if (!jtaEnabled) {
            JpaTransactionWrapper jpaTransaction = new JpaTransactionWrapper(em.getTransaction());
            session.getTransactionManager().enlist((KeycloakTransaction)jpaTransaction);
        }
    }

    public void close() {
        this.em.close();
    }

    public <V extends AbstractEntity, M> MapStorage<V, M> getMapStorage(Class<M> modelType, MapStorageProviderFactory.Flag ... flags) {
        this.factory.validateAndUpdateSchema(this.session, modelType);
        return SessionAttributesUtils.createMapStorageIfAbsent((KeycloakSession)this.session, JpaMapStorageProvider.class, modelType, (int)this.factoryId, () -> this.factory.createMapStorage(this.session, modelType, this.em));
    }
}

