/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.authorization.scope;

import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.authorization.entity.MapScopeEntity;
import org.keycloak.models.map.authorization.entity.MapScopeEntityDelegate;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaMapStorage;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaRootEntity;
import org.keycloak.models.map.storage.jpa.authorization.scope.JpaScopeModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.authorization.scope.delagate.JpaScopeDelegateProvider;
import org.keycloak.models.map.storage.jpa.authorization.scope.entity.JpaScopeEntity;

public class JpaScopeMapStorage
extends JpaMapStorage<JpaScopeEntity, MapScopeEntity, Scope> {
    public JpaScopeMapStorage(KeycloakSession session, EntityManager em) {
        super(session, JpaScopeEntity.class, Scope.class, em);
    }

    @Override
    protected Selection<JpaScopeEntity> selectCbConstruct(CriteriaBuilder cb, Root<JpaScopeEntity> root) {
        return cb.construct(JpaScopeEntity.class, new Selection[]{root.get("id"), root.get("version"), root.get("entityVersion"), root.get("realmId"), root.get("resourceServerId"), root.get("name")});
    }

    @Override
    public void setEntityVersion(JpaRootEntity entity) {
        entity.setEntityVersion(Constants.CURRENT_SCHEMA_VERSION_AUTHZ_SCOPE);
    }

    @Override
    public JpaModelCriteriaBuilder createJpaModelCriteriaBuilder() {
        return new JpaScopeModelCriteriaBuilder();
    }

    @Override
    protected MapScopeEntity mapToEntityDelegate(JpaScopeEntity original) {
        return new MapScopeEntityDelegate((DelegateProvider)new JpaScopeDelegateProvider(original, this.em));
    }
}

