/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.authorization.resource.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.common.UuidValidator;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaAttributeEntity;
import org.keycloak.models.map.storage.jpa.JpaRootVersionedEntity;
import org.keycloak.models.map.storage.jpa.authorization.resource.entity.JpaResourceAttributeEntity;
import org.keycloak.models.map.storage.jpa.authorization.resource.entity.JpaResourceMetadata;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;

@Entity
@Table(name="kc_authz_resource", uniqueConstraints={@UniqueConstraint(columnNames={"realmId", "resourceServerId", "name", "owner"})})
@TypeDefs(value={@TypeDef(name="jsonb", typeClass=JsonbType.class)})
public class JpaResourceEntity
extends MapResourceEntity.AbstractMapResourceEntity
implements JpaRootVersionedEntity,
ManagedEntity,
PersistentAttributeInterceptable {
    @Id
    @Column
    private UUID id;
    @Version
    @Column
    private int version;
    @Type(type="jsonb")
    @Column(columnDefinition="jsonb")
    private JpaResourceMetadata metadata;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private Integer entityVersion;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String realmId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private UUID resourceServerId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String name;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String type;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String owner;
    @Column(name="uri")
    @ElementCollection
    @CollectionTable(name="kc_authz_resource_uri", joinColumns={@JoinColumn(name="resource_id", nullable=false)})
    private Set<String> uris;
    @Column(name="scope_id")
    @ElementCollection
    @CollectionTable(name="kc_authz_resource_scope", joinColumns={@JoinColumn(name="resource_id", nullable=false)})
    private Set<UUID> scopeIds;
    @OneToMany(mappedBy="root", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    private Set<JpaResourceAttributeEntity> attributes;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaResourceEntity() {
        this.$$_hibernate_write_uris(new HashSet());
        this.$$_hibernate_write_scopeIds(new HashSet());
        this.attributes = new HashSet<JpaResourceAttributeEntity>();
        this.metadata = new JpaResourceMetadata();
    }

    public JpaResourceEntity(DeepCloner cloner) {
        this.$$_hibernate_write_uris(new HashSet());
        this.$$_hibernate_write_scopeIds(new HashSet());
        this.attributes = new HashSet<JpaResourceAttributeEntity>();
        this.metadata = new JpaResourceMetadata(cloner);
    }

    public JpaResourceEntity(UUID id, int version, Integer entityVersion, String realmId, UUID resourceServerId, String name, String type, String owner) {
        this.$$_hibernate_write_uris(new HashSet());
        this.$$_hibernate_write_scopeIds(new HashSet());
        this.attributes = new HashSet<JpaResourceAttributeEntity>();
        this.$$_hibernate_write_id(id);
        this.$$_hibernate_write_version(version);
        this.$$_hibernate_write_entityVersion(entityVersion);
        this.$$_hibernate_write_realmId(realmId);
        this.$$_hibernate_write_resourceServerId(resourceServerId);
        this.$$_hibernate_write_name(name);
        this.$$_hibernate_write_type(type);
        this.$$_hibernate_write_owner(owner);
        this.metadata = null;
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    @Override
    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    @Override
    public void setEntityVersion(Integer entityVersion) {
        this.$$_hibernate_read_metadata().setEntityVersion(entityVersion);
    }

    @Override
    public Integer getCurrentSchemaVersion() {
        return Constants.CURRENT_SCHEMA_VERSION_AUTHZ_RESOURCE;
    }

    @Override
    public int getVersion() {
        return this.$$_hibernate_read_version();
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        String validatedId = UuidValidator.validateAndConvert((String)id);
        this.$$_hibernate_write_id(UUID.fromString(validatedId));
    }

    public String getRealmId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getRealmId();
        }
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_read_metadata().setRealmId(realmId);
    }

    public String getName() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getName();
        }
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_read_metadata().setName(name);
    }

    public String getDisplayName() {
        return this.$$_hibernate_read_metadata().getDisplayName();
    }

    public void setDisplayName(String displayName) {
        this.$$_hibernate_read_metadata().setDisplayName(displayName);
    }

    public Set<String> getUris() {
        return this.$$_hibernate_read_uris();
    }

    public void setUris(Set<String> uris) {
        uris = uris == null ? new HashSet() : uris;
        this.$$_hibernate_write_uris(uris);
    }

    public String getType() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getType();
        }
        return this.$$_hibernate_read_type();
    }

    public void setType(String type) {
        this.$$_hibernate_read_metadata().setType(type);
    }

    public String getIconUri() {
        return this.$$_hibernate_read_metadata().getIconUri();
    }

    public void setIconUri(String iconUri) {
        this.$$_hibernate_read_metadata().setIconUri(iconUri);
    }

    public String getOwner() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getOwner();
        }
        return this.$$_hibernate_read_owner();
    }

    public void setOwner(String owner) {
        this.$$_hibernate_read_metadata().setOwner(owner);
    }

    public Boolean isOwnerManagedAccess() {
        return this.$$_hibernate_read_metadata().isOwnerManagedAccess();
    }

    public void setOwnerManagedAccess(Boolean ownerManagedAccess) {
        this.$$_hibernate_read_metadata().setOwnerManagedAccess(ownerManagedAccess);
    }

    public void setResourceServerId(String resourceServerId) {
        this.$$_hibernate_read_metadata().setResourceServerId(resourceServerId);
    }

    public String getResourceServerId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getResourceServerId();
        }
        return this.$$_hibernate_read_resourceServerId() == null ? null : this.$$_hibernate_read_resourceServerId().toString();
    }

    public Set<String> getScopeIds() {
        return this.$$_hibernate_read_scopeIds().stream().map(UUID::toString).collect(Collectors.toSet());
    }

    public void setScopeIds(Set<String> scopeIds) {
        scopeIds = scopeIds == null ? new HashSet() : scopeIds;
        this.$$_hibernate_write_scopeIds(scopeIds.stream().map(arg_0 -> ((StringKeyConverter.UUIDKey)StringKeyConverter.UUIDKey.INSTANCE).fromString(arg_0)).collect(Collectors.toSet()));
    }

    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (JpaResourceAttributeEntity attribute : this.$$_hibernate_read_attributes()) {
            List values = result.getOrDefault(attribute.getName(), new LinkedList());
            values.add(attribute.getValue());
            result.put(attribute.getName(), values);
        }
        return result;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.$$_hibernate_read_attributes().clear();
        if (attributes != null) {
            for (Map.Entry<String, List<String>> attrEntry : attributes.entrySet()) {
                this.setAttribute(attrEntry.getKey(), attrEntry.getValue());
            }
        }
    }

    public List<String> getAttribute(String name) {
        return this.$$_hibernate_read_attributes().stream().filter(a -> Objects.equals(a.getName(), name)).map(JpaAttributeEntity::getValue).collect(Collectors.toList());
    }

    public void setAttribute(String name, List<String> values) {
        this.removeAttribute(name);
        for (String value : values) {
            JpaResourceAttributeEntity attribute = new JpaResourceAttributeEntity(this, name, value);
            this.$$_hibernate_read_attributes().add(attribute);
        }
    }

    public void removeAttribute(String name) {
        this.$$_hibernate_read_attributes().removeIf(attr -> Objects.equals(attr.getName(), name));
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaResourceEntity)) {
            return false;
        }
        return Objects.equals(this.getId(), ((JpaResourceEntity)obj).getId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public int $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().readInt((Object)this, "version", this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(int n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().writeInt((Object)this, "version", this.version, n);
            return;
        }
        this.version = n;
    }

    public JpaResourceMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaResourceMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public UUID $$_hibernate_read_resourceServerId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServerId = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "resourceServerId", (Object)this.resourceServerId);
        }
        return this.resourceServerId;
    }

    public void $$_hibernate_write_resourceServerId(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServerId = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resourceServerId", (Object)this.resourceServerId, (Object)uUID);
            return;
        }
        this.resourceServerId = uUID;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_type() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.type = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "type", (Object)this.type);
        }
        return this.type;
    }

    public void $$_hibernate_write_type(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.type = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "type", (Object)this.type, (Object)string);
            return;
        }
        this.type = string;
    }

    public String $$_hibernate_read_owner() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "owner", (Object)this.owner);
        }
        return this.owner;
    }

    public void $$_hibernate_write_owner(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "owner", (Object)this.owner, (Object)string);
            return;
        }
        this.owner = string;
    }

    public Set $$_hibernate_read_uris() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.uris = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "uris", this.uris);
        }
        return this.uris;
    }

    public void $$_hibernate_write_uris(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.uris = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "uris", this.uris, (Object)set);
            return;
        }
        this.uris = set;
    }

    public Set $$_hibernate_read_scopeIds() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopeIds = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "scopeIds", this.scopeIds);
        }
        return this.scopeIds;
    }

    public void $$_hibernate_write_scopeIds(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopeIds = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "scopeIds", this.scopeIds, (Object)set);
            return;
        }
        this.scopeIds = set;
    }

    public Set $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }
}

