/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.lock;

import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.lock.MapLockEntity;
import org.keycloak.models.map.lock.MapLockEntityDelegate;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaMapStorage;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaRootEntity;
import org.keycloak.models.map.storage.jpa.lock.JpaLockModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.lock.delegate.JpaLockDelegateProvider;
import org.keycloak.models.map.storage.jpa.lock.entity.JpaLockEntity;

public class JpaLockMapStorage
extends JpaMapStorage<JpaLockEntity, MapLockEntity, MapLockEntity> {
    public JpaLockMapStorage(KeycloakSession session, EntityManager em) {
        super(session, JpaLockEntity.class, MapLockEntity.class, em);
    }

    @Override
    protected Selection<JpaLockEntity> selectCbConstruct(CriteriaBuilder cb, Root<JpaLockEntity> root) {
        return cb.construct(JpaLockEntity.class, new Selection[]{root.get("id"), root.get("version"), root.get("entityVersion"), root.get("name")});
    }

    @Override
    public void setEntityVersion(JpaRootEntity entity) {
        entity.setEntityVersion(Constants.CURRENT_SCHEMA_VERSION_LOCK);
    }

    @Override
    public JpaModelCriteriaBuilder createJpaModelCriteriaBuilder() {
        return new JpaLockModelCriteriaBuilder();
    }

    @Override
    protected MapLockEntity mapToEntityDelegate(JpaLockEntity original) {
        return new MapLockEntityDelegate((DelegateProvider)new JpaLockDelegateProvider(original, this.em));
    }
}

