/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.realm.delegate;

import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.realm.MapRealmEntityFields;
import org.keycloak.models.map.storage.jpa.JpaDelegateProvider;
import org.keycloak.models.map.storage.jpa.realm.entity.JpaRealmEntity;

public class JpaRealmDelegateProvider
extends JpaDelegateProvider<JpaRealmEntity>
implements DelegateProvider<MapRealmEntity> {
    private final EntityManager em;

    public JpaRealmDelegateProvider(JpaRealmEntity delegate, EntityManager em) {
        super(delegate);
        this.em = em;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapRealmEntity getDelegate(boolean isRead, Enum<? extends EntityField<MapRealmEntity>> field, Object ... parameters) {
        if (((JpaRealmEntity)this.getDelegate()).isMetadataInitialized()) {
            return (MapRealmEntity)this.getDelegate();
        }
        if (isRead) {
            if (!(field instanceof MapRealmEntityFields)) throw new IllegalStateException("Not a valid realm field: " + field);
            switch ((MapRealmEntityFields)field) {
                case ID: 
                case NAME: 
                case DISPLAY_NAME: 
                case DISPLAY_NAME_HTML: 
                case ENABLED: {
                    return (MapRealmEntity)this.getDelegate();
                }
                case ATTRIBUTES: {
                    this.setDelegateWithAssociation("attributes");
                    return (MapRealmEntity)this.getDelegate();
                }
                case COMPONENTS: {
                    this.setDelegateWithAssociation("components");
                    return (MapRealmEntity)this.getDelegate();
                }
                default: {
                    this.setDelegate((JpaRealmEntity)this.em.find(JpaRealmEntity.class, (Object)UUID.fromString(((JpaRealmEntity)this.getDelegate()).getId())));
                    return (MapRealmEntity)this.getDelegate();
                }
            }
        } else {
            this.setDelegate((JpaRealmEntity)this.em.find(JpaRealmEntity.class, (Object)UUID.fromString(((JpaRealmEntity)this.getDelegate()).getId())));
        }
        return (MapRealmEntity)this.getDelegate();
    }

    protected void setDelegateWithAssociation(String associationName) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(JpaRealmEntity.class);
        Root root = query.from(JpaRealmEntity.class);
        root.fetch(associationName, JoinType.LEFT);
        query.select((Selection)root).where((Expression)cb.equal((Expression)root.get("id"), (Object)UUID.fromString(((JpaRealmEntity)this.getDelegate()).getId())));
        this.setDelegate((JpaRealmEntity)this.em.createQuery(query).getSingleResult());
    }
}

