/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.authSession.entity;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaChildEntity;
import org.keycloak.models.map.storage.jpa.JpaRootVersionedEntity;
import org.keycloak.models.map.storage.jpa.authSession.entity.JpaAuthenticationSessionMetadata;
import org.keycloak.models.map.storage.jpa.authSession.entity.JpaRootAuthenticationSessionEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.sessions.CommonClientSessionModel;

@Entity
@Table(name="kc_auth_session")
@EnhancementInfo(version="6.2.7.Final")
public class JpaAuthenticationSessionEntity
extends UpdatableEntity.Impl
implements MapAuthenticationSessionEntity,
JpaRootVersionedEntity,
JpaChildEntity<JpaRootAuthenticationSessionEntity>,
ManagedEntity,
PersistentAttributeInterceptable {
    public static final String TABLE_NAME = "kc_auth_session";
    @Id
    @Column
    @GeneratedValue
    UUID id;
    @Version
    @Column
    int version;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Integer entityVersion;
    @Type(value=JsonbType.class)
    @Column(columnDefinition="jsonb")
    JpaAuthenticationSessionMetadata metadata;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_root")
    JpaRootAuthenticationSessionEntity root;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaAuthenticationSessionEntity() {
        this.metadata = new JpaAuthenticationSessionMetadata();
    }

    public JpaAuthenticationSessionEntity(DeepCloner cloner) {
        this.metadata = new JpaAuthenticationSessionMetadata(cloner);
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    @Override
    public JpaRootAuthenticationSessionEntity getParent() {
        return this.$$_hibernate_read_root();
    }

    public void setParent(JpaRootAuthenticationSessionEntity root) {
        this.$$_hibernate_write_root(root);
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id == null ? null : UUID.fromString(id));
    }

    @Override
    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    @Override
    public void setEntityVersion(Integer version) {
        this.$$_hibernate_read_metadata().setEntityVersion(version);
    }

    @Override
    public Integer getCurrentSchemaVersion() {
        return Constants.CURRENT_SCHEMA_VERSION_AUTH_SESSION;
    }

    @Override
    public int getVersion() {
        return this.$$_hibernate_read_version();
    }

    public String getTabId() {
        return this.$$_hibernate_read_metadata().getTabId();
    }

    public void setTabId(String tabId) {
        this.$$_hibernate_read_metadata().setTabId(tabId);
    }

    public Map<String, String> getUserSessionNotes() {
        return this.$$_hibernate_read_metadata().getUserSessionNotes();
    }

    public void setUserSessionNotes(Map<String, String> userSessionNotes) {
        this.$$_hibernate_read_metadata().setUserSessionNotes(userSessionNotes);
    }

    public void setUserSessionNote(String name, String value) {
        this.$$_hibernate_read_metadata().setUserSessionNote(name, value);
    }

    public String getClientUUID() {
        return this.$$_hibernate_read_metadata().getClientUUID();
    }

    public void setClientUUID(String clientUUID) {
        this.$$_hibernate_read_metadata().setClientUUID(clientUUID);
    }

    public String getAuthUserId() {
        return this.$$_hibernate_read_metadata().getAuthUserId();
    }

    public void setAuthUserId(String authUserId) {
        this.$$_hibernate_read_metadata().setAuthUserId(authUserId);
    }

    public Long getTimestamp() {
        return this.$$_hibernate_read_metadata().getTimestamp();
    }

    public void setTimestamp(Long timestamp) {
        this.$$_hibernate_read_metadata().setTimestamp(timestamp);
    }

    public String getRedirectUri() {
        return this.$$_hibernate_read_metadata().getRedirectUri();
    }

    public void setRedirectUri(String redirectUri) {
        this.$$_hibernate_read_metadata().setRedirectUri(redirectUri);
    }

    public String getAction() {
        return this.$$_hibernate_read_metadata().getAction();
    }

    public void setAction(String action) {
        this.$$_hibernate_read_metadata().setAction(action);
    }

    public Set<String> getClientScopes() {
        return this.$$_hibernate_read_metadata().getClientScopes();
    }

    public void setClientScopes(Set<String> clientScopes) {
        this.$$_hibernate_read_metadata().setClientScopes(clientScopes);
    }

    public Set<String> getRequiredActions() {
        return this.$$_hibernate_read_metadata().getRequiredActions();
    }

    public void setRequiredActions(Set<String> requiredActions) {
        this.$$_hibernate_read_metadata().setRequiredActions(requiredActions);
    }

    public void addRequiredAction(String requiredAction) {
        this.$$_hibernate_read_metadata().addRequiredAction(requiredAction);
    }

    public void removeRequiredAction(String action) {
        this.$$_hibernate_read_metadata().removeRequiredAction(action);
    }

    public String getProtocol() {
        return this.$$_hibernate_read_metadata().getProtocol();
    }

    public void setProtocol(String protocol) {
        this.$$_hibernate_read_metadata().setProtocol(protocol);
    }

    public Map<String, String> getClientNotes() {
        return this.$$_hibernate_read_metadata().getClientNotes();
    }

    public void setClientNotes(Map<String, String> clientNotes) {
        this.$$_hibernate_read_metadata().setClientNotes(clientNotes);
    }

    public void setClientNote(String name, String value) {
        this.$$_hibernate_read_metadata().setClientNote(name, value);
    }

    public void removeClientNote(String name) {
        this.$$_hibernate_read_metadata().removeClientNote(name);
    }

    public Map<String, String> getAuthNotes() {
        return this.$$_hibernate_read_metadata().getAuthNotes();
    }

    public void setAuthNotes(Map<String, String> authNotes) {
        this.$$_hibernate_read_metadata().setAuthNotes(authNotes);
    }

    public void setAuthNote(String name, String value) {
        this.$$_hibernate_read_metadata().setAuthNote(name, value);
    }

    public void removeAuthNote(String name) {
        this.$$_hibernate_read_metadata().removeAuthNote(name);
    }

    public Map<String, CommonClientSessionModel.ExecutionStatus> getExecutionStatuses() {
        return this.$$_hibernate_read_metadata().getExecutionStatuses();
    }

    public void setExecutionStatuses(Map<String, CommonClientSessionModel.ExecutionStatus> executionStatus) {
        this.$$_hibernate_read_metadata().setExecutionStatuses(executionStatus);
    }

    public void setExecutionStatus(String authenticator, CommonClientSessionModel.ExecutionStatus status) {
        this.$$_hibernate_read_metadata().setExecutionStatus(authenticator, status);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaAuthenticationSessionEntity)) {
            return false;
        }
        return Objects.equals(this.getId(), ((JpaAuthenticationSessionEntity)obj).getId()) && Objects.equals(this.getTabId(), ((JpaAuthenticationSessionEntity)obj).getTabId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public int $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().readInt((Object)this, "version", this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(int n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().writeInt((Object)this, "version", this.version, n);
            return;
        }
        this.version = n;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public JpaAuthenticationSessionMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaAuthenticationSessionMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public JpaRootAuthenticationSessionEntity $$_hibernate_read_root() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.root = (JpaRootAuthenticationSessionEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "root", (Object)this.root);
        }
        return this.root;
    }

    public void $$_hibernate_write_root(JpaRootAuthenticationSessionEntity jpaRootAuthenticationSessionEntity) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.root = (JpaRootAuthenticationSessionEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "root", (Object)this.root, (Object)jpaRootAuthenticationSessionEntity);
            return;
        }
        this.root = jpaRootAuthenticationSessionEntity;
    }
}

