/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap.store;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.keycloak.models.ModelException;

public class LdapMapUtil {
    public static String formatDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("You must provide a date.");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'.0Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    public static Date parseDate(String date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            if (date.endsWith("Z")) {
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                dateFormat.setTimeZone(TimeZone.getDefault());
            }
            return dateFormat.parse(date);
        }
        catch (Exception e) {
            throw new ModelException("Error converting ldap date.", (Throwable)e);
        }
    }

    public static String convertObjectGUIDToByteString(byte[] objectGUID) {
        StringBuilder result = new StringBuilder();
        for (byte b : objectGUID) {
            String transformed = LdapMapUtil.prefixZeros(b & 0xFF);
            result.append("\\");
            result.append(transformed);
        }
        return result.toString();
    }

    public static String convertGUIDToEdirectoryHexString(String guid) {
        String withoutDash = guid.replace("-", "");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < withoutDash.length(); ++i) {
            result.append("\\");
            result.append(withoutDash.charAt(i));
            result.append(withoutDash.charAt(++i));
        }
        return result.toString().toUpperCase();
    }

    public static byte[] encodeObjectGUID(String displayString) {
        byte[] objectGUID = new byte[]{(byte)((Character.digit(displayString.charAt(6), 16) << 4) + Character.digit(displayString.charAt(7), 16)), (byte)((Character.digit(displayString.charAt(4), 16) << 4) + Character.digit(displayString.charAt(5), 16)), (byte)((Character.digit(displayString.charAt(2), 16) << 4) + Character.digit(displayString.charAt(3), 16)), (byte)((Character.digit(displayString.charAt(0), 16) << 4) + Character.digit(displayString.charAt(1), 16)), (byte)((Character.digit(displayString.charAt(11), 16) << 4) + Character.digit(displayString.charAt(12), 16)), (byte)((Character.digit(displayString.charAt(9), 16) << 4) + Character.digit(displayString.charAt(10), 16)), (byte)((Character.digit(displayString.charAt(16), 16) << 4) + Character.digit(displayString.charAt(17), 16)), (byte)((Character.digit(displayString.charAt(14), 16) << 4) + Character.digit(displayString.charAt(15), 16)), (byte)((Character.digit(displayString.charAt(19), 16) << 4) + Character.digit(displayString.charAt(20), 16)), (byte)((Character.digit(displayString.charAt(21), 16) << 4) + Character.digit(displayString.charAt(22), 16)), (byte)((Character.digit(displayString.charAt(24), 16) << 4) + Character.digit(displayString.charAt(25), 16)), (byte)((Character.digit(displayString.charAt(26), 16) << 4) + Character.digit(displayString.charAt(27), 16)), (byte)((Character.digit(displayString.charAt(28), 16) << 4) + Character.digit(displayString.charAt(29), 16)), (byte)((Character.digit(displayString.charAt(30), 16) << 4) + Character.digit(displayString.charAt(31), 16)), (byte)((Character.digit(displayString.charAt(32), 16) << 4) + Character.digit(displayString.charAt(33), 16)), (byte)((Character.digit(displayString.charAt(34), 16) << 4) + Character.digit(displayString.charAt(35), 16))};
        return objectGUID;
    }

    public static String decodeObjectGUID(byte[] objectGUID) {
        return LdapMapUtil.convertToDashedString(objectGUID);
    }

    public static String decodeGuid(byte[] guid) {
        byte[] withBigEndian = new byte[]{guid[3], guid[2], guid[1], guid[0], guid[5], guid[4], guid[7], guid[6], guid[8], guid[9], guid[10], guid[11], guid[12], guid[13], guid[14], guid[15]};
        return LdapMapUtil.convertToDashedString(withBigEndian);
    }

    private static String convertToDashedString(byte[] objectGUID) {
        return LdapMapUtil.prefixZeros(objectGUID[3] & 0xFF) + LdapMapUtil.prefixZeros(objectGUID[2] & 0xFF) + LdapMapUtil.prefixZeros(objectGUID[1] & 0xFF) + LdapMapUtil.prefixZeros(objectGUID[0] & 0xFF) + "-" + LdapMapUtil.prefixZeros(objectGUID[5] & 0xFF) + LdapMapUtil.prefixZeros(objectGUID[4] & 0xFF) + "-" + LdapMapUtil.prefixZeros(objectGUID[7] & 0xFF) + LdapMapUtil.prefixZeros(objectGUID[6] & 0xFF) + "-" + LdapMapUtil.prefixZeros(objectGUID[8] & 0xFF) + LdapMapUtil.prefixZeros(objectGUID[9] & 0xFF) + "-" + LdapMapUtil.prefixZeros(objectGUID[10] & 0xFF) + LdapMapUtil.prefixZeros(objectGUID[11] & 0xFF) + LdapMapUtil.prefixZeros(objectGUID[12] & 0xFF) + LdapMapUtil.prefixZeros(objectGUID[13] & 0xFF) + LdapMapUtil.prefixZeros(objectGUID[14] & 0xFF) + LdapMapUtil.prefixZeros(objectGUID[15] & 0xFF);
    }

    private static String prefixZeros(int value) {
        if (value <= 15) {
            return "0" + Integer.toHexString(value);
        }
        return Integer.toHexString(value);
    }
}

