/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import java.util.UUID;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserProviderFactory;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.map.user.MapUserProvider;

public class MapUserProviderFactory
extends AbstractMapProviderFactory<UserProvider>
implements UserProviderFactory {
    private MapStorage<UUID, MapUserEntity> store;

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        MapStorageProvider sp = (MapStorageProvider)factory.getProviderFactory(MapStorageProvider.class);
        this.store = sp.getStorage("users", UUID.class, MapUserEntity.class, new MapStorageProvider.Flag[0]);
    }

    public UserProvider create(KeycloakSession session) {
        return new MapUserProvider(session, this.store);
    }
}

