/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.map.authorization.adapter.MapResourceServerAdapter;
import org.keycloak.models.map.authorization.entity.MapResourceServerEntity;
import org.keycloak.models.map.common.MapStorageUtils;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.storage.StorageId;

public class MapResourceServerStore<K>
implements ResourceServerStore {
    private static final Logger LOG = Logger.getLogger(MapResourceServerStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapKeycloakTransaction<K, MapResourceServerEntity<K>, ResourceServer> tx;
    private final MapStorage<K, MapResourceServerEntity<K>, ResourceServer> resourceServerStore;

    public MapResourceServerStore(KeycloakSession session, MapStorage<K, MapResourceServerEntity<K>, ResourceServer> resourceServerStore, AuthorizationProvider provider) {
        this.resourceServerStore = resourceServerStore;
        this.tx = resourceServerStore.createTransaction(session);
        this.authorizationProvider = provider;
        session.getTransactionManager().enlist(this.tx);
    }

    private ResourceServer entityToAdapter(MapResourceServerEntity<K> origEntity) {
        if (origEntity == null) {
            return null;
        }
        return new MapResourceServerAdapter<K>(MapStorageUtils.registerEntityForChanges(this.tx, origEntity), this.authorizationProvider.getStoreFactory()){

            public String getId() {
                return MapResourceServerStore.this.resourceServerStore.getKeyConvertor().keyToString(((MapResourceServerEntity)this.entity).getId());
            }
        };
    }

    public ResourceServer create(String clientId) {
        LOG.tracef("create(%s)%s", (Object)clientId, StackUtil.getShortStackTrace());
        if (clientId == null) {
            return null;
        }
        if (!StorageId.isLocalStorage((String)clientId)) {
            throw new ModelException("Creating resource server from federated ClientModel not supported");
        }
        if (this.tx.read(this.resourceServerStore.getKeyConvertor().fromString(clientId)) != null) {
            throw new ModelDuplicateException("Resource server already exists: " + clientId);
        }
        MapResourceServerEntity<K> entity = new MapResourceServerEntity<K>(this.resourceServerStore.getKeyConvertor().fromString(clientId));
        this.tx.create(entity.getId(), entity);
        return this.entityToAdapter(entity);
    }

    public void delete(String id) {
        LOG.tracef("delete(%s, %s)%s", (Object)id, StackUtil.getShortStackTrace());
        if (id == null) {
            return;
        }
        PolicyStore policyStore = this.authorizationProvider.getStoreFactory().getPolicyStore();
        policyStore.findByResourceServer(id).stream().map(Policy::getId).forEach(arg_0 -> ((PolicyStore)policyStore).delete(arg_0));
        PermissionTicketStore permissionTicketStore = this.authorizationProvider.getStoreFactory().getPermissionTicketStore();
        permissionTicketStore.findByResourceServer(id).stream().map(PermissionTicket::getId).forEach(arg_0 -> ((PermissionTicketStore)permissionTicketStore).delete(arg_0));
        ResourceStore resourceStore = this.authorizationProvider.getStoreFactory().getResourceStore();
        resourceStore.findByResourceServer(id).stream().map(Resource::getId).forEach(arg_0 -> ((ResourceStore)resourceStore).delete(arg_0));
        ScopeStore scopeStore = this.authorizationProvider.getStoreFactory().getScopeStore();
        scopeStore.findByResourceServer(id).stream().map(Scope::getId).forEach(arg_0 -> ((ScopeStore)scopeStore).delete(arg_0));
        this.tx.delete(this.resourceServerStore.getKeyConvertor().fromString(id));
    }

    public ResourceServer findById(String id) {
        LOG.tracef("findById(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        if (id == null) {
            return null;
        }
        MapResourceServerEntity<K> entity = this.tx.read(this.resourceServerStore.getKeyConvertor().fromStringSafe(id));
        return this.entityToAdapter(entity);
    }
}

