/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.client.MapClientAdapter;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.common.MapStorageUtils;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.StreamsUtil;

public class MapClientProvider<K>
implements ClientProvider {
    private static final Logger LOG = Logger.getLogger(MapClientProvider.class);
    private final KeycloakSession session;
    final MapKeycloakTransaction<K, MapClientEntity<K>, ClientModel> tx;
    private final MapStorage<K, MapClientEntity<K>, ClientModel> clientStore;
    private final ConcurrentMap<K, ConcurrentMap<String, Integer>> clientRegisteredNodesStore;
    private static final Comparator<MapClientEntity> COMPARE_BY_CLIENT_ID = Comparator.comparing(MapClientEntity::getClientId);

    public MapClientProvider(KeycloakSession session, MapStorage<K, MapClientEntity<K>, ClientModel> clientStore, ConcurrentMap<K, ConcurrentMap<String, Integer>> clientRegisteredNodesStore) {
        this.session = session;
        this.clientStore = clientStore;
        this.clientRegisteredNodesStore = clientRegisteredNodesStore;
        this.tx = clientStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private ClientModel.ClientUpdatedEvent clientUpdatedEvent(final ClientModel c) {
        return new ClientModel.ClientUpdatedEvent(){

            public ClientModel getUpdatedClient() {
                return c;
            }

            public KeycloakSession getKeycloakSession() {
                return MapClientProvider.this.session;
            }
        };
    }

    private Function<MapClientEntity<K>, ClientModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapClientAdapter<K>(this.session, realm, MapStorageUtils.registerEntityForChanges(this.tx, origEntity), (MapClientEntity)origEntity){
            final /* synthetic */ MapClientEntity val$origEntity;
            {
                this.val$origEntity = mapClientEntity;
                super(session, realm, entity);
            }

            public String getId() {
                return MapClientProvider.this.clientStore.getKeyConvertor().keyToString(((MapClientEntity)this.entity).getId());
            }

            public void updateClient() {
                LOG.tracef("updateClient(%s)%s", (Object)this.realm, this.val$origEntity.getId(), StackUtil.getShortStackTrace());
                this.session.getKeycloakSessionFactory().publish((ProviderEvent)MapClientProvider.this.clientUpdatedEvent(this));
            }

            public Map<String, Integer> getRegisteredNodes() {
                return MapClientProvider.this.clientRegisteredNodesStore.computeIfAbsent(((MapClientEntity)this.entity).getId(), k -> new ConcurrentHashMap());
            }

            public void registerNode(String nodeHost, int registrationTime) {
                Map<String, Integer> value = this.getRegisteredNodes();
                value.put(nodeHost, registrationTime);
            }

            public void unregisterNode(String nodeHost) {
                this.getRegisteredNodes().remove(nodeHost);
            }
        };
    }

    private Predicate<MapClientEntity<K>> entityRealmFilter(RealmModel realm) {
        if (realm == null || realm.getId() == null) {
            return c -> false;
        }
        String realmId = realm.getId();
        return entity -> Objects.equals(realmId, entity.getRealmId());
    }

    public Stream<ClientModel> getClientsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        return StreamsUtil.paginatedStream(this.getClientsStream(realm), (Integer)firstResult, (Integer)maxResults);
    }

    public Stream<ClientModel> getClientsStream(RealmModel realm) {
        ModelCriteriaBuilder<ClientModel> mcb = this.clientStore.createCriteriaBuilder().compare((SearchableModelField<ClientModel>)ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        return this.tx.read(mcb).sorted(COMPARE_BY_CLIENT_ID).map(this.entityToAdapterFunc(realm));
    }

    public ClientModel addClient(RealmModel realm, String id, String clientId) {
        K entityId;
        K k = entityId = id == null ? this.clientStore.getKeyConvertor().yieldNewUniqueKey() : this.clientStore.getKeyConvertor().fromString(id);
        if (clientId == null) {
            clientId = entityId.toString();
        }
        LOG.tracef("addClient(%s, %s, %s)%s", new Object[]{realm, id, clientId, StackUtil.getShortStackTrace()});
        MapClientEntity<K> entity = new MapClientEntity<K>(entityId, realm.getId());
        entity.setClientId(clientId);
        entity.setEnabled(true);
        entity.setStandardFlowEnabled(true);
        if (this.tx.read(entity.getId()) != null) {
            throw new ModelDuplicateException("Client exists: " + id);
        }
        this.tx.create(entity.getId(), entity);
        ClientModel resource = this.entityToAdapterFunc(realm).apply(entity);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)((ClientModel.ClientCreationEvent)() -> resource));
        resource.updateClient();
        return resource;
    }

    public Stream<ClientModel> getAlwaysDisplayInConsoleClientsStream(RealmModel realm) {
        return this.getClientsStream(realm).filter(ClientModel::isAlwaysDisplayInConsole);
    }

    public void removeClients(RealmModel realm) {
        LOG.tracef("removeClients(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.getClientsStream(realm).map(ClientModel::getId).collect(Collectors.toSet()).forEach(cid -> this.removeClient(realm, (String)cid));
    }

    public boolean removeClient(RealmModel realm, String id) {
        if (id == null) {
            return false;
        }
        LOG.tracef("removeClient(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        final ClientModel client = this.getClientById(realm, id);
        if (client == null) {
            return false;
        }
        this.session.users().preRemove(realm, client);
        this.session.roles().removeRoles(client);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new ClientModel.ClientRemovedEvent(){

            public ClientModel getClient() {
                return client;
            }

            public KeycloakSession getKeycloakSession() {
                return MapClientProvider.this.session;
            }
        });
        this.tx.delete(this.clientStore.getKeyConvertor().fromString(id));
        return true;
    }

    public long getClientsCount(RealmModel realm) {
        ModelCriteriaBuilder<ClientModel> mcb = this.clientStore.createCriteriaBuilder().compare((SearchableModelField<ClientModel>)ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        return this.clientStore.getCount(mcb);
    }

    public ClientModel getClientById(RealmModel realm, String id) {
        if (id == null) {
            return null;
        }
        LOG.tracef("getClientById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        MapClientEntity<K> entity = this.tx.read(this.clientStore.getKeyConvertor().fromStringSafe(id));
        return entity == null || !this.entityRealmFilter(realm).test(entity) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public ClientModel getClientByClientId(RealmModel realm, String clientId) {
        if (clientId == null) {
            return null;
        }
        LOG.tracef("getClientByClientId(%s, %s)%s", (Object)realm, (Object)clientId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<ClientModel> mcb = this.clientStore.createCriteriaBuilder().compare((SearchableModelField<ClientModel>)ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<ClientModel>)ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.ILIKE, clientId);
        return this.tx.read(mcb).map(this.entityToAdapterFunc(realm)).findFirst().orElse(null);
    }

    public Stream<ClientModel> searchClientsByClientIdStream(RealmModel realm, String clientId, Integer firstResult, Integer maxResults) {
        if (clientId == null) {
            return Stream.empty();
        }
        ModelCriteriaBuilder<ClientModel> mcb = this.clientStore.createCriteriaBuilder().compare((SearchableModelField<ClientModel>)ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<ClientModel>)ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.ILIKE, "%" + clientId + "%");
        Stream<MapClientEntity> s = this.tx.read(mcb).sorted(COMPARE_BY_CLIENT_ID);
        return StreamsUtil.paginatedStream(s, (Integer)firstResult, (Integer)maxResults).map(this.entityToAdapterFunc(realm));
    }

    public Stream<ClientModel> searchClientsByAttributes(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        ModelCriteriaBuilder<ClientModel> mcb = this.clientStore.createCriteriaBuilder().compare((SearchableModelField<ClientModel>)ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            mcb = mcb.compare((SearchableModelField<ClientModel>)ClientModel.SearchableFields.ATTRIBUTE, ModelCriteriaBuilder.Operator.EQ, entry.getKey(), entry.getValue());
        }
        Stream<MapClientEntity> s = this.tx.read(mcb).sorted(COMPARE_BY_CLIENT_ID);
        return StreamsUtil.paginatedStream(s, (Integer)firstResult, (Integer)maxResults).map(this.entityToAdapterFunc(realm));
    }

    public void addClientScopes(RealmModel realm, ClientModel client, Set<ClientScopeModel> clientScopes, boolean defaultScope) {
        String id = client.getId();
        MapClientEntity entity = this.tx.read(this.clientStore.getKeyConvertor().fromString(id));
        if (entity == null) {
            return;
        }
        String clientProtocol = client.getProtocol() == null ? "openid-connect" : client.getProtocol();
        LOG.tracef("addClientScopes(%s, %s, %s, %b)%s", new Object[]{realm, client, clientScopes, defaultScope, StackUtil.getShortStackTrace()});
        Map<String, ClientScopeModel> existingClientScopes = this.getClientScopes(realm, client, true);
        existingClientScopes.putAll(this.getClientScopes(realm, client, false));
        clientScopes.stream().filter(clientScope -> !existingClientScopes.containsKey(clientScope.getName())).filter(clientScope -> Objects.equals(clientScope.getProtocol(), clientProtocol)).forEach(clientScope -> entity.addClientScope(clientScope.getId(), defaultScope));
    }

    public void removeClientScope(RealmModel realm, ClientModel client, ClientScopeModel clientScope) {
        String id = client.getId();
        MapClientEntity<K> entity = this.tx.read(this.clientStore.getKeyConvertor().fromString(id));
        if (entity == null) {
            return;
        }
        LOG.tracef("removeClientScope(%s, %s, %s)%s", new Object[]{realm, client, clientScope, StackUtil.getShortStackTrace()});
        entity.removeClientScope(clientScope.getId());
    }

    public Map<String, ClientScopeModel> getClientScopes(RealmModel realm, ClientModel client, boolean defaultScopes) {
        String id = client.getId();
        MapClientEntity<K> entity = this.tx.read(this.clientStore.getKeyConvertor().fromString(id));
        if (entity == null) {
            return null;
        }
        String clientProtocol = client.getProtocol() == null ? "openid-connect" : client.getProtocol();
        LOG.tracef("getClientScopes(%s, %s, %b)%s", new Object[]{realm, client, defaultScopes, StackUtil.getShortStackTrace()});
        return entity.getClientScopes(defaultScopes).map(clientScopeId -> this.session.clientScopes().getClientScopeById(realm, clientScopeId)).filter(Objects::nonNull).filter(clientScope -> Objects.equals(clientScope.getProtocol(), clientProtocol)).collect(Collectors.toMap(ClientScopeModel::getName, Function.identity()));
    }

    public Map<ClientModel, Set<String>> getAllRedirectUrisOfEnabledClients(RealmModel realm) {
        ModelCriteriaBuilder<ClientModel> mcb = this.clientStore.createCriteriaBuilder().compare((SearchableModelField<ClientModel>)ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<ClientModel>)ClientModel.SearchableFields.ENABLED, ModelCriteriaBuilder.Operator.EQ, Boolean.TRUE);
        try (Stream<MapClientEntity<K>> st = this.tx.read(mcb);){
            Map<ClientModel, Set<String>> map = st.filter(mce -> mce.getRedirectUris() != null && !mce.getRedirectUris().isEmpty()).collect(Collectors.toMap(mce -> this.entityToAdapterFunc(realm).apply((MapClientEntity<K>)mce), mce -> new HashSet<String>(mce.getRedirectUris())));
            return map;
        }
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        ModelCriteriaBuilder<ClientModel> mcb = this.clientStore.createCriteriaBuilder().compare((SearchableModelField<ClientModel>)ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<ClientModel>)ClientModel.SearchableFields.SCOPE_MAPPING_ROLE, ModelCriteriaBuilder.Operator.EQ, role.getId());
        try (Stream<MapClientEntity<K>> toRemove = this.tx.read(mcb);){
            toRemove.map(clientEntity -> this.session.clients().getClientById(realm, clientEntity.getId().toString())).filter(Objects::nonNull).forEach(clientModel -> clientModel.deleteScopeMapping(role));
        }
    }

    public void close() {
    }
}

