/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.clientscope;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.map.common.AbstractEntity;

public class MapClientScopeEntity<K>
implements AbstractEntity<K> {
    private final K id;
    private final String realmId;
    private String name;
    private String protocol;
    private String description;
    private final Set<String> scopeMappings = new LinkedHashSet<String>();
    private final Map<String, ProtocolMapperModel> protocolMappers = new HashMap<String, ProtocolMapperModel>();
    private final Map<String, String> attributes = new HashMap<String, String>();
    protected boolean updated;

    protected MapClientScopeEntity() {
        this.id = null;
        this.realmId = null;
    }

    public MapClientScopeEntity(K id, String realmId) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(realmId, "realmId");
        this.id = id;
        this.realmId = realmId;
    }

    @Override
    public K getId() {
        return this.id;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.updated |= !Objects.equals(this.name, name);
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.updated |= !Objects.equals(this.description, description);
        this.description = description;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.updated |= !Objects.equals(this.protocol, protocol);
        this.protocol = protocol;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.updated |= !Objects.equals(this.attributes, attributes);
        this.attributes.clear();
        this.attributes.putAll(attributes);
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        Objects.requireNonNull(model.getId(), "protocolMapper.id");
        this.updated = true;
        this.protocolMappers.put(model.getId(), model);
        return model;
    }

    public Stream<ProtocolMapperModel> getProtocolMappers() {
        return this.protocolMappers.values().stream();
    }

    public void updateProtocolMapper(String id, ProtocolMapperModel mapping) {
        this.updated = true;
        this.protocolMappers.put(id, mapping);
    }

    public void removeProtocolMapper(String id) {
        this.updated |= this.protocolMappers.remove(id) != null;
    }

    public void setProtocolMappers(Collection<ProtocolMapperModel> protocolMappers) {
        this.updated |= !Objects.equals(this.protocolMappers, protocolMappers);
        this.protocolMappers.clear();
        this.protocolMappers.putAll(protocolMappers.stream().collect(Collectors.toMap(ProtocolMapperModel::getId, Function.identity())));
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        return id == null ? null : this.protocolMappers.get(id);
    }

    public void setAttribute(String name, String value) {
        this.updated = true;
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.updated |= this.attributes.remove(name) != null;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String getRealmId() {
        return this.realmId;
    }

    public Stream<String> getScopeMappings() {
        return this.scopeMappings.stream();
    }

    public void addScopeMapping(String id) {
        if (id != null) {
            this.updated = true;
            this.scopeMappings.add(id);
        }
    }

    public void deleteScopeMapping(String id) {
        this.updated |= this.scopeMappings.remove(id);
    }
}

