/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.clientscope;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientScopeProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.clientscope.MapClientScopeAdapter;
import org.keycloak.models.map.clientscope.MapClientScopeEntity;
import org.keycloak.models.map.common.MapStorageUtils;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.SearchableModelField;

public class MapClientScopeProvider<K>
implements ClientScopeProvider {
    private static final Logger LOG = Logger.getLogger(MapClientScopeProvider.class);
    private final KeycloakSession session;
    private final MapKeycloakTransaction<K, MapClientScopeEntity<K>, ClientScopeModel> tx;
    private final MapStorage<K, MapClientScopeEntity<K>, ClientScopeModel> clientScopeStore;
    private static final Comparator<MapClientScopeEntity> COMPARE_BY_NAME = Comparator.comparing(MapClientScopeEntity::getName);

    public MapClientScopeProvider(KeycloakSession session, MapStorage<K, MapClientScopeEntity<K>, ClientScopeModel> clientScopeStore) {
        this.session = session;
        this.clientScopeStore = clientScopeStore;
        this.tx = clientScopeStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private Function<MapClientScopeEntity<K>, ClientScopeModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapClientScopeAdapter<K>(this.session, realm, MapStorageUtils.registerEntityForChanges(this.tx, origEntity)){

            public String getId() {
                return MapClientScopeProvider.this.clientScopeStore.getKeyConvertor().keyToString(((MapClientScopeEntity)this.entity).getId());
            }
        };
    }

    private Predicate<MapClientScopeEntity<K>> entityRealmFilter(RealmModel realm) {
        if (realm == null || realm.getId() == null) {
            return c -> false;
        }
        String realmId = realm.getId();
        return entity -> Objects.equals(realmId, entity.getRealmId());
    }

    public Stream<ClientScopeModel> getClientScopesStream(RealmModel realm) {
        ModelCriteriaBuilder<ClientScopeModel> mcb = this.clientScopeStore.createCriteriaBuilder().compare((SearchableModelField<ClientScopeModel>)ClientScopeModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        return this.tx.read(mcb).sorted(COMPARE_BY_NAME).map(this.entityToAdapterFunc(realm));
    }

    public ClientScopeModel addClientScope(RealmModel realm, String id, String name) {
        ModelCriteriaBuilder<ClientScopeModel> mcb = this.clientScopeStore.createCriteriaBuilder().compare((SearchableModelField<ClientScopeModel>)ClientScopeModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<ClientScopeModel>)ClientScopeModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, name);
        if (this.tx.getCount(mcb) > 0L) {
            throw new ModelDuplicateException("Client scope with name '" + name + "' in realm " + realm.getName());
        }
        K entityId = id == null ? this.clientScopeStore.getKeyConvertor().yieldNewUniqueKey() : this.clientScopeStore.getKeyConvertor().fromString(id);
        LOG.tracef("addClientScope(%s, %s, %s)%s", new Object[]{realm, id, name, StackUtil.getShortStackTrace()});
        MapClientScopeEntity<K> entity = new MapClientScopeEntity<K>(entityId, realm.getId());
        entity.setName(KeycloakModelUtils.convertClientScopeName((String)name));
        if (this.tx.read(entity.getId()) != null) {
            throw new ModelDuplicateException("Client scope exists: " + id);
        }
        this.tx.create(entity.getId(), entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public boolean removeClientScope(RealmModel realm, String id) {
        if (id == null) {
            return false;
        }
        final ClientScopeModel clientScope = this.getClientScopeById(realm, id);
        if (clientScope == null) {
            return false;
        }
        this.session.users().preRemove(clientScope);
        realm.removeDefaultClientScope(clientScope);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new ClientScopeModel.ClientScopeRemovedEvent(){

            public KeycloakSession getKeycloakSession() {
                return MapClientScopeProvider.this.session;
            }

            public ClientScopeModel getClientScope() {
                return clientScope;
            }
        });
        this.tx.delete(this.clientScopeStore.getKeyConvertor().fromString(id));
        return true;
    }

    public void removeClientScopes(RealmModel realm) {
        LOG.tracef("removeClients(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.getClientScopesStream(realm).map(ClientScopeModel::getId).collect(Collectors.toSet()).forEach(id -> this.removeClientScope(realm, (String)id));
    }

    public ClientScopeModel getClientScopeById(RealmModel realm, String id) {
        K uuid;
        if (id == null) {
            return null;
        }
        LOG.tracef("getClientScopeById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        try {
            uuid = this.clientScopeStore.getKeyConvertor().fromStringSafe(id);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        MapClientScopeEntity<K> entity = this.tx.read(uuid);
        return entity == null || !this.entityRealmFilter(realm).test(entity) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public void close() {
    }
}

