/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.MapFieldPredicates;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapModelCriteriaBuilder;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.StringKeyConvertor;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapKeycloakTransaction;
import org.keycloak.storage.SearchableModelField;

public class ConcurrentHashMapStorage<K, V extends AbstractEntity<K>, M>
implements MapStorage<K, V, M> {
    private final ConcurrentMap<K, V> store = new ConcurrentHashMap();
    private final Map<SearchableModelField<M>, MapModelCriteriaBuilder.UpdatePredicatesFunc<K, V, M>> fieldPredicates;
    private final StringKeyConvertor<K> keyConvertor;

    public ConcurrentHashMapStorage(Class<M> modelClass, StringKeyConvertor<K> keyConvertor) {
        this.fieldPredicates = MapFieldPredicates.getPredicates(modelClass);
        this.keyConvertor = keyConvertor;
    }

    @Override
    public V create(K key, V value) {
        return (V)((AbstractEntity)this.store.putIfAbsent(key, value));
    }

    @Override
    public V read(K key) {
        Objects.requireNonNull(key, "Key must be non-null");
        return (V)((AbstractEntity)this.store.get(key));
    }

    @Override
    public V update(K key, V value) {
        return (V)((AbstractEntity)this.store.replace(key, value));
    }

    @Override
    public boolean delete(K key) {
        return this.store.remove(key) != null;
    }

    @Override
    public long delete(ModelCriteriaBuilder<M> criteria) {
        if (criteria == null) {
            long res = this.store.size();
            this.store.clear();
            return res;
        }
        MapModelCriteriaBuilder b = criteria.unwrap(MapModelCriteriaBuilder.class);
        if (b == null) {
            throw new IllegalStateException("Incompatible class: " + criteria.getClass());
        }
        Predicate keyFilter = b.getKeyFilter();
        Predicate entityFilter = b.getEntityFilter();
        long res = 0L;
        Iterator iterator = this.store.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            if (!keyFilter.test(next.getKey()) || !entityFilter.test(next.getValue())) continue;
            ++res;
            iterator.remove();
        }
        return res;
    }

    @Override
    public ModelCriteriaBuilder<M> createCriteriaBuilder() {
        return new MapModelCriteriaBuilder<K, V, M>(this.fieldPredicates);
    }

    @Override
    public MapKeycloakTransaction<K, V, M> createTransaction(KeycloakSession session) {
        MapKeycloakTransaction sessionTransaction = (MapKeycloakTransaction)session.getAttribute("map-transaction-" + this.hashCode(), MapKeycloakTransaction.class);
        return sessionTransaction == null ? new ConcurrentHashMapKeycloakTransaction(this) : sessionTransaction;
    }

    @Override
    public StringKeyConvertor<K> getKeyConvertor() {
        return this.keyConvertor;
    }

    @Override
    public Stream<V> read(ModelCriteriaBuilder<M> criteria) {
        if (criteria == null) {
            return Stream.empty();
        }
        Stream<Object> stream = this.store.entrySet().stream();
        MapModelCriteriaBuilder b = criteria.unwrap(MapModelCriteriaBuilder.class);
        if (b == null) {
            throw new IllegalStateException("Incompatible class: " + criteria.getClass());
        }
        Predicate keyFilter = b.getKeyFilter();
        Predicate entityFilter = b.getEntityFilter();
        stream = stream.filter(me -> keyFilter.test(me.getKey()) && entityFilter.test(me.getValue()));
        return stream.map(Map.Entry::getValue);
    }

    @Override
    public long getCount(ModelCriteriaBuilder<M> criteria) {
        return this.read(criteria).count();
    }
}

