/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.device.DeviceActivityManager;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.map.common.MapStorageUtils;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionAdapter;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionAdapter;
import org.keycloak.models.map.userSession.MapUserSessionEntity;
import org.keycloak.models.map.userSession.SessionExpiration;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.StreamsUtil;

public class MapUserSessionProvider<UK, CK>
implements UserSessionProvider {
    private static final Logger LOG = Logger.getLogger(MapUserSessionProvider.class);
    private final KeycloakSession session;
    protected final MapKeycloakTransaction<UK, MapUserSessionEntity<UK>, UserSessionModel> userSessionTx;
    protected final MapKeycloakTransaction<CK, MapAuthenticatedClientSessionEntity<CK>, AuthenticatedClientSessionModel> clientSessionTx;
    private final MapStorage<UK, MapUserSessionEntity<UK>, UserSessionModel> userSessionStore;
    private final MapStorage<CK, MapAuthenticatedClientSessionEntity<CK>, AuthenticatedClientSessionModel> clientSessionStore;
    private final Map<UK, MapUserSessionEntity<UK>> transientUserSessions = new HashMap<UK, MapUserSessionEntity<UK>>();

    public MapUserSessionProvider(KeycloakSession session, MapStorage<UK, MapUserSessionEntity<UK>, UserSessionModel> userSessionStore, MapStorage<CK, MapAuthenticatedClientSessionEntity<CK>, AuthenticatedClientSessionModel> clientSessionStore) {
        this.session = session;
        this.userSessionStore = userSessionStore;
        this.clientSessionStore = clientSessionStore;
        this.userSessionTx = userSessionStore.createTransaction(session);
        this.clientSessionTx = clientSessionStore.createTransaction(session);
        session.getTransactionManager().enlistAfterCompletion(this.userSessionTx);
        session.getTransactionManager().enlistAfterCompletion(this.clientSessionTx);
    }

    private Function<MapUserSessionEntity<UK>, UserSessionModel> userEntityToAdapterFunc(RealmModel realm) {
        return origEntity -> {
            if (origEntity.getExpiration() <= (long)Time.currentTime()) {
                if (Objects.equals(origEntity.getPersistenceState(), UserSessionModel.SessionPersistenceState.TRANSIENT)) {
                    this.transientUserSessions.remove(origEntity.getId());
                }
                this.userSessionTx.delete(origEntity.getId());
                return null;
            }
            return new MapUserSessionAdapter<UK>(this.session, realm, Objects.equals(origEntity.getPersistenceState(), UserSessionModel.SessionPersistenceState.TRANSIENT) ? origEntity : MapStorageUtils.registerEntityForChanges(this.userSessionTx, origEntity)){

                public String getId() {
                    return MapUserSessionProvider.this.userSessionStore.getKeyConvertor().keyToString(this.entity.getId());
                }

                public void removeAuthenticatedClientSessions(Collection<String> removedClientUKS) {
                    removedClientUKS.forEach(this.entity::removeAuthenticatedClientSession);
                }

                @Override
                public void setLastSessionRefresh(int lastSessionRefresh) {
                    this.entity.setLastSessionRefresh(lastSessionRefresh);
                    SessionExpiration.setUserSessionExpiration(this.entity, this.realm);
                }
            };
        };
    }

    private Function<MapAuthenticatedClientSessionEntity<CK>, AuthenticatedClientSessionModel> clientEntityToAdapterFunc(RealmModel realm, ClientModel client, UserSessionModel userSession) {
        return origEntity -> {
            if (origEntity.getExpiration() <= (long)Time.currentTime()) {
                userSession.removeAuthenticatedClientSessions(Arrays.asList(origEntity.getClientId()));
                this.clientSessionTx.delete(origEntity.getId());
                return null;
            }
            return new MapAuthenticatedClientSessionAdapter<CK>(this.session, realm, client, userSession, MapStorageUtils.registerEntityForChanges(this.clientSessionTx, origEntity)){

                public String getId() {
                    return MapUserSessionProvider.this.clientSessionStore.getKeyConvertor().keyToString(this.entity.getId());
                }

                public void detachFromUserSession() {
                    this.userSession = null;
                    MapUserSessionProvider.this.clientSessionTx.delete(this.entity.getId());
                }

                @Override
                public void setTimestamp(int timestamp) {
                    this.entity.setTimestamp(timestamp);
                    SessionExpiration.setClientSessionExpiration(this.entity, this.realm, this.client);
                }
            };
        };
    }

    public KeycloakSession getKeycloakSession() {
        return this.session;
    }

    public AuthenticatedClientSessionModel createClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession) {
        MapAuthenticatedClientSessionEntity<CK> entity = new MapAuthenticatedClientSessionEntity<CK>(this.clientSessionStore.getKeyConvertor().yieldNewUniqueKey(), userSession.getId(), realm.getId(), client.getId(), false);
        entity.getNotes().put("startedAt", String.valueOf(entity.getTimestamp()));
        SessionExpiration.setClientSessionExpiration(entity, realm, client);
        LOG.tracef("createClientSession(%s, %s, %s)%s", new Object[]{realm, client, userSession, StackUtil.getShortStackTrace()});
        this.clientSessionTx.create(entity.getId(), entity);
        MapUserSessionEntity<UK> userSessionEntity = this.getUserSessionById(this.userSessionStore.getKeyConvertor().fromString(userSession.getId()));
        if (userSessionEntity == null) {
            throw new IllegalStateException("User session entity does not exist: " + userSession.getId());
        }
        userSessionEntity.addAuthenticatedClientSession(client.getId(), this.clientSessionStore.getKeyConvertor().keyToString(entity.getId()));
        return this.clientEntityToAdapterFunc(realm, client, userSession).apply(entity);
    }

    public AuthenticatedClientSessionModel getClientSession(UserSessionModel userSession, ClientModel client, String clientSessionId, boolean offline) {
        LOG.tracef("getClientSession(%s, %s, %s, %s)%s", new Object[]{userSession, client, clientSessionId, offline, StackUtil.getShortStackTrace()});
        Objects.requireNonNull(userSession, "The provided user session cannot be null!");
        Objects.requireNonNull(client, "The provided client cannot be null!");
        if (clientSessionId == null) {
            return null;
        }
        CK ck = this.clientSessionStore.getKeyConvertor().fromStringSafe(clientSessionId);
        ModelCriteriaBuilder<AuthenticatedClientSessionModel> mcb = this.clientSessionStore.createCriteriaBuilder().compare((SearchableModelField<AuthenticatedClientSessionModel>)AuthenticatedClientSessionModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, ck).compare((SearchableModelField<AuthenticatedClientSessionModel>)AuthenticatedClientSessionModel.SearchableFields.USER_SESSION_ID, ModelCriteriaBuilder.Operator.EQ, userSession.getId()).compare((SearchableModelField<AuthenticatedClientSessionModel>)AuthenticatedClientSessionModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, userSession.getRealm().getId()).compare((SearchableModelField<AuthenticatedClientSessionModel>)AuthenticatedClientSessionModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, client.getId()).compare((SearchableModelField<AuthenticatedClientSessionModel>)AuthenticatedClientSessionModel.SearchableFields.IS_OFFLINE, ModelCriteriaBuilder.Operator.EQ, offline);
        return this.clientSessionTx.read(mcb).findFirst().map(this.clientEntityToAdapterFunc(client.getRealm(), client, userSession)).orElse(null);
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        return this.createUserSession(null, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId, UserSessionModel.SessionPersistenceState.PERSISTENT);
    }

    public UserSessionModel createUserSession(String id, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId, UserSessionModel.SessionPersistenceState persistenceState) {
        UK entityId = id == null ? this.userSessionStore.getKeyConvertor().yieldNewUniqueKey() : this.userSessionStore.getKeyConvertor().fromString(id);
        LOG.tracef("createUserSession(%s, %s, %s, %s)%s", new Object[]{id, realm, loginUsername, persistenceState, StackUtil.getShortStackTrace()});
        MapUserSessionEntity<UK> entity = new MapUserSessionEntity<UK>(entityId, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId, false);
        entity.setPersistenceState(persistenceState);
        SessionExpiration.setUserSessionExpiration(entity, realm);
        if (Objects.equals(persistenceState, UserSessionModel.SessionPersistenceState.TRANSIENT)) {
            this.transientUserSessions.put(entityId, entity);
        } else {
            if (this.userSessionTx.read(entity.getId()) != null) {
                throw new ModelDuplicateException("User session exists: " + entity.getId());
            }
            this.userSessionTx.create(entity.getId(), entity);
        }
        UserSessionModel userSession = this.userEntityToAdapterFunc(realm).apply(entity);
        if (userSession != null) {
            DeviceActivityManager.attachDevice((UserSessionModel)userSession, (KeycloakSession)this.session);
        }
        return userSession;
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        LOG.tracef("getUserSession(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        UK uuid = this.userSessionStore.getKeyConvertor().fromStringSafe(id);
        if (uuid == null) {
            return null;
        }
        MapUserSessionEntity<UK> userSessionEntity = this.transientUserSessions.get(uuid);
        if (userSessionEntity != null) {
            return this.userEntityToAdapterFunc(realm).apply(userSessionEntity);
        }
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, uuid);
        return this.userSessionTx.read(mcb).findFirst().map(this.userEntityToAdapterFunc(realm)).orElse(null);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, UserModel user) {
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, user.getId());
        LOG.tracef("getUserSessionsStream(%s, %s)%s", (Object)realm, (Object)user, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(mcb).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client) {
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, client.getId());
        LOG.tracef("getUserSessionsStream(%s, %s)%s", (Object)realm, (Object)client, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(mcb).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults) {
        return StreamsUtil.paginatedStream(this.getUserSessionsStream(realm, client).sorted(Comparator.comparing(UserSessionModel::getLastSessionRefresh)), (Integer)firstResult, (Integer)maxResults);
    }

    public Stream<UserSessionModel> getUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.BROKER_USER_ID, ModelCriteriaBuilder.Operator.EQ, brokerUserId);
        LOG.tracef("getUserSessionByBrokerUserIdStream(%s, %s)%s", (Object)realm, (Object)brokerUserId, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(mcb).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.BROKER_SESSION_ID, ModelCriteriaBuilder.Operator.EQ, brokerSessionId);
        LOG.tracef("getUserSessionByBrokerSessionId(%s, %s)%s", (Object)realm, (Object)brokerSessionId, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(mcb).findFirst().map(this.userEntityToAdapterFunc(realm)).orElse(null);
    }

    public UserSessionModel getUserSessionWithPredicate(RealmModel realm, String id, boolean offline, Predicate<UserSessionModel> predicate) {
        UserSessionModel userSession;
        LOG.tracef("getUserSessionWithPredicate(%s, %s, %s)%s", new Object[]{realm, id, offline, StackUtil.getShortStackTrace()});
        Stream<Object> userSessionEntityStream = offline ? this.getOfflineUserSessionEntityStream(realm, id).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull) : ((userSession = this.getUserSession(realm, id)) != null ? Stream.of(userSession) : Stream.empty());
        return userSessionEntityStream.filter(predicate).findFirst().orElse(null);
    }

    public long getActiveUserSessions(RealmModel realm, ClientModel client) {
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, client.getId());
        LOG.tracef("getActiveUserSessions(%s, %s)%s", (Object)realm, (Object)client, StackUtil.getShortStackTrace());
        return this.userSessionTx.getCount(mcb);
    }

    public Map<String, Long> getActiveClientSessionStats(RealmModel realm, boolean offline) {
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, offline);
        LOG.tracef("getActiveClientSessionStats(%s, %s)%s", (Object)realm, (Object)offline, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(mcb).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull).map(UserSessionModel::getAuthenticatedClientSessions).map(Map::keySet).flatMap(Collection::stream).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        Objects.requireNonNull(session, "The provided user session can't be null!");
        UK uk = this.userSessionStore.getKeyConvertor().fromString(session.getId());
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, false).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, uk);
        LOG.tracef("removeUserSession(%s, %s)%s", (Object)realm, (Object)session, StackUtil.getShortStackTrace());
        this.userSessionTx.delete(this.userSessionStore.getKeyConvertor().yieldNewUniqueKey(), mcb);
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        ModelCriteriaBuilder<UserSessionModel> mcb = this.userSessionStore.createCriteriaBuilder().compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, user.getId());
        LOG.tracef("removeUserSessions(%s, %s)%s", (Object)realm, (Object)user, StackUtil.getShortStackTrace());
        this.userSessionTx.delete(this.userSessionStore.getKeyConvertor().yieldNewUniqueKey(), mcb);
    }

    public void removeAllExpired() {
        LOG.tracef("removeAllExpired()%s", StackUtil.getShortStackTrace());
    }

    public void removeExpired(RealmModel realm) {
        LOG.tracef("removeExpired(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
    }

    public void removeUserSessions(RealmModel realm) {
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, false);
        LOG.tracef("removeUserSessions(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.userSessionTx.delete(this.userSessionStore.getKeyConvertor().yieldNewUniqueKey(), mcb);
    }

    public void onRealmRemoved(RealmModel realm) {
        LOG.tracef("onRealmRemoved(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.removeUserSessions(realm);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
    }

    public UserSessionModel createOfflineUserSession(UserSessionModel userSession) {
        LOG.tracef("createOfflineUserSession(%s)%s", (Object)userSession, StackUtil.getShortStackTrace());
        MapUserSessionEntity<UK> offlineUserSession = this.createUserSessionEntityInstance(userSession, true);
        userSession.setNote("correspondingSessionId", offlineUserSession.getId().toString());
        int currentTime = Time.currentTime();
        offlineUserSession.setStarted(currentTime);
        offlineUserSession.setLastSessionRefresh(currentTime);
        SessionExpiration.setUserSessionExpiration(offlineUserSession, userSession.getRealm());
        this.userSessionTx.create(offlineUserSession.getId(), offlineUserSession);
        return this.userEntityToAdapterFunc(userSession.getRealm()).apply(offlineUserSession);
    }

    public UserSessionModel getOfflineUserSession(RealmModel realm, String userSessionId) {
        LOG.tracef("getOfflineUserSession(%s, %s)%s", (Object)realm, (Object)userSessionId, StackUtil.getShortStackTrace());
        return this.getOfflineUserSessionEntityStream(realm, userSessionId).findFirst().map(this.userEntityToAdapterFunc(realm)).orElse(null);
    }

    public void removeOfflineUserSession(RealmModel realm, UserSessionModel userSession) {
        Objects.requireNonNull(userSession, "The provided user session can't be null!");
        LOG.tracef("removeOfflineUserSession(%s, %s)%s", (Object)realm, (Object)userSession, StackUtil.getShortStackTrace());
        if (userSession.isOffline()) {
            this.userSessionTx.delete(this.userSessionStore.getKeyConvertor().fromString(userSession.getId()));
        } else if (userSession.getNote("correspondingSessionId") != null) {
            UK uk = this.userSessionStore.getKeyConvertor().fromString(userSession.getNote("correspondingSessionId"));
            ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, uk);
            this.userSessionTx.delete(this.userSessionStore.getKeyConvertor().yieldNewUniqueKey(), mcb);
            userSession.removeNote("correspondingSessionId");
        }
    }

    public AuthenticatedClientSessionModel createOfflineClientSession(AuthenticatedClientSessionModel clientSession, UserSessionModel offlineUserSession) {
        LOG.tracef("createOfflineClientSession(%s, %s)%s", (Object)clientSession, (Object)offlineUserSession, StackUtil.getShortStackTrace());
        MapAuthenticatedClientSessionEntity<CK> clientSessionEntity = this.createAuthenticatedClientSessionInstance(clientSession, offlineUserSession, true);
        int currentTime = Time.currentTime();
        clientSessionEntity.getNotes().put("startedAt", String.valueOf(currentTime));
        clientSessionEntity.setTimestamp(currentTime);
        SessionExpiration.setClientSessionExpiration(clientSessionEntity, clientSession.getRealm(), clientSession.getClient());
        Optional<MapUserSessionEntity<UK>> userSessionEntity = this.getOfflineUserSessionEntityStream(clientSession.getRealm(), offlineUserSession.getId()).findFirst();
        if (userSessionEntity.isPresent()) {
            userSessionEntity.get().addAuthenticatedClientSession(clientSession.getClient().getId(), this.clientSessionStore.getKeyConvertor().keyToString(clientSessionEntity.getId()));
        }
        this.clientSessionTx.create(clientSessionEntity.getId(), clientSessionEntity);
        return this.clientEntityToAdapterFunc(clientSession.getRealm(), clientSession.getClient(), offlineUserSession).apply(clientSessionEntity);
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, UserModel user) {
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, user.getId());
        LOG.tracef("getOfflineUserSessionsStream(%s, %s)%s", (Object)realm, (Object)user, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(mcb).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public UserSessionModel getOfflineUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.BROKER_SESSION_ID, ModelCriteriaBuilder.Operator.EQ, brokerSessionId);
        LOG.tracef("getOfflineUserSessionByBrokerSessionId(%s, %s)%s", (Object)realm, (Object)brokerSessionId, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(mcb).findFirst().map(this.userEntityToAdapterFunc(realm)).orElse(null);
    }

    public Stream<UserSessionModel> getOfflineUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.BROKER_USER_ID, ModelCriteriaBuilder.Operator.EQ, brokerUserId);
        LOG.tracef("getOfflineUserSessionByBrokerUserIdStream(%s, %s)%s", (Object)realm, (Object)brokerUserId, StackUtil.getShortStackTrace());
        return this.userSessionTx.read(mcb).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public long getOfflineSessionsCount(RealmModel realm, ClientModel client) {
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, client.getId());
        LOG.tracef("getOfflineSessionsCount(%s, %s)%s", (Object)realm, (Object)client, StackUtil.getShortStackTrace());
        return this.userSessionTx.getCount(mcb);
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults) {
        ModelCriteriaBuilder<UserSessionModel> mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, client.getId());
        LOG.tracef("getOfflineUserSessionsStream(%s, %s, %s, %s)%s", new Object[]{realm, client, firstResult, maxResults, StackUtil.getShortStackTrace()});
        return StreamsUtil.paginatedStream(this.userSessionTx.read(mcb).map(this.userEntityToAdapterFunc(realm)).filter(Objects::nonNull).sorted(Comparator.comparing(UserSessionModel::getLastSessionRefresh)), (Integer)firstResult, (Integer)maxResults);
    }

    public void importUserSessions(Collection<UserSessionModel> persistentUserSessions, boolean offline) {
        if (persistentUserSessions == null || persistentUserSessions.isEmpty()) {
            return;
        }
        persistentUserSessions.stream().map(pus -> {
            MapUserSessionEntity<UK> userSessionEntity = new MapUserSessionEntity<UK>(this.userSessionStore.getKeyConvertor().yieldNewUniqueKey(), pus.getRealm(), pus.getUser(), pus.getLoginUsername(), pus.getIpAddress(), pus.getAuthMethod(), pus.isRememberMe(), pus.getBrokerSessionId(), pus.getBrokerUserId(), offline);
            for (Map.Entry entry : pus.getAuthenticatedClientSessions().entrySet()) {
                MapAuthenticatedClientSessionEntity<CK> clientSession = this.createAuthenticatedClientSessionInstance((AuthenticatedClientSessionModel)entry.getValue(), ((AuthenticatedClientSessionModel)entry.getValue()).getUserSession(), offline);
                clientSession.setTimestamp(userSessionEntity.getLastSessionRefresh());
                userSessionEntity.addAuthenticatedClientSession((String)entry.getKey(), this.clientSessionStore.getKeyConvertor().keyToString(clientSession.getId()));
                this.clientSessionTx.create(clientSession.getId(), clientSession);
            }
            return userSessionEntity;
        }).forEach(use -> this.userSessionTx.create((UK)use.getId(), (MapUserSessionEntity<UK>)use));
    }

    public void close() {
    }

    private Stream<MapUserSessionEntity<UK>> getOfflineUserSessionEntityStream(RealmModel realm, String userSessionId) {
        UK uuid = this.userSessionStore.getKeyConvertor().fromStringSafe(userSessionId);
        if (uuid == null) {
            return Stream.empty();
        }
        ModelCriteriaBuilder<UserSessionModel> mcb = this.userSessionStore.createCriteriaBuilder().compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, uuid);
        MapUserSessionEntity userSessionEntity = this.userSessionTx.read(mcb).findFirst().orElse(null);
        if (userSessionEntity != null) {
            if (userSessionEntity.isOffline()) {
                return Stream.of(userSessionEntity);
            }
        } else {
            mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.CORRESPONDING_SESSION_ID, ModelCriteriaBuilder.Operator.EQ, userSessionId);
            return this.userSessionTx.read(mcb);
        }
        String offlineUserSessionId = userSessionEntity.getNote("correspondingSessionId");
        if (offlineUserSessionId != null) {
            UK uk = this.userSessionStore.getKeyConvertor().fromStringSafe(offlineUserSessionId);
            mcb = this.realmAndOfflineCriteriaBuilder(realm, true).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, uk);
            return this.userSessionTx.read(mcb);
        }
        return Stream.empty();
    }

    private ModelCriteriaBuilder<UserSessionModel> realmAndOfflineCriteriaBuilder(RealmModel realm, boolean offline) {
        return this.userSessionStore.createCriteriaBuilder().compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserSessionModel>)UserSessionModel.SearchableFields.IS_OFFLINE, ModelCriteriaBuilder.Operator.EQ, offline);
    }

    private MapUserSessionEntity<UK> getUserSessionById(UK id) {
        MapUserSessionEntity<UK> userSessionEntity = this.transientUserSessions.get(id);
        if (userSessionEntity == null) {
            MapUserSessionEntity<UK> userSession = this.userSessionTx.read(id);
            return userSession != null ? MapStorageUtils.registerEntityForChanges(this.userSessionTx, userSession) : null;
        }
        return userSessionEntity;
    }

    private MapUserSessionEntity<UK> createUserSessionEntityInstance(UserSessionModel userSession, boolean offline) {
        MapUserSessionEntity<UK> entity = new MapUserSessionEntity<UK>(this.userSessionStore.getKeyConvertor().yieldNewUniqueKey(), userSession.getRealm().getId());
        entity.setAuthMethod(userSession.getAuthMethod());
        entity.setBrokerSessionId(userSession.getBrokerSessionId());
        entity.setBrokerUserId(userSession.getBrokerUserId());
        entity.setIpAddress(userSession.getIpAddress());
        entity.setNotes(new ConcurrentHashMap<String, String>(userSession.getNotes()));
        entity.addNote("correspondingSessionId", userSession.getId());
        entity.clearAuthenticatedClientSessions();
        entity.setRememberMe(userSession.isRememberMe());
        entity.setState(userSession.getState());
        entity.setLoginUsername(userSession.getLoginUsername());
        entity.setUserId(userSession.getUser().getId());
        entity.setStarted(userSession.getStarted());
        entity.setLastSessionRefresh(userSession.getLastSessionRefresh());
        entity.setOffline(offline);
        return entity;
    }

    private MapAuthenticatedClientSessionEntity<CK> createAuthenticatedClientSessionInstance(AuthenticatedClientSessionModel clientSession, UserSessionModel userSession, boolean offline) {
        MapAuthenticatedClientSessionEntity<CK> entity = new MapAuthenticatedClientSessionEntity<CK>(this.clientSessionStore.getKeyConvertor().yieldNewUniqueKey(), userSession.getId(), clientSession.getRealm().getId(), clientSession.getClient().getId(), offline);
        entity.setAction(clientSession.getAction());
        entity.setAuthMethod(clientSession.getProtocol());
        entity.setNotes(new ConcurrentHashMap<String, String>(clientSession.getNotes()));
        entity.setRedirectUri(clientSession.getRedirectUri());
        entity.setTimestamp(clientSession.getTimestamp());
        return entity;
    }
}

