/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization.adapter;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.map.authorization.adapter.AbstractResourceModel;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;

public class MapResourceAdapter
extends AbstractResourceModel<MapResourceEntity> {
    public MapResourceAdapter(MapResourceEntity entity, StoreFactory storeFactory) {
        super(entity, storeFactory);
    }

    public String getId() {
        return ((MapResourceEntity)this.entity).getId();
    }

    public String getName() {
        return ((MapResourceEntity)this.entity).getName();
    }

    public void setName(String name) {
        this.throwExceptionIfReadonly();
        ((MapResourceEntity)this.entity).setName(name);
    }

    public String getDisplayName() {
        return ((MapResourceEntity)this.entity).getDisplayName();
    }

    public void setDisplayName(String name) {
        this.throwExceptionIfReadonly();
        ((MapResourceEntity)this.entity).setDisplayName(name);
    }

    public Set<String> getUris() {
        return ((MapResourceEntity)this.entity).getUris();
    }

    public void updateUris(Set<String> uri) {
        this.throwExceptionIfReadonly();
        ((MapResourceEntity)this.entity).setUris(uri);
    }

    public String getType() {
        return ((MapResourceEntity)this.entity).getType();
    }

    public void setType(String type) {
        this.throwExceptionIfReadonly();
        ((MapResourceEntity)this.entity).setType(type);
    }

    public List<Scope> getScopes() {
        return ((MapResourceEntity)this.entity).getScopeIds().stream().map(id -> this.storeFactory.getScopeStore().findById(id, ((MapResourceEntity)this.entity).getResourceServerId())).collect(Collectors.toList());
    }

    public String getIconUri() {
        return ((MapResourceEntity)this.entity).getIconUri();
    }

    public void setIconUri(String iconUri) {
        this.throwExceptionIfReadonly();
        ((MapResourceEntity)this.entity).setIconUri(iconUri);
    }

    public String getResourceServer() {
        return ((MapResourceEntity)this.entity).getResourceServerId();
    }

    public String getOwner() {
        return ((MapResourceEntity)this.entity).getOwner();
    }

    public boolean isOwnerManagedAccess() {
        return ((MapResourceEntity)this.entity).isOwnerManagedAccess();
    }

    public void setOwnerManagedAccess(boolean ownerManagedAccess) {
        this.throwExceptionIfReadonly();
        ((MapResourceEntity)this.entity).setOwnerManagedAccess(ownerManagedAccess);
    }

    public void updateScopes(Set<Scope> scopes) {
        this.throwExceptionIfReadonly();
        ((MapResourceEntity)this.entity).setScopeIds(scopes.stream().map(Scope::getId).collect(Collectors.toSet()));
    }

    public Map<String, List<String>> getAttributes() {
        return Collections.unmodifiableMap(new HashMap<String, List<String>>(((MapResourceEntity)this.entity).getAttributes()));
    }

    public String getSingleAttribute(String name) {
        return ((MapResourceEntity)this.entity).getSingleAttribute(name);
    }

    public List<String> getAttribute(String name) {
        return ((MapResourceEntity)this.entity).getAttribute(name);
    }

    public void setAttribute(String name, List<String> values) {
        this.throwExceptionIfReadonly();
        ((MapResourceEntity)this.entity).setAttribute(name, values);
    }

    public void removeAttribute(String name) {
        this.throwExceptionIfReadonly();
        ((MapResourceEntity)this.entity).removeAttribute(name);
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode((Object)this));
    }
}

