/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.clientscope;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.UpdatableEntity;

public class MapClientScopeEntity
implements AbstractEntity,
UpdatableEntity {
    private final String id;
    private final String realmId;
    private String name;
    private String protocol;
    private String description;
    private final Set<String> scopeMappings = new LinkedHashSet<String>();
    private final Map<String, ProtocolMapperModel> protocolMappers = new HashMap<String, ProtocolMapperModel>();
    private final Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    protected boolean updated;

    protected MapClientScopeEntity() {
        this.id = null;
        this.realmId = null;
    }

    public MapClientScopeEntity(String id, String realmId) {
        Objects.requireNonNull(realmId, "realmId");
        this.id = id;
        this.realmId = realmId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.updated |= !Objects.equals(this.name, name);
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.updated |= !Objects.equals(this.description, description);
        this.description = description;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.updated |= !Objects.equals(this.protocol, protocol);
        this.protocol = protocol;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttribute(String name, List<String> values) {
        this.updated |= !Objects.equals(this.attributes.put(name, values), values);
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        Objects.requireNonNull(model.getId(), "protocolMapper.id");
        this.updated = true;
        this.protocolMappers.put(model.getId(), model);
        return model;
    }

    public Stream<ProtocolMapperModel> getProtocolMappers() {
        return this.protocolMappers.values().stream();
    }

    public void updateProtocolMapper(String id, ProtocolMapperModel mapping) {
        this.updated = true;
        this.protocolMappers.put(id, mapping);
    }

    public void removeProtocolMapper(String id) {
        this.updated |= this.protocolMappers.remove(id) != null;
    }

    public void setProtocolMappers(Collection<ProtocolMapperModel> protocolMappers) {
        this.updated |= !Objects.equals(this.protocolMappers, protocolMappers);
        this.protocolMappers.clear();
        this.protocolMappers.putAll(protocolMappers.stream().collect(Collectors.toMap(ProtocolMapperModel::getId, Function.identity())));
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        return id == null ? null : this.protocolMappers.get(id);
    }

    public void removeAttribute(String name) {
        this.updated |= this.attributes.remove(name) != null;
    }

    public List<String> getAttribute(String name) {
        return this.attributes.getOrDefault(name, Collections.EMPTY_LIST);
    }

    public String getRealmId() {
        return this.realmId;
    }

    public Stream<String> getScopeMappings() {
        return this.scopeMappings.stream();
    }

    public void addScopeMapping(String id) {
        if (id != null) {
            this.updated = true;
            this.scopeMappings.add(id);
        }
    }

    public void deleteScopeMapping(String id) {
        this.updated |= this.scopeMappings.remove(id);
    }
}

