/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jdk8.StreamSerializer;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;

public class Serialization {
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_NULL).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).activateDefaultTyping((PolymorphicTypeValidator)new LaissezFaireSubTypeValidator(), ObjectMapper.DefaultTyping.NON_CONCRETE_AND_ARRAYS, JsonTypeInfo.As.PROPERTY).addMixIn(UpdatableEntity.class, IgnoreUpdatedMixIn.class).addMixIn(DeepCloner.class, IgnoredTypeMixIn.class);
    public static final ConcurrentHashMap<Class<?>, ObjectReader> READERS = new ConcurrentHashMap();
    public static final ConcurrentHashMap<Class<?>, ObjectWriter> WRITERS = new ConcurrentHashMap();

    public static <T> T from(T orig) {
        if (orig == null) {
            return null;
        }
        Class<?> origClass = orig.getClass();
        try {
            ObjectReader reader = READERS.computeIfAbsent(origClass, arg_0 -> ((ObjectMapper)MAPPER).readerFor(arg_0));
            ObjectWriter writer = WRITERS.computeIfAbsent(origClass, arg_0 -> ((ObjectMapper)MAPPER).writerFor(arg_0));
            Object res = reader.readValue(writer.writeValueAsBytes(orig));
            return (T)res;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static <T> T from(T orig, T target) {
        if (orig == null) {
            return null;
        }
        Class<?> origClass = orig.getClass();
        try {
            ObjectReader reader = MAPPER.readerForUpdating(target);
            ObjectWriter writer = WRITERS.computeIfAbsent(origClass, arg_0 -> ((ObjectMapper)MAPPER).writerFor(arg_0));
            Object res = reader.readValue(writer.writeValueAsBytes(orig));
            if (res != target) {
                throw new IllegalStateException("Should clone into desired target");
            }
            return (T)res;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static {
        JavaType type = TypeFactory.unknownType();
        JavaType streamType = MAPPER.getTypeFactory().constructParametricType(Stream.class, new JavaType[]{type});
        SimpleModule module = new SimpleModule().addSerializer((JsonSerializer)new StreamSerializer(streamType, type));
        MAPPER.registerModule((Module)module);
    }

    abstract class IgnoreUpdatedMixIn {
        IgnoreUpdatedMixIn() {
        }

        @JsonIgnore
        public abstract boolean isUpdated();
    }

    @JsonIgnoreType
    class IgnoredTypeMixIn {
        IgnoredTypeMixIn() {
        }
    }
}

