/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.user.AbstractUserModel;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;

public abstract class MapUserAdapter
extends AbstractUserModel<MapUserEntity> {
    public MapUserAdapter(KeycloakSession session, RealmModel realm, MapUserEntity entity) {
        super(session, realm, entity);
    }

    public String getId() {
        return ((MapUserEntity)this.entity).getId();
    }

    public String getUsername() {
        return ((MapUserEntity)this.entity).getUsername();
    }

    public void setUsername(String username) {
        if ((username = KeycloakModelUtils.toLowerCaseSafe((String)username)) != null && username.equals(((MapUserEntity)this.entity).getUsername())) {
            return;
        }
        if (this.checkUsernameUniqueness(this.realm, username)) {
            throw new ModelDuplicateException("A user with username " + username + " already exists");
        }
        ((MapUserEntity)this.entity).setUsername(username);
    }

    public Long getCreatedTimestamp() {
        return ((MapUserEntity)this.entity).getCreatedTimestamp();
    }

    public void setCreatedTimestamp(Long timestamp) {
        ((MapUserEntity)this.entity).setCreatedTimestamp(timestamp);
    }

    public boolean isEnabled() {
        return ((MapUserEntity)this.entity).isEnabled();
    }

    public void setEnabled(boolean enabled) {
        ((MapUserEntity)this.entity).setEnabled(enabled);
    }

    private Optional<String> getSpecialAttributeValue(String name) {
        if ("firstName".equals(name)) {
            return Optional.ofNullable(((MapUserEntity)this.entity).getFirstName());
        }
        if ("lastName".equals(name)) {
            return Optional.ofNullable(((MapUserEntity)this.entity).getLastName());
        }
        if ("email".equals(name)) {
            return Optional.ofNullable(((MapUserEntity)this.entity).getEmail());
        }
        if ("username".equals(name)) {
            return Optional.ofNullable(((MapUserEntity)this.entity).getUsername());
        }
        return Optional.empty();
    }

    private boolean setSpecialAttributeValue(String name, String value) {
        if ("firstName".equals(name)) {
            ((MapUserEntity)this.entity).setFirstName(value);
            return true;
        }
        if ("lastName".equals(name)) {
            ((MapUserEntity)this.entity).setLastName(value);
            return true;
        }
        if ("email".equals(name)) {
            this.setEmail(value);
            return true;
        }
        if ("username".equals(name)) {
            this.setUsername(value);
            return true;
        }
        return false;
    }

    public void setSingleAttribute(String name, String value) {
        if (this.setSpecialAttributeValue(name, value)) {
            return;
        }
        if (value == null) {
            ((MapUserEntity)this.entity).removeAttribute(name);
            return;
        }
        ((MapUserEntity)this.entity).setAttribute(name, Collections.singletonList(value));
    }

    public void setAttribute(String name, List<String> values) {
        String valueToSet;
        String string = valueToSet = values != null && values.size() > 0 ? values.get(0) : null;
        if (this.setSpecialAttributeValue(name, valueToSet)) {
            return;
        }
        ((MapUserEntity)this.entity).removeAttribute(name);
        if (valueToSet == null) {
            return;
        }
        ((MapUserEntity)this.entity).setAttribute(name, values);
    }

    public void removeAttribute(String name) {
        ((MapUserEntity)this.entity).removeAttribute(name);
    }

    public String getFirstAttribute(String name) {
        return this.getSpecialAttributeValue(name).orElseGet(() -> ((MapUserEntity)this.entity).getAttribute(name).stream().findFirst().orElse(null));
    }

    public Stream<String> getAttributeStream(String name) {
        return this.getSpecialAttributeValue(name).map(Collections::singletonList).orElseGet(() -> ((MapUserEntity)this.entity).getAttribute(name)).stream();
    }

    public Map<String, List<String>> getAttributes() {
        MultivaluedHashMap result = new MultivaluedHashMap(((MapUserEntity)this.entity).getAttributes());
        result.add((Object)"firstName", (Object)((MapUserEntity)this.entity).getFirstName());
        result.add((Object)"lastName", (Object)((MapUserEntity)this.entity).getLastName());
        result.add((Object)"email", (Object)((MapUserEntity)this.entity).getEmail());
        result.add((Object)"username", (Object)((MapUserEntity)this.entity).getUsername());
        return result;
    }

    public Stream<String> getRequiredActionsStream() {
        return ((MapUserEntity)this.entity).getRequiredActions().stream();
    }

    public void addRequiredAction(String action) {
        ((MapUserEntity)this.entity).addRequiredAction(action);
    }

    public void removeRequiredAction(String action) {
        ((MapUserEntity)this.entity).removeRequiredAction(action);
    }

    public String getFirstName() {
        return ((MapUserEntity)this.entity).getFirstName();
    }

    public void setFirstName(String firstName) {
        ((MapUserEntity)this.entity).setFirstName(firstName);
    }

    public String getLastName() {
        return ((MapUserEntity)this.entity).getLastName();
    }

    public void setLastName(String lastName) {
        ((MapUserEntity)this.entity).setLastName(lastName);
    }

    public String getEmail() {
        return ((MapUserEntity)this.entity).getEmail();
    }

    public void setEmail(String email) {
        boolean duplicatesAllowed;
        if ((email = KeycloakModelUtils.toLowerCaseSafe((String)email)) != null) {
            if (email.equals(((MapUserEntity)this.entity).getEmail())) {
                return;
            }
            if (ObjectUtil.isBlank((CharSequence)email)) {
                email = null;
            }
        }
        if (!(duplicatesAllowed = this.realm.isDuplicateEmailsAllowed()) && email != null && this.checkEmailUniqueness(this.realm, email)) {
            throw new ModelDuplicateException("A user with email " + email + " already exists");
        }
        ((MapUserEntity)this.entity).setEmail(email, duplicatesAllowed);
    }

    public abstract boolean checkEmailUniqueness(RealmModel var1, String var2);

    public abstract boolean checkUsernameUniqueness(RealmModel var1, String var2);

    public boolean isEmailVerified() {
        return ((MapUserEntity)this.entity).isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        ((MapUserEntity)this.entity).setEmailVerified(verified);
    }

    public Stream<GroupModel> getGroupsStream() {
        return this.session.groups().getGroupsStream(this.realm, ((MapUserEntity)this.entity).getGroupsMembership().stream());
    }

    public void joinGroup(GroupModel group) {
        ((MapUserEntity)this.entity).addGroupsMembership(group.getId());
    }

    public void leaveGroup(GroupModel group) {
        ((MapUserEntity)this.entity).removeGroupsMembership(group.getId());
    }

    public boolean isMemberOf(GroupModel group) {
        return ((MapUserEntity)this.entity).getGroupsMembership().contains(group.getId());
    }

    public String getFederationLink() {
        return ((MapUserEntity)this.entity).getFederationLink();
    }

    public void setFederationLink(String link) {
        ((MapUserEntity)this.entity).setFederationLink(link);
    }

    public String getServiceAccountClientLink() {
        return ((MapUserEntity)this.entity).getServiceAccountClientLink();
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        ((MapUserEntity)this.entity).setServiceAccountClientLink(clientInternalId);
    }

    public Stream<RoleModel> getRealmRoleMappingsStream() {
        return this.getRoleMappingsStream().filter(RoleUtils::isRealmRole);
    }

    public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
        return this.getRoleMappingsStream().filter(r -> RoleUtils.isClientRole((RoleModel)r, (ClientModel)app));
    }

    public boolean hasDirectRole(RoleModel role) {
        return ((MapUserEntity)this.entity).getRolesMembership().contains(role.getId());
    }

    public boolean hasRole(RoleModel role) {
        return this.hasDirectRole(role);
    }

    public void grantRole(RoleModel role) {
        ((MapUserEntity)this.entity).addRolesMembership(role.getId());
    }

    public Stream<RoleModel> getRoleMappingsStream() {
        return ((MapUserEntity)this.entity).getRolesMembership().stream().map(arg_0 -> ((RealmModel)this.realm).getRoleById(arg_0));
    }

    public void deleteRoleMapping(RoleModel role) {
        ((MapUserEntity)this.entity).removeRolesMembership(role.getId());
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), this.hashCode());
    }
}

