/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapClientEntityFields;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.common.delegate.DelegateProvider;

public class MapClientEntityDelegate
implements MapClientEntity {
    private final DelegateProvider<MapClientEntity> delegateProvider;

    public MapClientEntityDelegate(DelegateProvider<MapClientEntity> delegateProvider) {
        this.delegateProvider = delegateProvider;
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.ATTRIBUTES, new Object[0]).getAttributes();
    }

    @Override
    public void setAttributes(Map<String, List<String>> attributes) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.ATTRIBUTES, attributes).setAttributes(attributes);
    }

    @Override
    public List<String> getAttribute(String name) {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.ATTRIBUTES, name).getAttribute(name);
    }

    @Override
    public void setAttribute(String name, List<String> value) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.ATTRIBUTES, name, value).setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.ATTRIBUTES, name).removeAttribute(name);
    }

    @Override
    public boolean isUpdated() {
        return this.delegateProvider.isUpdated();
    }

    @Override
    public String getId() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.ID, new Object[0]).getId();
    }

    @Override
    public void setId(String id) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.ID, id).setId(id);
    }

    @Override
    public Map<String, Boolean> getClientScopes() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.CLIENT_SCOPES, new Object[0]).getClientScopes();
    }

    @Override
    public Stream<String> getClientScopes(boolean defaultScope) {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.CLIENT_SCOPES, defaultScope).getClientScopes(defaultScope);
    }

    @Override
    public void setClientScope(String id, Boolean defaultScope) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.CLIENT_SCOPES, id, defaultScope).setClientScope(id, defaultScope);
    }

    @Override
    public void removeClientScope(String id) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.CLIENT_SCOPES, id).removeClientScope(id);
    }

    @Override
    public MapProtocolMapperEntity getProtocolMapper(String id) {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.PROTOCOL_MAPPERS, id).getProtocolMapper(id);
    }

    @Override
    public Map<String, MapProtocolMapperEntity> getProtocolMappers() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.PROTOCOL_MAPPERS, new Object[0]).getProtocolMappers();
    }

    @Override
    public void setProtocolMapper(String id, MapProtocolMapperEntity mapping) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.PROTOCOL_MAPPERS, id, mapping).setProtocolMapper(id, mapping);
    }

    @Override
    public void removeProtocolMapper(String id) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.PROTOCOL_MAPPERS, id).removeProtocolMapper(id);
    }

    @Override
    public void addRedirectUri(String redirectUri) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.REDIRECT_URIS, redirectUri).addRedirectUri(redirectUri);
    }

    @Override
    public Set<String> getRedirectUris() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.REDIRECT_URIS, new Object[0]).getRedirectUris();
    }

    @Override
    public void removeRedirectUri(String redirectUri) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.REDIRECT_URIS, redirectUri).removeRedirectUri(redirectUri);
    }

    @Override
    public void setRedirectUris(Set<String> redirectUris) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.REDIRECT_URIS, redirectUris).setRedirectUris(redirectUris);
    }

    @Override
    public void addScopeMapping(String id) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.SCOPE_MAPPINGS, id).addScopeMapping(id);
    }

    @Override
    public void removeScopeMapping(String id) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.SCOPE_MAPPINGS, id).removeScopeMapping(id);
    }

    @Override
    public Collection<String> getScopeMappings() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.SCOPE_MAPPINGS, new Object[0]).getScopeMappings();
    }

    @Override
    public void addWebOrigin(String webOrigin) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.WEB_ORIGINS, webOrigin).addWebOrigin(webOrigin);
    }

    @Override
    public Set<String> getWebOrigins() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.WEB_ORIGINS, new Object[0]).getWebOrigins();
    }

    @Override
    public void removeWebOrigin(String webOrigin) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.WEB_ORIGINS, webOrigin).removeWebOrigin(webOrigin);
    }

    @Override
    public void setWebOrigins(Set<String> webOrigins) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.WEB_ORIGINS, webOrigins).setWebOrigins(webOrigins);
    }

    @Override
    public String getAuthenticationFlowBindingOverride(String binding) {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.AUTHENTICATION_FLOW_BINDING_OVERRIDES, binding).getAuthenticationFlowBindingOverride(binding);
    }

    @Override
    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.AUTHENTICATION_FLOW_BINDING_OVERRIDES, new Object[0]).getAuthenticationFlowBindingOverrides();
    }

    @Override
    public void removeAuthenticationFlowBindingOverride(String binding) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.AUTHENTICATION_FLOW_BINDING_OVERRIDES, binding).removeAuthenticationFlowBindingOverride(binding);
    }

    @Override
    public void setAuthenticationFlowBindingOverride(String binding, String flowId) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.AUTHENTICATION_FLOW_BINDING_OVERRIDES, binding, flowId).setAuthenticationFlowBindingOverride(binding, flowId);
    }

    @Override
    public String getBaseUrl() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.BASE_URL, new Object[0]).getBaseUrl();
    }

    @Override
    public String getClientAuthenticatorType() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.CLIENT_AUTHENTICATOR_TYPE, new Object[0]).getClientAuthenticatorType();
    }

    @Override
    public String getClientId() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.CLIENT_ID, new Object[0]).getClientId();
    }

    @Override
    public String getDescription() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.DESCRIPTION, new Object[0]).getDescription();
    }

    @Override
    public String getManagementUrl() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.MANAGEMENT_URL, new Object[0]).getManagementUrl();
    }

    @Override
    public String getName() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.NAME, new Object[0]).getName();
    }

    @Override
    public Integer getNodeReRegistrationTimeout() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.NODE_RE_REGISTRATION_TIMEOUT, new Object[0]).getNodeReRegistrationTimeout();
    }

    @Override
    public Integer getNotBefore() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.NOT_BEFORE, new Object[0]).getNotBefore();
    }

    @Override
    public String getProtocol() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.PROTOCOL, new Object[0]).getProtocol();
    }

    @Override
    public String getRealmId() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.REALM_ID, new Object[0]).getRealmId();
    }

    @Override
    public String getRegistrationToken() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.REGISTRATION_TOKEN, new Object[0]).getRegistrationToken();
    }

    @Override
    public String getRootUrl() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.ROOT_URL, new Object[0]).getRootUrl();
    }

    @Override
    public Set<String> getScope() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.SCOPE, new Object[0]).getScope();
    }

    @Override
    public String getSecret() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.SECRET, new Object[0]).getSecret();
    }

    @Override
    public Boolean isAlwaysDisplayInConsole() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.ALWAYS_DISPLAY_IN_CONSOLE, new Object[0]).isAlwaysDisplayInConsole();
    }

    @Override
    public Boolean isBearerOnly() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.BEARER_ONLY, new Object[0]).isBearerOnly();
    }

    @Override
    public Boolean isConsentRequired() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.CONSENT_REQUIRED, new Object[0]).isConsentRequired();
    }

    @Override
    public Boolean isDirectAccessGrantsEnabled() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.DIRECT_ACCESS_GRANTS_ENABLED, new Object[0]).isDirectAccessGrantsEnabled();
    }

    @Override
    public Boolean isEnabled() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.ENABLED, new Object[0]).isEnabled();
    }

    @Override
    public Boolean isFrontchannelLogout() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.FRONTCHANNEL_LOGOUT, new Object[0]).isFrontchannelLogout();
    }

    @Override
    public Boolean isFullScopeAllowed() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.FULL_SCOPE_ALLOWED, new Object[0]).isFullScopeAllowed();
    }

    @Override
    public Boolean isImplicitFlowEnabled() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.IMPLICIT_FLOW_ENABLED, new Object[0]).isImplicitFlowEnabled();
    }

    @Override
    public Boolean isPublicClient() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.PUBLIC_CLIENT, new Object[0]).isPublicClient();
    }

    @Override
    public Boolean isServiceAccountsEnabled() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.SERVICE_ACCOUNTS_ENABLED, new Object[0]).isServiceAccountsEnabled();
    }

    @Override
    public Boolean isStandardFlowEnabled() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.STANDARD_FLOW_ENABLED, new Object[0]).isStandardFlowEnabled();
    }

    @Override
    public Boolean isSurrogateAuthRequired() {
        return this.delegateProvider.getDelegate(true, MapClientEntityFields.SURROGATE_AUTH_REQUIRED, new Object[0]).isSurrogateAuthRequired();
    }

    @Override
    public void setAlwaysDisplayInConsole(Boolean alwaysDisplayInConsole) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.ALWAYS_DISPLAY_IN_CONSOLE, alwaysDisplayInConsole).setAlwaysDisplayInConsole(alwaysDisplayInConsole);
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.BASE_URL, baseUrl).setBaseUrl(baseUrl);
    }

    @Override
    public void setBearerOnly(Boolean bearerOnly) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.BEARER_ONLY, bearerOnly).setBearerOnly(bearerOnly);
    }

    @Override
    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.CLIENT_AUTHENTICATOR_TYPE, clientAuthenticatorType).setClientAuthenticatorType(clientAuthenticatorType);
    }

    @Override
    public void setClientId(String clientId) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.CLIENT_ID, clientId).setClientId(clientId);
    }

    @Override
    public void setConsentRequired(Boolean consentRequired) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.CONSENT_REQUIRED, consentRequired).setConsentRequired(consentRequired);
    }

    @Override
    public void setDescription(String description) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.DESCRIPTION, description).setDescription(description);
    }

    @Override
    public void setDirectAccessGrantsEnabled(Boolean directAccessGrantsEnabled) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.DIRECT_ACCESS_GRANTS_ENABLED, directAccessGrantsEnabled).setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.ENABLED, enabled).setEnabled(enabled);
    }

    @Override
    public void setFrontchannelLogout(Boolean frontchannelLogout) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.FRONTCHANNEL_LOGOUT, frontchannelLogout).setFrontchannelLogout(frontchannelLogout);
    }

    @Override
    public void setFullScopeAllowed(Boolean fullScopeAllowed) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.FULL_SCOPE_ALLOWED, fullScopeAllowed).setFullScopeAllowed(fullScopeAllowed);
    }

    @Override
    public void setImplicitFlowEnabled(Boolean implicitFlowEnabled) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.IMPLICIT_FLOW_ENABLED, implicitFlowEnabled).setImplicitFlowEnabled(implicitFlowEnabled);
    }

    @Override
    public void setManagementUrl(String managementUrl) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.MANAGEMENT_URL, managementUrl).setManagementUrl(managementUrl);
    }

    @Override
    public void setName(String name) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.NAME, name).setName(name);
    }

    @Override
    public void setNodeReRegistrationTimeout(Integer nodeReRegistrationTimeout) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.NODE_RE_REGISTRATION_TIMEOUT, nodeReRegistrationTimeout).setNodeReRegistrationTimeout(nodeReRegistrationTimeout);
    }

    @Override
    public void setNotBefore(Integer notBefore) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.NOT_BEFORE, notBefore).setNotBefore(notBefore);
    }

    @Override
    public void setProtocol(String protocol) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.PROTOCOL, protocol).setProtocol(protocol);
    }

    @Override
    public void setPublicClient(Boolean publicClient) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.PUBLIC_CLIENT, publicClient).setPublicClient(publicClient);
    }

    @Override
    public void setRealmId(String realmId) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.REALM_ID, realmId).setRealmId(realmId);
    }

    @Override
    public void setRegistrationToken(String registrationToken) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.REGISTRATION_TOKEN, registrationToken).setRegistrationToken(registrationToken);
    }

    @Override
    public void setRootUrl(String rootUrl) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.ROOT_URL, rootUrl).setRootUrl(rootUrl);
    }

    @Override
    public void setScope(Set<String> scope) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.SCOPE, scope).setScope(scope);
    }

    @Override
    public void setSecret(String secret) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.SECRET, secret).setSecret(secret);
    }

    @Override
    public void setServiceAccountsEnabled(Boolean serviceAccountsEnabled) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.SERVICE_ACCOUNTS_ENABLED, serviceAccountsEnabled).setServiceAccountsEnabled(serviceAccountsEnabled);
    }

    @Override
    public void setStandardFlowEnabled(Boolean standardFlowEnabled) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.STANDARD_FLOW_ENABLED, standardFlowEnabled).setStandardFlowEnabled(standardFlowEnabled);
    }

    @Override
    public void setSurrogateAuthRequired(Boolean surrogateAuthRequired) {
        this.delegateProvider.getDelegate(false, MapClientEntityFields.SURROGATE_AUTH_REQUIRED, surrogateAuthRequired).setSurrogateAuthRequired(surrogateAuthRequired);
    }
}

