/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.map.authorization.adapter.MapPolicyAdapter;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.authorization.entity.MapPolicyEntityImpl;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.storage.SearchableModelField;

public class MapPolicyStore
implements PolicyStore {
    private static final Logger LOG = Logger.getLogger(MapPolicyStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapKeycloakTransaction<MapPolicyEntity, Policy> tx;

    public MapPolicyStore(KeycloakSession session, MapStorage<MapPolicyEntity, Policy> policyStore, AuthorizationProvider provider) {
        this.authorizationProvider = provider;
        this.tx = policyStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private Policy entityToAdapter(MapPolicyEntity origEntity) {
        if (origEntity == null) {
            return null;
        }
        return new MapPolicyAdapter(origEntity, this.authorizationProvider.getStoreFactory());
    }

    private DefaultModelCriteria<Policy> forResourceServer(ResourceServer resourceServer) {
        DefaultModelCriteria<Policy> mcb = DefaultModelCriteria.criteria();
        return resourceServer == null ? mcb : mcb.compare(Policy.SearchableFields.RESOURCE_SERVER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resourceServer.getId()});
    }

    public Policy create(ResourceServer resourceServer, AbstractPolicyRepresentation representation) {
        LOG.tracef("create(%s, %s, %s)%s", new Object[]{representation.getId(), resourceServer.getId(), resourceServer, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = this.forResourceServer(resourceServer).compare(Policy.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{representation.getName()});
        if (this.tx.getCount(QueryParameters.withCriteria(mcb)) > 0L) {
            throw new ModelDuplicateException("Policy with name '" + representation.getName() + "' for " + resourceServer.getId() + " already exists");
        }
        String uid = representation.getId();
        MapPolicyEntity entity = new MapPolicyEntityImpl();
        entity.setId(uid);
        entity.setType(representation.getType());
        entity.setName(representation.getName());
        entity.setResourceServerId(resourceServer.getId());
        entity = this.tx.create(entity);
        return this.entityToAdapter(entity);
    }

    public void delete(String id) {
        LOG.tracef("delete(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        this.tx.delete(id);
    }

    public Policy findById(ResourceServer resourceServer, String id) {
        LOG.tracef("findById(%s, %s)%s", (Object)id, (Object)resourceServer, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(Policy.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{id}))).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public Policy findByName(ResourceServer resourceServer, String name) {
        LOG.tracef("findByName(%s, %s)%s", (Object)name, (Object)resourceServer, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(Policy.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name}))).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public List<Policy> findByResourceServer(ResourceServer resourceServer) {
        LOG.tracef("findByResourceServer(%s)%s", (Object)resourceServer, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer))).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<Policy> findByResourceServer(ResourceServer resourceServer, Map<Policy.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
        LOG.tracef("findByResourceServer(%s, %s, %d, %d)%s", new Object[]{attributes, resourceServer, firstResult, maxResults, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = this.forResourceServer(resourceServer).and((DefaultModelCriteria[])attributes.entrySet().stream().map(this::filterEntryToDefaultModelCriteria).filter(Objects::nonNull).toArray(DefaultModelCriteria[]::new));
        if (!attributes.containsKey(Policy.FilterOption.OWNER) && !attributes.containsKey(Policy.FilterOption.ANY_OWNER)) {
            mcb = mcb.compare(Policy.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        }
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, (SearchableModelField<Policy>)Policy.SearchableFields.NAME)).map(AbstractEntity::getId).map(id -> this.authorizationProvider.getStoreFactory().getPolicyStore().findById(resourceServer, id)).collect(Collectors.toList());
    }

    private DefaultModelCriteria<Policy> filterEntryToDefaultModelCriteria(Map.Entry<Policy.FilterOption, String[]> entry) {
        Policy.FilterOption name = entry.getKey();
        String[] value = entry.getValue();
        DefaultModelCriteria<Policy> mcb = DefaultModelCriteria.criteria();
        switch (name) {
            case ID: 
            case SCOPE_ID: 
            case RESOURCE_ID: 
            case OWNER: {
                return mcb.compare(name.getSearchableModelField(), ModelCriteriaBuilder.Operator.IN, new Object[]{Arrays.asList(value)});
            }
            case PERMISSION: {
                mcb = mcb.compare(Policy.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.IN, new Object[]{Arrays.asList("resource", "scope", "uma")});
                if (!Boolean.parseBoolean(value[0])) {
                    mcb = DefaultModelCriteria.criteria().not(mcb);
                }
                return mcb;
            }
            case ANY_OWNER: {
                return null;
            }
            case CONFIG: {
                if (value.length != 2) {
                    throw new IllegalArgumentException("Config filter option requires value with two items: [config_name, expected_config_value]");
                }
                value[1] = "%" + value[1] + "%";
                return mcb.compare(Policy.SearchableFields.CONFIG, ModelCriteriaBuilder.Operator.LIKE, (Object[])value);
            }
            case TYPE: 
            case NAME: {
                return mcb.compare(name.getSearchableModelField(), ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + value[0] + "%"});
            }
        }
        throw new IllegalArgumentException("Unsupported filter [" + name + "]");
    }

    public void findByResource(ResourceServer resourceServer, Resource resource, Consumer<Policy> consumer) {
        LOG.tracef("findByResource(%s, %s, %s)%s", new Object[]{resourceServer, resource, consumer, StackUtil.getShortStackTrace()});
        this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(Policy.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resource.getId()}))).map(this::entityToAdapter).forEach(consumer);
    }

    public void findByResourceType(ResourceServer resourceServer, String type, Consumer<Policy> policyConsumer) {
        this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(Policy.SearchableFields.CONFIG, ModelCriteriaBuilder.Operator.LIKE, (Object[])new String[]{"defaultResourceType", type}))).map(this::entityToAdapter).forEach(policyConsumer);
    }

    public List<Policy> findByScopes(ResourceServer resourceServer, List<Scope> scopes) {
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(Policy.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.IN, new Object[]{scopes.stream().map(Scope::getId)}))).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public void findByScopes(ResourceServer resourceServer, Resource resource, List<Scope> scopes, Consumer<Policy> consumer) {
        ModelCriteriaBuilder mcb = ((DefaultModelCriteria)this.forResourceServer(resourceServer).compare(Policy.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, new Object[]{"scope"})).compare(Policy.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.IN, new Object[]{scopes.stream().map(Scope::getId)});
        mcb = resource != null ? ((DefaultModelCriteria)mcb).compare(Policy.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resource.getId()}) : ((DefaultModelCriteria)((DefaultModelCriteria)mcb).compare(Policy.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0])).compare(Policy.SearchableFields.CONFIG, ModelCriteriaBuilder.Operator.NOT_EXISTS, (Object[])new String[]{"defaultResourceType"});
        this.tx.read(QueryParameters.withCriteria(mcb)).map(this::entityToAdapter).forEach(consumer);
    }

    public List<Policy> findByType(ResourceServer resourceServer, String type) {
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(Policy.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, new Object[]{type}))).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<Policy> findDependentPolicies(ResourceServer resourceServer, String id) {
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(Policy.SearchableFields.ASSOCIATED_POLICY_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{id}))).map(this::entityToAdapter).collect(Collectors.toList());
    }
}

