/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.map.authorization.adapter.MapResourceAdapter;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;
import org.keycloak.models.map.authorization.entity.MapResourceEntityImpl;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.storage.SearchableModelField;

public class MapResourceStore
implements ResourceStore {
    private static final Logger LOG = Logger.getLogger(MapResourceStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapKeycloakTransaction<MapResourceEntity, Resource> tx;

    public MapResourceStore(KeycloakSession session, MapStorage<MapResourceEntity, Resource> resourceStore, AuthorizationProvider provider) {
        this.tx = resourceStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
        this.authorizationProvider = provider;
    }

    private Resource entityToAdapter(MapResourceEntity origEntity) {
        if (origEntity == null) {
            return null;
        }
        return new MapResourceAdapter(origEntity, this.authorizationProvider.getStoreFactory());
    }

    private DefaultModelCriteria<Resource> forResourceServer(ResourceServer resourceServer) {
        DefaultModelCriteria<Resource> mcb = DefaultModelCriteria.criteria();
        return resourceServer == null ? mcb : mcb.compare(Resource.SearchableFields.RESOURCE_SERVER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resourceServer.getId()});
    }

    public Resource create(ResourceServer resourceServer, String id, String name, String owner) {
        LOG.tracef("create(%s, %s, %s, %s)%s", new Object[]{id, name, resourceServer, owner, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = ((DefaultModelCriteria)this.forResourceServer(resourceServer).compare(Resource.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name})).compare(Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, new Object[]{owner});
        if (this.tx.getCount(QueryParameters.withCriteria(mcb)) > 0L) {
            throw new ModelDuplicateException("Resource with name '" + name + "' for " + resourceServer.getId() + " already exists for request owner " + owner);
        }
        MapResourceEntity entity = new MapResourceEntityImpl();
        entity.setId(id);
        entity.setName(name);
        entity.setResourceServerId(resourceServer.getId());
        entity.setOwner(owner);
        entity = this.tx.create(entity);
        return this.entityToAdapter(entity);
    }

    public void delete(String id) {
        LOG.tracef("delete(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        this.tx.delete(id);
    }

    public Resource findById(ResourceServer resourceServer, String id) {
        LOG.tracef("findById(%s, %s)%s", (Object)id, (Object)resourceServer, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(Resource.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{id}))).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public void findByOwner(ResourceServer resourceServer, String ownerId, Consumer<Resource> consumer) {
        this.findByOwnerFilter(ownerId, resourceServer, consumer, -1, -1);
    }

    private void findByOwnerFilter(String ownerId, ResourceServer resourceServer, Consumer<Resource> consumer, int firstResult, int maxResult) {
        LOG.tracef("findByOwnerFilter(%s, %s, %s, %d, %d)%s", new Object[]{ownerId, resourceServer, consumer, firstResult, maxResult, StackUtil.getShortStackTrace()});
        this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, new Object[]{ownerId})).pagination(firstResult, maxResult, Resource.SearchableFields.ID)).map(this::entityToAdapter).forEach(consumer);
    }

    public List<Resource> findByOwner(ResourceServer resourceServer, String ownerId, Integer firstResult, Integer maxResults) {
        LinkedList<Resource> resourceList = new LinkedList<Resource>();
        this.findByOwnerFilter(ownerId, resourceServer, resourceList::add, firstResult, maxResults);
        return resourceList;
    }

    public List<Resource> findByUri(ResourceServer resourceServer, String uri) {
        LOG.tracef("findByUri(%s, %s)%s", (Object)uri, (Object)resourceServer, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(Resource.SearchableFields.URI, ModelCriteriaBuilder.Operator.EQ, new Object[]{uri}))).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<Resource> findByResourceServer(ResourceServer resourceServer) {
        LOG.tracef("findByResourceServer(%s)%s", (Object)resourceServer, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer))).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<Resource> findByResourceServer(ResourceServer resourceServer, Map<Resource.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
        LOG.tracef("findByResourceServer(%s, %s, %d, %d)%s", new Object[]{attributes, resourceServer, firstResult, maxResults, StackUtil.getShortStackTrace()});
        DefaultModelCriteria<Resource> mcb = this.forResourceServer(resourceServer).and((DefaultModelCriteria[])attributes.entrySet().stream().map(this::filterEntryToDefaultModelCriteria).toArray(DefaultModelCriteria[]::new));
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, (SearchableModelField<Resource>)Resource.SearchableFields.NAME)).map(this::entityToAdapter).collect(Collectors.toList());
    }

    private DefaultModelCriteria<Resource> filterEntryToDefaultModelCriteria(Map.Entry<Resource.FilterOption, String[]> entry) {
        Resource.FilterOption name = entry.getKey();
        String[] value = entry.getValue();
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        switch (name) {
            case ID: 
            case SCOPE_ID: 
            case OWNER: 
            case URI: {
                return mcb.compare(name.getSearchableModelField(), ModelCriteriaBuilder.Operator.IN, new Object[]{Arrays.asList(value)});
            }
            case URI_NOT_NULL: {
                return mcb.compare(Resource.SearchableFields.URI, ModelCriteriaBuilder.Operator.EXISTS, new Object[0]);
            }
            case OWNER_MANAGED_ACCESS: {
                return mcb.compare(Resource.SearchableFields.OWNER_MANAGED_ACCESS, ModelCriteriaBuilder.Operator.EQ, new Object[]{Boolean.valueOf(value[0])});
            }
            case EXACT_NAME: {
                return mcb.compare(Resource.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{value[0]});
            }
            case NAME: {
                return mcb.compare(Resource.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + value[0] + "%"});
            }
            case TYPE: {
                return mcb.compare(Resource.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + value[0] + "%"});
            }
        }
        throw new IllegalArgumentException("Unsupported filter [" + name + "]");
    }

    public void findByScopes(ResourceServer resourceServer, Set<Scope> scopes, Consumer<Resource> consumer) {
        LOG.tracef("findByScope(%s, %s, %s)%s", new Object[]{scopes, resourceServer, consumer, StackUtil.getShortStackTrace()});
        this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(Resource.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.IN, new Object[]{scopes.stream().map(Scope::getId)}))).map(this::entityToAdapter).forEach(consumer);
    }

    public Resource findByName(ResourceServer resourceServer, String name, String ownerId) {
        LOG.tracef("findByName(%s, %s, %s)%s", new Object[]{name, ownerId, resourceServer, StackUtil.getShortStackTrace()});
        return this.tx.read(QueryParameters.withCriteria(((DefaultModelCriteria)this.forResourceServer(resourceServer).compare(Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, new Object[]{ownerId})).compare(Resource.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name}))).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public void findByType(ResourceServer resourceServer, String type, Consumer<Resource> consumer) {
        LOG.tracef("findByType(%s, %s, %s)%s", new Object[]{type, resourceServer, consumer, StackUtil.getShortStackTrace()});
        this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(Resource.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, new Object[]{type}))).map(this::entityToAdapter).forEach(consumer);
    }

    public void findByType(ResourceServer resourceServer, String type, String owner, Consumer<Resource> consumer) {
        LOG.tracef("findByType(%s, %s, %s, %s)%s", new Object[]{type, owner, resourceServer, consumer, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = this.forResourceServer(resourceServer).compare(Resource.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, new Object[]{type});
        if (owner != null) {
            mcb = ((DefaultModelCriteria)mcb).compare(Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, new Object[]{owner});
        }
        this.tx.read(QueryParameters.withCriteria(mcb)).map(this::entityToAdapter).forEach(consumer);
    }

    public void findByTypeInstance(ResourceServer resourceServer, String type, Consumer<Resource> consumer) {
        LOG.tracef("findByTypeInstance(%s, %s, %s)%s", new Object[]{type, resourceServer, consumer, StackUtil.getShortStackTrace()});
        this.tx.read(QueryParameters.withCriteria(((DefaultModelCriteria)this.forResourceServer(resourceServer).compare(Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.NE, new Object[]{resourceServer.getClientId()})).compare(Resource.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, new Object[]{type}))).map(this::entityToAdapter).forEach(consumer);
    }
}

