/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.group;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.GroupModel;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.group.MapGroupAdapter;
import org.keycloak.models.map.group.MapGroupEntity;
import org.keycloak.models.map.group.MapGroupEntityImpl;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.provider.ProviderEvent;

public class MapGroupProvider
implements GroupProvider {
    private static final Logger LOG = Logger.getLogger(MapGroupProvider.class);
    private final KeycloakSession session;
    final MapKeycloakTransaction<MapGroupEntity, GroupModel> tx;

    public MapGroupProvider(KeycloakSession session, MapStorage<MapGroupEntity, GroupModel> groupStore) {
        this.session = session;
        this.tx = groupStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private Function<MapGroupEntity, GroupModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapGroupAdapter(this.session, realm, (MapGroupEntity)origEntity);
    }

    public GroupModel getGroupById(RealmModel realm, String id) {
        if (id == null) {
            return null;
        }
        LOG.tracef("getGroupById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        MapGroupEntity entity = this.tx.read(id);
        String realmId = realm.getId();
        return entity == null || !Objects.equals(realmId, entity.getRealmId()) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm) {
        return this.getGroupsStreamInternal(realm, null, null);
    }

    private Stream<GroupModel> getGroupsStreamInternal(RealmModel realm, UnaryOperator<DefaultModelCriteria<GroupModel>> modifier, UnaryOperator<QueryParameters<GroupModel>> queryParametersModifier) {
        LOG.tracef("getGroupsStream(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        if (modifier != null) {
            mcb = (DefaultModelCriteria)modifier.apply(mcb);
        }
        QueryParameters queryParameters = QueryParameters.withCriteria(mcb).orderBy(GroupModel.SearchableFields.NAME, QueryParameters.Order.ASCENDING);
        if (queryParametersModifier != null) {
            queryParameters = (QueryParameters)queryParametersModifier.apply(queryParameters);
        }
        return this.tx.read(queryParameters).map(this.entityToAdapterFunc(realm));
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb).compare(GroupModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.IN, new Object[]{ids})).compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        if (search != null) {
            mcb = ((DefaultModelCriteria)mcb).compare(GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"});
        }
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(first, max, GroupModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public Long getGroupsCount(RealmModel realm, Boolean onlyTopGroups) {
        LOG.tracef("getGroupsCount(%s, %s)%s", (Object)realm, (Object)onlyTopGroups, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb).compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        if (Objects.equals(onlyTopGroups, Boolean.TRUE)) {
            mcb = ((DefaultModelCriteria)mcb).compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        }
        return this.tx.getCount(QueryParameters.withCriteria(mcb));
    }

    public Long getGroupsCountByNameContaining(RealmModel realm, String search) {
        return this.searchForGroupByNameStream(realm, search, null, null).count();
    }

    public Stream<GroupModel> getGroupsByRoleStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        LOG.tracef("getGroupsByRole(%s, %s, %d, %d)%s", new Object[]{realm, role, firstResult, maxResults, StackUtil.getShortStackTrace()});
        return this.getGroupsStreamInternal(realm, mcb -> mcb.compare(GroupModel.SearchableFields.ASSIGNED_ROLE, ModelCriteriaBuilder.Operator.EQ, new Object[]{role.getId()}), qp -> qp.offset(firstResult).limit(maxResults));
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm) {
        LOG.tracef("getTopLevelGroupsStream(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        return this.getGroupsStreamInternal(realm, mcb -> mcb.compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]), null);
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        LOG.tracef("getTopLevelGroupsStream(%s, %s, %s)%s", new Object[]{realm, firstResult, maxResults, StackUtil.getShortStackTrace()});
        return this.getGroupsStreamInternal(realm, mcb -> mcb.compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]), qp -> qp.offset(firstResult).limit(maxResults));
    }

    public Stream<GroupModel> searchForGroupByNameStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        LOG.tracef("searchForGroupByNameStream(%s, %s, %d, %d)%s", new Object[]{realm, search, firstResult, maxResults, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"});
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, GroupModel.SearchableFields.NAME)).map(AbstractEntity::getId).map(id -> {
            GroupModel groupById = this.session.groups().getGroupById(realm, id);
            while (Objects.nonNull(groupById.getParentId())) {
                groupById = this.session.groups().getGroupById(realm, groupById.getParentId());
            }
            return groupById;
        }).sorted(GroupModel.COMPARE_BY_NAME).distinct();
    }

    public GroupModel createGroup(RealmModel realm, String id, String name, GroupModel toParent) {
        LOG.tracef("createGroup(%s, %s, %s, %s)%s", new Object[]{realm, id, name, toParent, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb).compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name});
        ModelCriteriaBuilder modelCriteriaBuilder = mcb = toParent == null ? ((DefaultModelCriteria)mcb).compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]) : ((DefaultModelCriteria)mcb).compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{toParent.getId()});
        if (this.tx.getCount(QueryParameters.withCriteria(mcb)) > 0L) {
            throw new ModelDuplicateException("Group with name '" + name + "' in realm " + realm.getName() + " already exists for requested parent");
        }
        MapGroupEntity entity = new MapGroupEntityImpl();
        entity.setId(id);
        entity.setRealmId(realm.getId());
        entity.setName(name);
        entity.setParentId(toParent == null ? null : toParent.getId());
        if (id != null && this.tx.read(id) != null) {
            throw new ModelDuplicateException("Group exists: " + id);
        }
        entity = this.tx.create(entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public boolean removeGroup(final RealmModel realm, final GroupModel group) {
        LOG.tracef("removeGroup(%s, %s)%s", (Object)realm, (Object)group, StackUtil.getShortStackTrace());
        if (group == null) {
            return false;
        }
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new GroupModel.GroupRemovedEvent(){

            public RealmModel getRealm() {
                return realm;
            }

            public GroupModel getGroup() {
                return group;
            }

            public KeycloakSession getKeycloakSession() {
                return MapGroupProvider.this.session;
            }
        });
        this.session.users().preRemove(realm, group);
        realm.removeDefaultGroup(group);
        group.getSubGroupsStream().collect(Collectors.toSet()).forEach(subGroup -> this.session.groups().removeGroup(realm, subGroup));
        this.tx.delete(group.getId());
        return true;
    }

    public void moveGroup(RealmModel realm, GroupModel group, GroupModel toParent) {
        LOG.tracef("moveGroup(%s, %s, %s)%s", new Object[]{realm, group, toParent, StackUtil.getShortStackTrace()});
        if (toParent != null && group.getId().equals(toParent.getId())) {
            return;
        }
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb).compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{group.getName()});
        mcb = toParent == null ? ((DefaultModelCriteria)mcb).compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]) : ((DefaultModelCriteria)mcb).compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{toParent.getId()});
        try (Stream<MapGroupEntity> possibleSiblings = this.tx.read(QueryParameters.withCriteria(mcb));){
            if (possibleSiblings.findAny().isPresent()) {
                throw new ModelDuplicateException("Parent already contains subgroup named '" + group.getName() + "'");
            }
        }
        if (group.getParentId() != null) {
            group.getParent().removeChild(group);
        }
        group.setParent(toParent);
        if (toParent != null) {
            toParent.addChild(group);
        }
    }

    public void addTopLevelGroup(RealmModel realm, GroupModel subGroup) {
        LOG.tracef("addTopLevelGroup(%s, %s)%s", (Object)realm, (Object)subGroup, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{null})).compare(GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{subGroup.getName()});
        try (Stream<MapGroupEntity> possibleSiblings = this.tx.read(QueryParameters.withCriteria(mcb));){
            if (possibleSiblings.findAny().isPresent()) {
                throw new ModelDuplicateException("There is already a top level group named '" + subGroup.getName() + "'");
            }
        }
        subGroup.setParent(null);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        LOG.tracef("preRemove(%s, %s)%s", (Object)realm, (Object)role, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(GroupModel.SearchableFields.ASSIGNED_ROLE, ModelCriteriaBuilder.Operator.EQ, new Object[]{role.getId()});
        try (Stream<MapGroupEntity> toRemove = this.tx.read(QueryParameters.withCriteria(mcb));){
            toRemove.map(groupEntity -> this.session.groups().getGroupById(realm, groupEntity.getId())).forEach(groupModel -> groupModel.deleteRoleMapping(role));
        }
    }

    public void close() {
    }
}

