/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.CibaConfig;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.OAuth2DeviceConfig;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.ParConfig;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.realm.AbstractRealmModel;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationExecutionEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticatorConfigEntity;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntity;
import org.keycloak.models.map.realm.entity.MapComponentEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderMapperEntity;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntity;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntity;
import org.keycloak.models.map.realm.entity.MapRequiredCredentialEntity;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntity;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.provider.ProviderEvent;

public class MapRealmAdapter
extends AbstractRealmModel<MapRealmEntity>
implements RealmModel {
    private static final Logger LOG = Logger.getLogger(MapRealmAdapter.class);
    private static final String ACTION_TOKEN_GENERATED_BY_USER_LIFESPAN = "actionTokenGeneratedByUserLifespan";
    private static final String DEFAULT_SIGNATURE_ALGORITHM = "defaultSignatureAlgorithm";
    private static final String BRUTE_FORCE_PROTECTED = "bruteForceProtected";
    private static final String PERMANENT_LOCKOUT = "permanentLockout";
    private static final String MAX_FAILURE_WAIT_SECONDS = "maxFailureWaitSeconds";
    private static final String WAIT_INCREMENT_SECONDS = "waitIncrementSeconds";
    private static final String QUICK_LOGIN_CHECK_MILLISECONDS = "quickLoginCheckMilliSeconds";
    private static final String MINIMUM_QUICK_LOGIN_WAIT_SECONDS = "minimumQuickLoginWaitSeconds";
    private static final String MAX_DELTA_SECONDS = "maxDeltaTimeSeconds";
    private static final String FAILURE_FACTOR = "failureFactor";
    private PasswordPolicy passwordPolicy;
    private static final String COMPONENT_PROVIDER_EXISTS_DISABLED = "component.provider.exists.disabled";

    public MapRealmAdapter(KeycloakSession session, MapRealmEntity entity) {
        super(session, entity);
    }

    public String getId() {
        return ((MapRealmEntity)this.entity).getId();
    }

    public String getName() {
        return ((MapRealmEntity)this.entity).getName();
    }

    public void setName(String name) {
        ((MapRealmEntity)this.entity).setName(name);
    }

    public String getDisplayName() {
        return ((MapRealmEntity)this.entity).getDisplayName();
    }

    public void setDisplayName(String displayName) {
        ((MapRealmEntity)this.entity).setDisplayName(displayName);
    }

    public String getDisplayNameHtml() {
        return ((MapRealmEntity)this.entity).getDisplayNameHtml();
    }

    public void setDisplayNameHtml(String displayNameHtml) {
        ((MapRealmEntity)this.entity).setDisplayNameHtml(displayNameHtml);
    }

    public boolean isEnabled() {
        Boolean enabled = ((MapRealmEntity)this.entity).isEnabled();
        return enabled == null ? false : enabled;
    }

    public void setEnabled(boolean enabled) {
        ((MapRealmEntity)this.entity).setEnabled(enabled);
    }

    public SslRequired getSslRequired() {
        String sslRequired = ((MapRealmEntity)this.entity).getSslRequired();
        return sslRequired == null ? null : SslRequired.valueOf((String)sslRequired);
    }

    public void setSslRequired(SslRequired sslRequired) {
        ((MapRealmEntity)this.entity).setSslRequired(sslRequired.name());
    }

    public boolean isRegistrationAllowed() {
        Boolean is = ((MapRealmEntity)this.entity).isRegistrationAllowed();
        return is == null ? false : is;
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        ((MapRealmEntity)this.entity).setRegistrationAllowed(registrationAllowed);
    }

    public boolean isRegistrationEmailAsUsername() {
        Boolean is = ((MapRealmEntity)this.entity).isRegistrationEmailAsUsername();
        return is == null ? false : is;
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        ((MapRealmEntity)this.entity).setRegistrationEmailAsUsername(registrationEmailAsUsername);
    }

    public boolean isRememberMe() {
        Boolean is = ((MapRealmEntity)this.entity).isRememberMe();
        return is == null ? false : is;
    }

    public void setRememberMe(boolean rememberMe) {
        ((MapRealmEntity)this.entity).setRememberMe(rememberMe);
    }

    public boolean isEditUsernameAllowed() {
        Boolean is = ((MapRealmEntity)this.entity).isEditUsernameAllowed();
        return is == null ? false : is;
    }

    public void setEditUsernameAllowed(boolean editUsernameAllowed) {
        ((MapRealmEntity)this.entity).setEditUsernameAllowed(editUsernameAllowed);
    }

    public boolean isUserManagedAccessAllowed() {
        Boolean is = ((MapRealmEntity)this.entity).isAllowUserManagedAccess();
        return is == null ? false : is;
    }

    public void setUserManagedAccessAllowed(boolean userManagedAccessAllowed) {
        ((MapRealmEntity)this.entity).setAllowUserManagedAccess(userManagedAccessAllowed);
    }

    public void setAttribute(String name, String value) {
        ((MapRealmEntity)this.entity).setAttribute(name, Collections.singletonList(value));
    }

    public void removeAttribute(String name) {
        ((MapRealmEntity)this.entity).removeAttribute(name);
    }

    public String getAttribute(String name) {
        List<String> attribute = ((MapRealmEntity)this.entity).getAttribute(name);
        if (attribute == null || attribute.isEmpty()) {
            return null;
        }
        return attribute.get(0);
    }

    public Map<String, String> getAttributes() {
        Map<String, List<String>> attrs = ((MapRealmEntity)this.entity).getAttributes();
        return attrs == null || attrs.isEmpty() ? Collections.emptyMap() : attrs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            if (((List)entry.getValue()).isEmpty()) {
                return null;
            }
            if (((List)entry.getValue()).size() > 1) {
                LOG.warnf("Realm '%s' has attribute '%s' with %d values, retrieving only the first", (Object)this.getId(), entry.getKey(), (Object)((List)entry.getValue()).size());
            }
            return (String)((List)entry.getValue()).get(0);
        }));
    }

    public boolean isVerifyEmail() {
        Boolean is = ((MapRealmEntity)this.entity).isVerifyEmail();
        return is == null ? false : is;
    }

    public void setVerifyEmail(boolean verifyEmail) {
        ((MapRealmEntity)this.entity).setVerifyEmail(verifyEmail);
    }

    public boolean isLoginWithEmailAllowed() {
        Boolean is = ((MapRealmEntity)this.entity).isLoginWithEmailAllowed();
        return is == null ? false : is;
    }

    public void setLoginWithEmailAllowed(boolean loginWithEmailAllowed) {
        ((MapRealmEntity)this.entity).setLoginWithEmailAllowed(loginWithEmailAllowed);
    }

    public boolean isDuplicateEmailsAllowed() {
        Boolean is = ((MapRealmEntity)this.entity).isDuplicateEmailsAllowed();
        return is == null ? false : is;
    }

    public void setDuplicateEmailsAllowed(boolean duplicateEmailsAllowed) {
        ((MapRealmEntity)this.entity).setDuplicateEmailsAllowed(duplicateEmailsAllowed);
    }

    public boolean isResetPasswordAllowed() {
        Boolean is = ((MapRealmEntity)this.entity).isResetPasswordAllowed();
        return is == null ? false : is;
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        ((MapRealmEntity)this.entity).setResetPasswordAllowed(resetPasswordAllowed);
    }

    public boolean isRevokeRefreshToken() {
        Boolean is = ((MapRealmEntity)this.entity).isRevokeRefreshToken();
        return is == null ? false : is;
    }

    public void setRevokeRefreshToken(boolean revokeRefreshToken) {
        ((MapRealmEntity)this.entity).setRevokeRefreshToken(revokeRefreshToken);
    }

    public int getRefreshTokenMaxReuse() {
        Integer i = ((MapRealmEntity)this.entity).getRefreshTokenMaxReuse();
        return i == null ? 0 : i;
    }

    public void setRefreshTokenMaxReuse(int revokeRefreshTokenCount) {
        ((MapRealmEntity)this.entity).setRefreshTokenMaxReuse(revokeRefreshTokenCount);
    }

    public int getSsoSessionIdleTimeout() {
        Integer i = ((MapRealmEntity)this.entity).getSsoSessionIdleTimeout();
        return i == null ? 0 : i;
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        ((MapRealmEntity)this.entity).setSsoSessionIdleTimeout(seconds);
    }

    public int getSsoSessionMaxLifespan() {
        Integer i = ((MapRealmEntity)this.entity).getSsoSessionMaxLifespan();
        return i == null ? 0 : i;
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setSsoSessionMaxLifespan(seconds);
    }

    public int getSsoSessionIdleTimeoutRememberMe() {
        Integer i = ((MapRealmEntity)this.entity).getSsoSessionIdleTimeoutRememberMe();
        return i == null ? 0 : i;
    }

    public void setSsoSessionIdleTimeoutRememberMe(int seconds) {
        ((MapRealmEntity)this.entity).setSsoSessionIdleTimeoutRememberMe(seconds);
    }

    public int getSsoSessionMaxLifespanRememberMe() {
        Integer i = ((MapRealmEntity)this.entity).getSsoSessionMaxLifespanRememberMe();
        return i == null ? 0 : i;
    }

    public void setSsoSessionMaxLifespanRememberMe(int seconds) {
        ((MapRealmEntity)this.entity).setSsoSessionMaxLifespanRememberMe(seconds);
    }

    public int getOfflineSessionIdleTimeout() {
        Integer i = ((MapRealmEntity)this.entity).getOfflineSessionIdleTimeout();
        return i == null ? 0 : i;
    }

    public void setOfflineSessionIdleTimeout(int seconds) {
        ((MapRealmEntity)this.entity).setOfflineSessionIdleTimeout(seconds);
    }

    public int getAccessTokenLifespan() {
        Integer i = ((MapRealmEntity)this.entity).getAccessTokenLifespan();
        return i == null ? 0 : i;
    }

    public int getClientSessionIdleTimeout() {
        Integer i = ((MapRealmEntity)this.entity).getClientSessionIdleTimeout();
        return i == null ? 0 : i;
    }

    public void setClientSessionIdleTimeout(int seconds) {
        ((MapRealmEntity)this.entity).setClientSessionIdleTimeout(seconds);
    }

    public int getClientSessionMaxLifespan() {
        Integer i = ((MapRealmEntity)this.entity).getClientSessionMaxLifespan();
        return i == null ? 0 : i;
    }

    public void setClientSessionMaxLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setClientSessionMaxLifespan(seconds);
    }

    public int getClientOfflineSessionIdleTimeout() {
        Integer i = ((MapRealmEntity)this.entity).getClientOfflineSessionIdleTimeout();
        return i == null ? 0 : i;
    }

    public void setClientOfflineSessionIdleTimeout(int seconds) {
        ((MapRealmEntity)this.entity).setClientOfflineSessionIdleTimeout(seconds);
    }

    public int getClientOfflineSessionMaxLifespan() {
        Integer i = ((MapRealmEntity)this.entity).getClientOfflineSessionMaxLifespan();
        return i == null ? 0 : i;
    }

    public void setClientOfflineSessionMaxLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setClientOfflineSessionMaxLifespan(seconds);
    }

    public void setAccessTokenLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setAccessTokenLifespan(seconds);
    }

    public int getAccessTokenLifespanForImplicitFlow() {
        Integer i = ((MapRealmEntity)this.entity).getAccessTokenLifespanForImplicitFlow();
        return i == null ? 0 : i;
    }

    public void setAccessTokenLifespanForImplicitFlow(int seconds) {
        ((MapRealmEntity)this.entity).setAccessTokenLifespanForImplicitFlow(seconds);
    }

    public int getAccessCodeLifespan() {
        Integer i = ((MapRealmEntity)this.entity).getAccessCodeLifespan();
        return i == null ? 0 : i;
    }

    public void setAccessCodeLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setAccessCodeLifespan(seconds);
    }

    public int getAccessCodeLifespanUserAction() {
        Integer i = ((MapRealmEntity)this.entity).getAccessCodeLifespanUserAction();
        return i == null ? 0 : i;
    }

    public void setAccessCodeLifespanUserAction(int seconds) {
        ((MapRealmEntity)this.entity).setAccessCodeLifespanUserAction(seconds);
    }

    public int getAccessCodeLifespanLogin() {
        Integer i = ((MapRealmEntity)this.entity).getAccessCodeLifespanLogin();
        return i == null ? 0 : i;
    }

    public void setAccessCodeLifespanLogin(int seconds) {
        ((MapRealmEntity)this.entity).setAccessCodeLifespanLogin(seconds);
    }

    public int getActionTokenGeneratedByAdminLifespan() {
        Integer i = ((MapRealmEntity)this.entity).getActionTokenGeneratedByAdminLifespan();
        return i == null ? 0 : i;
    }

    public void setActionTokenGeneratedByAdminLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setActionTokenGeneratedByAdminLifespan(seconds);
    }

    public int getActionTokenGeneratedByUserLifespan() {
        return this.getAttribute(ACTION_TOKEN_GENERATED_BY_USER_LIFESPAN, this.getAccessCodeLifespanUserAction());
    }

    public void setActionTokenGeneratedByUserLifespan(int seconds) {
        this.setAttribute(ACTION_TOKEN_GENERATED_BY_USER_LIFESPAN, seconds);
    }

    public int getActionTokenGeneratedByUserLifespan(String actionTokenType) {
        return this.getAttribute("actionTokenGeneratedByUserLifespan." + actionTokenType, this.getAccessCodeLifespanUserAction());
    }

    public void setActionTokenGeneratedByUserLifespan(String actionTokenType, Integer seconds) {
        if (actionTokenType != null && !actionTokenType.isEmpty() && seconds != null) {
            this.setAttribute("actionTokenGeneratedByUserLifespan." + actionTokenType, seconds);
        }
    }

    public Map<String, Integer> getUserActionTokenLifespans() {
        Map<String, List<String>> attrs = ((MapRealmEntity)this.entity).getAttributes();
        if (attrs == null || attrs.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Integer> tokenLifespans = attrs.entrySet().stream().filter(Objects::nonNull).filter(entry -> Objects.nonNull(entry.getValue()) && !((List)entry.getValue()).isEmpty()).filter(entry -> ((String)entry.getKey()).startsWith("actionTokenGeneratedByUserLifespan.")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(ACTION_TOKEN_GENERATED_BY_USER_LIFESPAN.length() + 1), entry -> Integer.valueOf((String)((List)entry.getValue()).get(0))));
        return Collections.unmodifiableMap(tokenLifespans);
    }

    public Stream<RequiredCredentialModel> getRequiredCredentialsStream() {
        Set<MapRequiredCredentialEntity> rCEs = ((MapRealmEntity)this.entity).getRequiredCredentials();
        return rCEs == null ? Stream.empty() : rCEs.stream().map(MapRequiredCredentialEntity::toModel);
    }

    public void addRequiredCredential(String cred) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(cred);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + cred);
        }
        ((MapRealmEntity)this.entity).addRequiredCredential(MapRequiredCredentialEntity.fromModel(model));
    }

    public void updateRequiredCredentials(Set<String> credentials) {
        Set<MapRequiredCredentialEntity> requiredCredentialEntities = ((MapRealmEntity)this.entity).getRequiredCredentials();
        Consumer<MapRequiredCredentialEntity> updateCredentialFnc = e -> {
            Optional<MapRequiredCredentialEntity> existingEntity = requiredCredentialEntities.stream().filter(existing -> Objects.equals(e.getType(), existing.getType())).findFirst();
            if (existingEntity.isPresent()) {
                this.updateRequiredCredential(existingEntity.get(), (MapRequiredCredentialEntity)e);
            } else {
                ((MapRealmEntity)this.entity).addRequiredCredential((MapRequiredCredentialEntity)e);
            }
        };
        credentials.stream().map(RequiredCredentialModel.BUILT_IN::get).peek(c -> {
            if (c == null) {
                throw new RuntimeException("Unknown credential type " + c.getType());
            }
        }).map(MapRequiredCredentialEntity::fromModel).forEach(updateCredentialFnc);
    }

    private void updateRequiredCredential(MapRequiredCredentialEntity existing, MapRequiredCredentialEntity newValue) {
        existing.setFormLabel(newValue.getFormLabel());
        existing.setInput(newValue.isInput());
        existing.setSecret(newValue.isSecret());
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = PasswordPolicy.parse((KeycloakSession)this.session, (String)((MapRealmEntity)this.entity).getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        ((MapRealmEntity)this.entity).setPasswordPolicy(policy.toString());
    }

    public OTPPolicy getOTPPolicy() {
        MapOTPPolicyEntity policy = ((MapRealmEntity)this.entity).getOTPPolicy();
        return policy == null ? OTPPolicy.DEFAULT_POLICY : MapOTPPolicyEntity.toModel(policy);
    }

    public void setOTPPolicy(OTPPolicy policy) {
        ((MapRealmEntity)this.entity).setOTPPolicy(MapOTPPolicyEntity.fromModel(policy));
    }

    public RoleModel getRoleById(String id) {
        return this.session.roles().getRoleById((RealmModel)this, id);
    }

    public Stream<GroupModel> getDefaultGroupsStream() {
        Set<String> gIds = ((MapRealmEntity)this.entity).getDefaultGroupIds();
        return gIds == null ? Stream.empty() : gIds.stream().map(this::getGroupById);
    }

    public void addDefaultGroup(GroupModel group) {
        ((MapRealmEntity)this.entity).addDefaultGroupId(group.getId());
    }

    public void removeDefaultGroup(GroupModel group) {
        ((MapRealmEntity)this.entity).removeDefaultGroupId(group.getId());
    }

    public Stream<ClientModel> getClientsStream() {
        return this.session.clients().getClientsStream((RealmModel)this);
    }

    public Stream<ClientModel> getClientsStream(Integer firstResult, Integer maxResults) {
        return this.session.clients().getClientsStream((RealmModel)this, firstResult, maxResults);
    }

    public Long getClientsCount() {
        return this.session.clients().getClientsCount((RealmModel)this);
    }

    public Stream<ClientModel> getAlwaysDisplayInConsoleClientsStream() {
        return this.session.clients().getAlwaysDisplayInConsoleClientsStream((RealmModel)this);
    }

    public ClientModel addClient(String name) {
        return this.session.clients().addClient((RealmModel)this, name);
    }

    public ClientModel addClient(String id, String clientId) {
        return this.session.clients().addClient((RealmModel)this, id, clientId);
    }

    public boolean removeClient(String id) {
        return this.session.clients().removeClient((RealmModel)this, id);
    }

    public ClientModel getClientById(String id) {
        return this.session.clients().getClientById((RealmModel)this, id);
    }

    public ClientModel getClientByClientId(String clientId) {
        return this.session.clients().getClientByClientId((RealmModel)this, clientId);
    }

    public Stream<ClientModel> searchClientByClientIdStream(String clientId, Integer firstResult, Integer maxResults) {
        return this.session.clients().searchClientsByClientIdStream((RealmModel)this, clientId, firstResult, maxResults);
    }

    public Stream<ClientModel> searchClientByAttributes(Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        return this.session.clients().searchClientsByAttributes((RealmModel)this, attributes, firstResult, maxResults);
    }

    public Map<String, String> getSmtpConfig() {
        Map<String, String> sC = ((MapRealmEntity)this.entity).getSmtpConfig();
        return sC == null ? Collections.emptyMap() : Collections.unmodifiableMap(sC);
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        ((MapRealmEntity)this.entity).setSmtpConfig(smtpConfig);
    }

    public AuthenticationFlowModel getBrowserFlow() {
        return this.getAuthenticationFlowById(((MapRealmEntity)this.entity).getBrowserFlow());
    }

    public void setBrowserFlow(AuthenticationFlowModel flow) {
        ((MapRealmEntity)this.entity).setBrowserFlow(flow.getId());
    }

    public AuthenticationFlowModel getRegistrationFlow() {
        return this.getAuthenticationFlowById(((MapRealmEntity)this.entity).getRegistrationFlow());
    }

    public void setRegistrationFlow(AuthenticationFlowModel flow) {
        ((MapRealmEntity)this.entity).setRegistrationFlow(flow.getId());
    }

    public AuthenticationFlowModel getDirectGrantFlow() {
        return this.getAuthenticationFlowById(((MapRealmEntity)this.entity).getDirectGrantFlow());
    }

    public void setDirectGrantFlow(AuthenticationFlowModel flow) {
        ((MapRealmEntity)this.entity).setDirectGrantFlow(flow.getId());
    }

    public AuthenticationFlowModel getResetCredentialsFlow() {
        return this.getAuthenticationFlowById(((MapRealmEntity)this.entity).getResetCredentialsFlow());
    }

    public void setResetCredentialsFlow(AuthenticationFlowModel flow) {
        ((MapRealmEntity)this.entity).setResetCredentialsFlow(flow.getId());
    }

    public AuthenticationFlowModel getClientAuthenticationFlow() {
        return this.getAuthenticationFlowById(((MapRealmEntity)this.entity).getClientAuthenticationFlow());
    }

    public void setClientAuthenticationFlow(AuthenticationFlowModel flow) {
        ((MapRealmEntity)this.entity).setClientAuthenticationFlow(flow.getId());
    }

    public AuthenticationFlowModel getDockerAuthenticationFlow() {
        return this.getAuthenticationFlowById(((MapRealmEntity)this.entity).getDockerAuthenticationFlow());
    }

    public void setDockerAuthenticationFlow(AuthenticationFlowModel flow) {
        ((MapRealmEntity)this.entity).setDockerAuthenticationFlow(flow.getId());
    }

    public Stream<AuthenticationFlowModel> getAuthenticationFlowsStream() {
        Set<MapAuthenticationFlowEntity> afs = ((MapRealmEntity)this.entity).getAuthenticationFlows();
        return afs == null ? Stream.empty() : afs.stream().map(MapAuthenticationFlowEntity::toModel);
    }

    public AuthenticationFlowModel getFlowByAlias(String alias) {
        Set<MapAuthenticationFlowEntity> afs = ((MapRealmEntity)this.entity).getAuthenticationFlows();
        return afs == null ? null : (AuthenticationFlowModel)afs.stream().filter(flow -> Objects.equals(flow.getAlias(), alias)).findFirst().map(MapAuthenticationFlowEntity::toModel).orElse(null);
    }

    public AuthenticationFlowModel addAuthenticationFlow(AuthenticationFlowModel model) {
        if (((MapRealmEntity)this.entity).getAuthenticationFlow(model.getId()).isPresent()) {
            throw new ModelDuplicateException("An AuthenticationFlow with given id already exists");
        }
        MapAuthenticationFlowEntity authenticationFlowEntity = MapAuthenticationFlowEntity.fromModel(model);
        ((MapRealmEntity)this.entity).addAuthenticationFlow(authenticationFlowEntity);
        return MapAuthenticationFlowEntity.toModel(authenticationFlowEntity);
    }

    public AuthenticationFlowModel getAuthenticationFlowById(String flowId) {
        if (flowId == null) {
            return null;
        }
        return ((MapRealmEntity)this.entity).getAuthenticationFlow(flowId).map(MapAuthenticationFlowEntity::toModel).orElse(null);
    }

    public void removeAuthenticationFlow(AuthenticationFlowModel model) {
        ((MapRealmEntity)this.entity).removeAuthenticationFlow(model.getId());
    }

    public void updateAuthenticationFlow(AuthenticationFlowModel model) {
        ((MapRealmEntity)this.entity).getAuthenticationFlow(model.getId()).ifPresent(existing -> {
            existing.setAlias(model.getAlias());
            existing.setDescription(model.getDescription());
            existing.setProviderId(model.getProviderId());
            existing.setBuiltIn(model.isBuiltIn());
            existing.setTopLevel(model.isTopLevel());
        });
    }

    public Stream<AuthenticationExecutionModel> getAuthenticationExecutionsStream(String flowId) {
        Set<MapAuthenticationExecutionEntity> aee = ((MapRealmEntity)this.entity).getAuthenticationExecutions();
        return aee == null ? Stream.empty() : aee.stream().filter(execution -> Objects.equals(flowId, execution.getParentFlowId())).map(MapAuthenticationExecutionEntity::toModel).sorted((Comparator<AuthenticationExecutionModel>)AuthenticationExecutionModel.ExecutionComparator.SINGLETON);
    }

    public AuthenticationExecutionModel getAuthenticationExecutionById(String id) {
        if (id == null) {
            return null;
        }
        return ((MapRealmEntity)this.entity).getAuthenticationExecution(id).map(MapAuthenticationExecutionEntity::toModel).orElse(null);
    }

    public AuthenticationExecutionModel getAuthenticationExecutionByFlowId(String flowId) {
        Set<MapAuthenticationExecutionEntity> aee = ((MapRealmEntity)this.entity).getAuthenticationExecutions();
        return aee == null ? null : (AuthenticationExecutionModel)aee.stream().filter(execution -> Objects.equals(flowId, execution.getFlowId())).findAny().map(MapAuthenticationExecutionEntity::toModel).orElse(null);
    }

    public AuthenticationExecutionModel addAuthenticatorExecution(AuthenticationExecutionModel model) {
        if (((MapRealmEntity)this.entity).getAuthenticationExecution(model.getId()).isPresent()) {
            throw new ModelDuplicateException("An RequiredActionProvider with given id already exists");
        }
        MapAuthenticationExecutionEntity executionEntity = MapAuthenticationExecutionEntity.fromModel(model);
        ((MapRealmEntity)this.entity).addAuthenticationExecution(executionEntity);
        return MapAuthenticationExecutionEntity.toModel(executionEntity);
    }

    public void updateAuthenticatorExecution(AuthenticationExecutionModel model) {
        ((MapRealmEntity)this.entity).getAuthenticationExecution(model.getId()).ifPresent(existing -> {
            existing.setAuthenticator(model.getAuthenticator());
            existing.setAuthenticatorConfig(model.getAuthenticatorConfig());
            existing.setFlowId(model.getFlowId());
            existing.setParentFlowId(model.getParentFlow());
            existing.setRequirement(model.getRequirement());
            existing.setAutheticatorFlow(model.isAuthenticatorFlow());
            existing.setPriority(model.getPriority());
        });
    }

    public void removeAuthenticatorExecution(AuthenticationExecutionModel model) {
        ((MapRealmEntity)this.entity).removeAuthenticationExecution(model.getId());
    }

    public Stream<AuthenticatorConfigModel> getAuthenticatorConfigsStream() {
        Set<MapAuthenticatorConfigEntity> acs = ((MapRealmEntity)this.entity).getAuthenticatorConfigs();
        return acs == null ? Stream.empty() : acs.stream().map(MapAuthenticatorConfigEntity::toModel);
    }

    public AuthenticatorConfigModel addAuthenticatorConfig(AuthenticatorConfigModel model) {
        MapAuthenticatorConfigEntity authenticatorConfig = MapAuthenticatorConfigEntity.fromModel(model);
        ((MapRealmEntity)this.entity).addAuthenticatorConfig(authenticatorConfig);
        model.setId(authenticatorConfig.getId());
        return model;
    }

    public void updateAuthenticatorConfig(AuthenticatorConfigModel model) {
        ((MapRealmEntity)this.entity).getAuthenticatorConfig(model.getId()).ifPresent(oldAC -> {
            oldAC.setAlias(model.getAlias());
            oldAC.setConfig(model.getConfig());
        });
    }

    public void removeAuthenticatorConfig(AuthenticatorConfigModel model) {
        ((MapRealmEntity)this.entity).removeAuthenticatorConfig(model.getId());
    }

    public AuthenticatorConfigModel getAuthenticatorConfigById(String id) {
        if (id == null) {
            return null;
        }
        return ((MapRealmEntity)this.entity).getAuthenticatorConfig(id).map(MapAuthenticatorConfigEntity::toModel).orElse(null);
    }

    public AuthenticatorConfigModel getAuthenticatorConfigByAlias(String alias) {
        Set<MapAuthenticatorConfigEntity> acs = ((MapRealmEntity)this.entity).getAuthenticatorConfigs();
        return acs == null ? null : (AuthenticatorConfigModel)acs.stream().filter(config -> Objects.equals(config.getAlias(), alias)).findFirst().map(MapAuthenticatorConfigEntity::toModel).orElse(null);
    }

    public Stream<RequiredActionProviderModel> getRequiredActionProvidersStream() {
        Set<MapRequiredActionProviderEntity> raps = ((MapRealmEntity)this.entity).getRequiredActionProviders();
        return raps == null ? Stream.empty() : raps.stream().map(MapRequiredActionProviderEntity::toModel).sorted((Comparator<RequiredActionProviderModel>)RequiredActionProviderModel.RequiredActionComparator.SINGLETON);
    }

    public RequiredActionProviderModel addRequiredActionProvider(RequiredActionProviderModel model) {
        MapRequiredActionProviderEntity requiredActionProvider = MapRequiredActionProviderEntity.fromModel(model);
        ((MapRealmEntity)this.entity).addRequiredActionProvider(requiredActionProvider);
        return MapRequiredActionProviderEntity.toModel(requiredActionProvider);
    }

    public void updateRequiredActionProvider(RequiredActionProviderModel model) {
        ((MapRealmEntity)this.entity).getRequiredActionProvider(model.getId()).ifPresent(oldRAP -> {
            oldRAP.setAlias(model.getAlias());
            oldRAP.setName(model.getName());
            oldRAP.setProviderId(model.getProviderId());
            oldRAP.setPriority(model.getPriority());
            oldRAP.setEnabled(model.isEnabled());
            oldRAP.setDefaultAction(model.isDefaultAction());
            oldRAP.setConfig(model.getConfig());
        });
    }

    public void removeRequiredActionProvider(RequiredActionProviderModel model) {
        ((MapRealmEntity)this.entity).removeRequiredActionProvider(model.getId());
    }

    public RequiredActionProviderModel getRequiredActionProviderById(String id) {
        if (id == null) {
            return null;
        }
        return ((MapRealmEntity)this.entity).getRequiredActionProvider(id).map(MapRequiredActionProviderEntity::toModel).orElse(null);
    }

    public RequiredActionProviderModel getRequiredActionProviderByAlias(String alias) {
        Set<MapRequiredActionProviderEntity> raps = ((MapRealmEntity)this.entity).getRequiredActionProviders();
        return raps == null ? null : (RequiredActionProviderModel)raps.stream().filter(actionProvider -> Objects.equals(actionProvider.getAlias(), alias)).findFirst().map(MapRequiredActionProviderEntity::toModel).orElse(null);
    }

    public Stream<IdentityProviderModel> getIdentityProvidersStream() {
        Set<MapIdentityProviderEntity> ips = ((MapRealmEntity)this.entity).getIdentityProviders();
        return ips == null ? Stream.empty() : ips.stream().map(MapIdentityProviderEntity::toModel);
    }

    public IdentityProviderModel getIdentityProviderByAlias(String alias) {
        Set<MapIdentityProviderEntity> ips = ((MapRealmEntity)this.entity).getIdentityProviders();
        return ips == null ? null : (IdentityProviderModel)ips.stream().filter(identityProvider -> Objects.equals(identityProvider.getAlias(), alias)).findFirst().map(MapIdentityProviderEntity::toModel).orElse(null);
    }

    public void addIdentityProvider(IdentityProviderModel model) {
        ((MapRealmEntity)this.entity).addIdentityProvider(MapIdentityProviderEntity.fromModel(model));
    }

    public void removeIdentityProviderByAlias(String alias) {
        final IdentityProviderModel model = this.getIdentityProviderByAlias(alias);
        ((MapRealmEntity)this.entity).removeIdentityProvider(model.getInternalId());
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.IdentityProviderRemovedEvent(){

            public RealmModel getRealm() {
                return MapRealmAdapter.this;
            }

            public IdentityProviderModel getRemovedIdentityProvider() {
                return model;
            }

            public KeycloakSession getKeycloakSession() {
                return MapRealmAdapter.this.session;
            }
        });
    }

    public void updateIdentityProvider(final IdentityProviderModel identityProvider) {
        Set<MapIdentityProviderEntity> ips = ((MapRealmEntity)this.entity).getIdentityProviders();
        if (ips != null) {
            ips.stream().filter(ip -> Objects.equals(ip.getId(), identityProvider.getInternalId())).findFirst().ifPresent(oldPS -> {
                oldPS.setAlias(identityProvider.getAlias());
                oldPS.setDisplayName(identityProvider.getDisplayName());
                oldPS.setProviderId(identityProvider.getProviderId());
                oldPS.setFirstBrokerLoginFlowId(identityProvider.getFirstBrokerLoginFlowId());
                oldPS.setPostBrokerLoginFlowId(identityProvider.getPostBrokerLoginFlowId());
                oldPS.setEnabled(identityProvider.isEnabled());
                oldPS.setTrustEmail(identityProvider.isTrustEmail());
                oldPS.setStoreToken(identityProvider.isStoreToken());
                oldPS.setLinkOnly(identityProvider.isLinkOnly());
                oldPS.setAddReadTokenRoleOnCreate(identityProvider.isAddReadTokenRoleOnCreate());
                oldPS.setAuthenticateByDefault(identityProvider.isAuthenticateByDefault());
                oldPS.setConfig(identityProvider.getConfig() == null ? null : new HashMap(identityProvider.getConfig()));
            });
            this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.IdentityProviderUpdatedEvent(){

                public RealmModel getRealm() {
                    return MapRealmAdapter.this;
                }

                public IdentityProviderModel getUpdatedIdentityProvider() {
                    return identityProvider;
                }

                public KeycloakSession getKeycloakSession() {
                    return MapRealmAdapter.this.session;
                }
            });
        }
    }

    public Stream<IdentityProviderMapperModel> getIdentityProviderMappersStream() {
        Set<MapIdentityProviderMapperEntity> ipms = ((MapRealmEntity)this.entity).getIdentityProviderMappers();
        return ipms == null ? Stream.empty() : ipms.stream().map(MapIdentityProviderMapperEntity::toModel);
    }

    public Stream<IdentityProviderMapperModel> getIdentityProviderMappersByAliasStream(String brokerAlias) {
        Set<MapIdentityProviderMapperEntity> ipms = ((MapRealmEntity)this.entity).getIdentityProviderMappers();
        return ipms == null ? Stream.empty() : ipms.stream().filter(mapper -> Objects.equals(mapper.getIdentityProviderAlias(), brokerAlias)).map(MapIdentityProviderMapperEntity::toModel);
    }

    public IdentityProviderMapperModel addIdentityProviderMapper(IdentityProviderMapperModel model) {
        MapIdentityProviderMapperEntity identityProviderMapper = MapIdentityProviderMapperEntity.fromModel(model);
        if (((MapRealmEntity)this.entity).getIdentityProviderMapper(model.getId()).isPresent()) {
            throw new ModelDuplicateException("An IdentityProviderMapper with given id already exists");
        }
        ((MapRealmEntity)this.entity).addIdentityProviderMapper(identityProviderMapper);
        return MapIdentityProviderMapperEntity.toModel(identityProviderMapper);
    }

    public void removeIdentityProviderMapper(IdentityProviderMapperModel model) {
        ((MapRealmEntity)this.entity).removeIdentityProviderMapper(model.getId());
    }

    public void updateIdentityProviderMapper(IdentityProviderMapperModel model) {
        ((MapRealmEntity)this.entity).getIdentityProviderMapper(model.getId()).ifPresent(oldIPM -> {
            oldIPM.setName(model.getName());
            oldIPM.setIdentityProviderAlias(model.getIdentityProviderAlias());
            oldIPM.setIdentityProviderMapper(model.getIdentityProviderMapper());
            oldIPM.setConfig(model.getConfig());
        });
    }

    public IdentityProviderMapperModel getIdentityProviderMapperById(String id) {
        if (id == null) {
            return null;
        }
        return ((MapRealmEntity)this.entity).getIdentityProviderMapper(id).map(MapIdentityProviderMapperEntity::toModel).orElse(null);
    }

    public IdentityProviderMapperModel getIdentityProviderMapperByName(String brokerAlias, String name) {
        Set<MapIdentityProviderMapperEntity> ipms = ((MapRealmEntity)this.entity).getIdentityProviderMappers();
        return ipms == null ? null : (IdentityProviderMapperModel)ipms.stream().filter(identityProviderMapper -> Objects.equals(identityProviderMapper.getIdentityProviderAlias(), brokerAlias) && Objects.equals(identityProviderMapper.getName(), name)).findFirst().map(MapIdentityProviderMapperEntity::toModel).orElse(null);
    }

    public ComponentModel addComponentModel(ComponentModel model) {
        model = this.importComponentModel(model);
        ComponentUtil.notifyCreated((KeycloakSession)this.session, (RealmModel)this, (ComponentModel)model);
        return model;
    }

    public ComponentModel importComponentModel(ComponentModel model) {
        block5: {
            try {
                ComponentFactory componentFactory = ComponentUtil.getComponentFactory((KeycloakSession)this.session, (ComponentModel)model);
                if (componentFactory == null && System.getProperty(COMPONENT_PROVIDER_EXISTS_DISABLED) == null) {
                    throw new IllegalArgumentException("Invalid component type");
                }
                componentFactory.validateConfiguration(this.session, (RealmModel)this, model);
            }
            catch (IllegalArgumentException | ComponentValidationException e) {
                if (System.getProperty(COMPONENT_PROVIDER_EXISTS_DISABLED) != null) break block5;
                throw e;
            }
        }
        if (((MapRealmEntity)this.entity).getComponent(model.getId()).isPresent()) {
            throw new ModelDuplicateException("A Component with given id already exists");
        }
        MapComponentEntity component = MapComponentEntity.fromModel(model);
        if (model.getParentId() == null) {
            component.setParentId(this.getId());
        }
        ((MapRealmEntity)this.entity).addComponent(component);
        return MapComponentEntity.toModel(component);
    }

    public void updateComponent(ComponentModel component) {
        ComponentUtil.getComponentFactory((KeycloakSession)this.session, (ComponentModel)component).validateConfiguration(this.session, (RealmModel)this, component);
        ((MapRealmEntity)this.entity).getComponent(component.getId()).ifPresent(existing -> {
            ComponentModel oldModel = MapComponentEntity.toModel(existing);
            MapRealmAdapter.updateComponent(existing, component);
            ComponentUtil.notifyUpdated((KeycloakSession)this.session, (RealmModel)this, (ComponentModel)oldModel, (ComponentModel)component);
        });
    }

    private static void updateComponent(MapComponentEntity oldValue, ComponentModel newValue) {
        oldValue.setName(newValue.getName());
        oldValue.setProviderId(newValue.getProviderId());
        oldValue.setProviderType(newValue.getProviderType());
        oldValue.setSubType(newValue.getSubType());
        oldValue.setParentId(newValue.getParentId());
        oldValue.setConfig((Map<String, List<String>>)newValue.getConfig());
    }

    public void removeComponent(ComponentModel component) {
        if (!((MapRealmEntity)this.entity).getComponent(component.getId()).isPresent()) {
            return;
        }
        this.session.users().preRemove((RealmModel)this, component);
        ComponentUtil.notifyPreRemove((KeycloakSession)this.session, (RealmModel)this, (ComponentModel)component);
        this.removeComponents(component.getId());
        ((MapRealmEntity)this.entity).removeComponent(component.getId());
    }

    public void removeComponents(String parentId) {
        Set<MapComponentEntity> components = ((MapRealmEntity)this.entity).getComponents();
        if (components == null || components.isEmpty()) {
            return;
        }
        components.stream().filter(c -> Objects.equals(parentId, c.getParentId())).map(MapComponentEntity::toModel).collect(Collectors.toSet()).forEach(c -> {
            this.session.users().preRemove((RealmModel)this, c);
            ComponentUtil.notifyPreRemove((KeycloakSession)this.session, (RealmModel)this, (ComponentModel)c);
            ((MapRealmEntity)this.entity).removeComponent(c.getId());
        });
    }

    public Stream<ComponentModel> getComponentsStream() {
        Set<MapComponentEntity> components = ((MapRealmEntity)this.entity).getComponents();
        return components == null ? Stream.empty() : components.stream().map(MapComponentEntity::toModel);
    }

    public Stream<ComponentModel> getComponentsStream(String parentId) {
        Set<MapComponentEntity> components = ((MapRealmEntity)this.entity).getComponents();
        return components == null ? Stream.empty() : components.stream().filter(c -> Objects.equals(parentId, c.getParentId())).map(MapComponentEntity::toModel);
    }

    public Stream<ComponentModel> getComponentsStream(String parentId, String providerType) {
        Set<MapComponentEntity> components = ((MapRealmEntity)this.entity).getComponents();
        return components == null ? Stream.empty() : components.stream().filter(c -> Objects.equals(parentId, c.getParentId())).filter(c -> Objects.equals(providerType, c.getProviderType())).map(MapComponentEntity::toModel);
    }

    public ComponentModel getComponent(String id) {
        return ((MapRealmEntity)this.entity).getComponent(id).map(MapComponentEntity::toModel).orElse(null);
    }

    public String getLoginTheme() {
        return ((MapRealmEntity)this.entity).getLoginTheme();
    }

    public void setLoginTheme(String name) {
        ((MapRealmEntity)this.entity).setLoginTheme(name);
    }

    public String getAccountTheme() {
        return ((MapRealmEntity)this.entity).getAccountTheme();
    }

    public void setAccountTheme(String name) {
        ((MapRealmEntity)this.entity).setAccountTheme(name);
    }

    public String getAdminTheme() {
        return ((MapRealmEntity)this.entity).getAdminTheme();
    }

    public void setAdminTheme(String name) {
        ((MapRealmEntity)this.entity).setAdminTheme(name);
    }

    public String getEmailTheme() {
        return ((MapRealmEntity)this.entity).getEmailTheme();
    }

    public void setEmailTheme(String name) {
        ((MapRealmEntity)this.entity).setEmailTheme(name);
    }

    public int getNotBefore() {
        Long notBefore = ((MapRealmEntity)this.entity).getNotBefore();
        return notBefore == null ? 0 : TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(notBefore);
    }

    public void setNotBefore(int notBefore) {
        ((MapRealmEntity)this.entity).setNotBefore(TimeAdapter.fromIntegerWithTimeInSecondsToLongWithTimeAsInSeconds(notBefore));
    }

    public boolean isEventsEnabled() {
        Boolean is = ((MapRealmEntity)this.entity).isEventsEnabled();
        return is == null ? false : is;
    }

    public void setEventsEnabled(boolean enabled) {
        ((MapRealmEntity)this.entity).setEventsEnabled(enabled);
    }

    public long getEventsExpiration() {
        Long i = ((MapRealmEntity)this.entity).getEventsExpiration();
        return i == null ? 0L : i;
    }

    public void setEventsExpiration(long expiration) {
        ((MapRealmEntity)this.entity).setEventsExpiration(expiration);
    }

    public Stream<String> getEventsListenersStream() {
        Set<String> eLs = ((MapRealmEntity)this.entity).getEventsListeners();
        return eLs == null ? Stream.empty() : eLs.stream();
    }

    public void setEventsListeners(Set<String> listeners) {
        ((MapRealmEntity)this.entity).setEventsListeners(listeners);
    }

    public Stream<String> getEnabledEventTypesStream() {
        Set<String> eETs = ((MapRealmEntity)this.entity).getEnabledEventTypes();
        return eETs == null ? Stream.empty() : eETs.stream();
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        ((MapRealmEntity)this.entity).setEnabledEventTypes(enabledEventTypes);
    }

    public boolean isAdminEventsEnabled() {
        Boolean is = ((MapRealmEntity)this.entity).isAdminEventsEnabled();
        return is == null ? false : is;
    }

    public void setAdminEventsEnabled(boolean enabled) {
        ((MapRealmEntity)this.entity).setAdminEventsEnabled(enabled);
    }

    public boolean isAdminEventsDetailsEnabled() {
        Boolean is = ((MapRealmEntity)this.entity).isAdminEventsDetailsEnabled();
        return is == null ? false : is;
    }

    public void setAdminEventsDetailsEnabled(boolean enabled) {
        ((MapRealmEntity)this.entity).setAdminEventsDetailsEnabled(enabled);
    }

    public ClientModel getMasterAdminClient() {
        String masterAdminClientId = ((MapRealmEntity)this.entity).getMasterAdminClient();
        if (masterAdminClientId == null) {
            return null;
        }
        MapRealmAdapter masterRealm = this.getName().equals(Config.getAdminRealm()) ? this : this.session.realms().getRealmByName(Config.getAdminRealm());
        return this.session.clients().getClientById((RealmModel)masterRealm, masterAdminClientId);
    }

    public void setMasterAdminClient(ClientModel client) {
        String id = client == null ? null : client.getId();
        ((MapRealmEntity)this.entity).setMasterAdminClient(id);
    }

    public RoleModel getDefaultRole() {
        return this.session.roles().getRoleById((RealmModel)this, ((MapRealmEntity)this.entity).getDefaultRoleId());
    }

    public void setDefaultRole(RoleModel role) {
        ((MapRealmEntity)this.entity).setDefaultRoleId(role.getId());
    }

    public boolean isIdentityFederationEnabled() {
        Set<MapIdentityProviderEntity> ips = ((MapRealmEntity)this.entity).getIdentityProviders();
        return ips != null && ips.stream().findAny().isPresent();
    }

    public boolean isInternationalizationEnabled() {
        Boolean is = ((MapRealmEntity)this.entity).isInternationalizationEnabled();
        return is == null ? false : is;
    }

    public void setInternationalizationEnabled(boolean enabled) {
        ((MapRealmEntity)this.entity).setInternationalizationEnabled(enabled);
    }

    public Stream<String> getSupportedLocalesStream() {
        Set<String> sLs = ((MapRealmEntity)this.entity).getSupportedLocales();
        return sLs == null ? Stream.empty() : sLs.stream();
    }

    public void setSupportedLocales(Set<String> locales) {
        ((MapRealmEntity)this.entity).setSupportedLocales(locales);
    }

    public String getDefaultLocale() {
        return ((MapRealmEntity)this.entity).getDefaultLocale();
    }

    public void setDefaultLocale(String locale) {
        ((MapRealmEntity)this.entity).setDefaultLocale(locale);
    }

    public GroupModel createGroup(String id, String name, GroupModel toParent) {
        return this.session.groups().createGroup((RealmModel)this, id, name, toParent);
    }

    public GroupModel getGroupById(String id) {
        return this.session.groups().getGroupById((RealmModel)this, id);
    }

    public Stream<GroupModel> getGroupsStream() {
        return this.session.groups().getGroupsStream((RealmModel)this);
    }

    public Long getGroupsCount(Boolean onlyTopGroups) {
        return this.session.groups().getGroupsCount((RealmModel)this, onlyTopGroups);
    }

    public Long getGroupsCountByNameContaining(String search) {
        return this.session.groups().getGroupsCountByNameContaining((RealmModel)this, search);
    }

    public Stream<GroupModel> getTopLevelGroupsStream() {
        return this.session.groups().getTopLevelGroupsStream((RealmModel)this);
    }

    public Stream<GroupModel> getTopLevelGroupsStream(Integer first, Integer max) {
        return this.session.groups().getTopLevelGroupsStream((RealmModel)this, first, max);
    }

    public Stream<GroupModel> searchForGroupByNameStream(String search, Integer first, Integer max) {
        return this.session.groups().searchForGroupByNameStream((RealmModel)this, search, first, max);
    }

    public boolean removeGroup(GroupModel group) {
        return this.session.groups().removeGroup((RealmModel)this, group);
    }

    public void moveGroup(GroupModel group, GroupModel toParent) {
        this.session.groups().moveGroup((RealmModel)this, group, toParent);
    }

    public Stream<ClientScopeModel> getClientScopesStream() {
        return this.session.clientScopes().getClientScopesStream((RealmModel)this);
    }

    public ClientScopeModel addClientScope(String name) {
        return this.session.clientScopes().addClientScope((RealmModel)this, name);
    }

    public ClientScopeModel addClientScope(String id, String name) {
        return this.session.clientScopes().addClientScope((RealmModel)this, id, name);
    }

    public boolean removeClientScope(String id) {
        return this.session.clientScopes().removeClientScope((RealmModel)this, id);
    }

    public ClientScopeModel getClientScopeById(String id) {
        return this.session.clientScopes().getClientScopeById((RealmModel)this, id);
    }

    public void addDefaultClientScope(ClientScopeModel clientScope, boolean defaultScope) {
        if (defaultScope) {
            ((MapRealmEntity)this.entity).addDefaultClientScopeId(clientScope.getId());
        } else {
            ((MapRealmEntity)this.entity).addOptionalClientScopeId(clientScope.getId());
        }
    }

    public void removeDefaultClientScope(ClientScopeModel clientScope) {
        Boolean removedDefault = ((MapRealmEntity)this.entity).removeDefaultClientScopeId(clientScope.getId());
        if (removedDefault == null || !removedDefault.booleanValue()) {
            ((MapRealmEntity)this.entity).removeOptionalClientScopeId(clientScope.getId());
        }
    }

    public Stream<ClientScopeModel> getDefaultClientScopesStream(boolean defaultScope) {
        Set<String> csIds = defaultScope ? ((MapRealmEntity)this.entity).getDefaultClientScopeIds() : ((MapRealmEntity)this.entity).getOptionalClientScopeIds();
        return csIds == null ? Stream.empty() : csIds.stream().map(this::getClientScopeById);
    }

    public void createOrUpdateRealmLocalizationTexts(String locale, Map<String, String> localizationTexts) {
        Map<String, Map<String, String>> realmLocalizationTexts = ((MapRealmEntity)this.entity).getLocalizationTexts();
        if (realmLocalizationTexts != null && realmLocalizationTexts.containsKey(locale)) {
            HashMap<String, String> currentTexts = new HashMap<String, String>(realmLocalizationTexts.get(locale));
            currentTexts.putAll(localizationTexts);
            ((MapRealmEntity)this.entity).setLocalizationText(locale, currentTexts);
        } else {
            ((MapRealmEntity)this.entity).setLocalizationText(locale, localizationTexts);
        }
    }

    public boolean removeRealmLocalizationTexts(String locale) {
        if (locale == null) {
            return false;
        }
        return ((MapRealmEntity)this.entity).removeLocalizationText(locale);
    }

    public Map<String, Map<String, String>> getRealmLocalizationTexts() {
        Map<String, Map<String, String>> localizationTexts = ((MapRealmEntity)this.entity).getLocalizationTexts();
        return localizationTexts == null ? Collections.emptyMap() : localizationTexts;
    }

    public Map<String, String> getRealmLocalizationTextsByLocale(String locale) {
        Map<String, String> lT = ((MapRealmEntity)this.entity).getLocalizationText(locale);
        return lT == null ? Collections.emptyMap() : lT;
    }

    public RoleModel getRole(String name) {
        return this.session.roles().getRealmRole((RealmModel)this, name);
    }

    public RoleModel addRole(String name) {
        return this.session.roles().addRealmRole((RealmModel)this, name);
    }

    public RoleModel addRole(String id, String name) {
        return this.session.roles().addRealmRole((RealmModel)this, id, name);
    }

    public boolean removeRole(RoleModel role) {
        return this.session.roles().removeRole(role);
    }

    public Stream<RoleModel> getRolesStream() {
        return this.session.roles().getRealmRolesStream((RealmModel)this);
    }

    public Stream<RoleModel> getRolesStream(Integer firstResult, Integer maxResults) {
        return this.session.roles().getRealmRolesStream((RealmModel)this, firstResult, maxResults);
    }

    public Stream<RoleModel> searchForRolesStream(String search, Integer first, Integer max) {
        return this.session.roles().searchForRolesStream((RealmModel)this, search, first, max);
    }

    @Deprecated
    public Stream<String> getDefaultRolesStream() {
        return this.getDefaultRole().getCompositesStream().filter(this::isRealmRole).map(RoleModel::getName);
    }

    private boolean isRealmRole(RoleModel role) {
        return !role.isClientRole();
    }

    @Deprecated
    public void addDefaultRole(String name) {
        this.getDefaultRole().addCompositeRole(this.getOrAddRoleId(name));
    }

    private RoleModel getOrAddRoleId(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        return role;
    }

    @Deprecated
    public void removeDefaultRoles(String ... defaultRoles) {
        for (String defaultRole : defaultRoles) {
            this.getDefaultRole().removeCompositeRole(this.getRole(defaultRole));
        }
    }

    public boolean isBruteForceProtected() {
        return this.getAttribute(BRUTE_FORCE_PROTECTED, false);
    }

    public void setBruteForceProtected(boolean value) {
        this.setAttribute(BRUTE_FORCE_PROTECTED, value);
    }

    public boolean isPermanentLockout() {
        return this.getAttribute(PERMANENT_LOCKOUT, false);
    }

    public void setPermanentLockout(boolean val) {
        this.setAttribute(PERMANENT_LOCKOUT, val);
    }

    public int getMaxFailureWaitSeconds() {
        return this.getAttribute(MAX_FAILURE_WAIT_SECONDS, 0);
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.setAttribute(MAX_FAILURE_WAIT_SECONDS, val);
    }

    public int getWaitIncrementSeconds() {
        return this.getAttribute(WAIT_INCREMENT_SECONDS, 0);
    }

    public void setWaitIncrementSeconds(int val) {
        this.setAttribute(WAIT_INCREMENT_SECONDS, val);
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.getAttribute(MINIMUM_QUICK_LOGIN_WAIT_SECONDS, 0);
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.setAttribute(MINIMUM_QUICK_LOGIN_WAIT_SECONDS, val);
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.getAttribute(QUICK_LOGIN_CHECK_MILLISECONDS, 0L);
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.setAttribute(QUICK_LOGIN_CHECK_MILLISECONDS, val);
    }

    public int getMaxDeltaTimeSeconds() {
        return this.getAttribute(MAX_DELTA_SECONDS, 0);
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.setAttribute(MAX_DELTA_SECONDS, val);
    }

    public int getFailureFactor() {
        return this.getAttribute(FAILURE_FACTOR, 0);
    }

    public void setFailureFactor(int failureFactor) {
        this.setAttribute(FAILURE_FACTOR, failureFactor);
    }

    public String getDefaultSignatureAlgorithm() {
        return this.getAttribute(DEFAULT_SIGNATURE_ALGORITHM);
    }

    public void setDefaultSignatureAlgorithm(String defaultSignatureAlgorithm) {
        this.setAttribute(DEFAULT_SIGNATURE_ALGORITHM, defaultSignatureAlgorithm);
    }

    public boolean isOfflineSessionMaxLifespanEnabled() {
        Boolean is = ((MapRealmEntity)this.entity).isOfflineSessionMaxLifespanEnabled();
        return is == null ? false : is;
    }

    public void setOfflineSessionMaxLifespanEnabled(boolean offlineSessionMaxLifespanEnabled) {
        ((MapRealmEntity)this.entity).setOfflineSessionMaxLifespanEnabled(offlineSessionMaxLifespanEnabled);
    }

    public int getOfflineSessionMaxLifespan() {
        Integer i = ((MapRealmEntity)this.entity).getOfflineSessionMaxLifespan();
        return i == null ? 0 : i;
    }

    public void setOfflineSessionMaxLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setOfflineSessionMaxLifespan(seconds);
    }

    public WebAuthnPolicy getWebAuthnPolicy() {
        MapWebAuthnPolicyEntity policy = ((MapRealmEntity)this.entity).getWebAuthnPolicy();
        if (policy == null) {
            policy = MapWebAuthnPolicyEntity.defaultWebAuthnPolicy();
        }
        return MapWebAuthnPolicyEntity.toModel(policy);
    }

    public void setWebAuthnPolicy(WebAuthnPolicy policy) {
        ((MapRealmEntity)this.entity).setWebAuthnPolicy(MapWebAuthnPolicyEntity.fromModel(policy));
    }

    public WebAuthnPolicy getWebAuthnPolicyPasswordless() {
        MapWebAuthnPolicyEntity policy = ((MapRealmEntity)this.entity).getWebAuthnPolicyPasswordless();
        if (policy == null) {
            policy = MapWebAuthnPolicyEntity.defaultWebAuthnPolicy();
        }
        return MapWebAuthnPolicyEntity.toModel(policy);
    }

    public void setWebAuthnPolicyPasswordless(WebAuthnPolicy policy) {
        ((MapRealmEntity)this.entity).setWebAuthnPolicyPasswordless(MapWebAuthnPolicyEntity.fromModel(policy));
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        Map<String, String> bSH = ((MapRealmEntity)this.entity).getBrowserSecurityHeaders();
        return bSH == null ? Collections.emptyMap() : Collections.unmodifiableMap(bSH);
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        ((MapRealmEntity)this.entity).setBrowserSecurityHeaders(headers);
    }

    public ClientInitialAccessModel createClientInitialAccessModel(int expiration, int count) {
        MapClientInitialAccessEntity clientInitialAccess = MapClientInitialAccessEntity.createEntity(expiration, count);
        ((MapRealmEntity)this.entity).addClientInitialAccess(clientInitialAccess);
        return MapClientInitialAccessEntity.toModel(clientInitialAccess);
    }

    public ClientInitialAccessModel getClientInitialAccessModel(String id) {
        return ((MapRealmEntity)this.entity).getClientInitialAccess(id).map(MapClientInitialAccessEntity::toModel).orElse(null);
    }

    public void removeClientInitialAccessModel(String id) {
        ((MapRealmEntity)this.entity).removeClientInitialAccess(id);
    }

    public Stream<ClientInitialAccessModel> getClientInitialAccesses() {
        Set<MapClientInitialAccessEntity> cias = ((MapRealmEntity)this.entity).getClientInitialAccesses();
        return cias == null ? Stream.empty() : cias.stream().map(MapClientInitialAccessEntity::toModel);
    }

    public void decreaseRemainingCount(ClientInitialAccessModel model) {
        ((MapRealmEntity)this.entity).getClientInitialAccess(model.getId()).ifPresent(cia -> cia.setRemainingCount(model.getRemainingCount() - 1));
    }

    public OAuth2DeviceConfig getOAuth2DeviceConfig() {
        return new OAuth2DeviceConfig((RealmModel)this);
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), this.hashCode());
    }

    public CibaConfig getCibaPolicy() {
        return new CibaConfig((RealmModel)this);
    }

    public ParConfig getParPolicy() {
        return new ParConfig((RealmModel)this);
    }
}

