/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.security.MessageDigest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.client.AbstractClientModel;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.client.MapProtocolMapperUtils;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;

public abstract class MapClientAdapter
extends AbstractClientModel<MapClientEntity>
implements ClientModel {
    private static final Logger LOG = Logger.getLogger(MapClientAdapter.class);
    private final MapProtocolMapperUtils pmUtils = MapProtocolMapperUtils.instanceFor(this.safeGetProtocol());

    public MapClientAdapter(KeycloakSession session, RealmModel realm, MapClientEntity entity) {
        super(session, realm, entity);
    }

    public String getId() {
        return ((MapClientEntity)this.entity).getId();
    }

    public String getClientId() {
        return ((MapClientEntity)this.entity).getClientId();
    }

    public void setClientId(String clientId) {
        ((MapClientEntity)this.entity).setClientId(clientId);
    }

    public String getName() {
        return ((MapClientEntity)this.entity).getName();
    }

    public void setName(String name) {
        ((MapClientEntity)this.entity).setName(name);
    }

    public String getDescription() {
        return ((MapClientEntity)this.entity).getDescription();
    }

    public void setDescription(String description) {
        ((MapClientEntity)this.entity).setDescription(description);
    }

    public boolean isEnabled() {
        Boolean enabled = ((MapClientEntity)this.entity).isEnabled();
        return enabled == null ? false : enabled;
    }

    public void setEnabled(boolean enabled) {
        ((MapClientEntity)this.entity).setEnabled(enabled);
    }

    public boolean isAlwaysDisplayInConsole() {
        Boolean alwaysDisplayInConsole = ((MapClientEntity)this.entity).isAlwaysDisplayInConsole();
        return alwaysDisplayInConsole == null ? false : alwaysDisplayInConsole;
    }

    public void setAlwaysDisplayInConsole(boolean alwaysDisplayInConsole) {
        ((MapClientEntity)this.entity).setAlwaysDisplayInConsole(alwaysDisplayInConsole);
    }

    public boolean isSurrogateAuthRequired() {
        Boolean surrogateAuthRequired = ((MapClientEntity)this.entity).isSurrogateAuthRequired();
        return surrogateAuthRequired == null ? false : surrogateAuthRequired;
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        ((MapClientEntity)this.entity).setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public Set<String> getWebOrigins() {
        Set<String> webOrigins = ((MapClientEntity)this.entity).getWebOrigins();
        return webOrigins == null ? Collections.emptySet() : webOrigins;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        ((MapClientEntity)this.entity).setWebOrigins(webOrigins);
    }

    public void addWebOrigin(String webOrigin) {
        ((MapClientEntity)this.entity).addWebOrigin(webOrigin);
    }

    public void removeWebOrigin(String webOrigin) {
        ((MapClientEntity)this.entity).removeWebOrigin(webOrigin);
    }

    public Set<String> getRedirectUris() {
        Set<String> redirectUris = ((MapClientEntity)this.entity).getRedirectUris();
        return redirectUris == null ? Collections.emptySet() : redirectUris;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        ((MapClientEntity)this.entity).setRedirectUris(redirectUris);
    }

    public void addRedirectUri(String redirectUri) {
        ((MapClientEntity)this.entity).addRedirectUri(redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        ((MapClientEntity)this.entity).removeRedirectUri(redirectUri);
    }

    public String getManagementUrl() {
        return ((MapClientEntity)this.entity).getManagementUrl();
    }

    public void setManagementUrl(String url) {
        ((MapClientEntity)this.entity).setManagementUrl(url);
    }

    public String getRootUrl() {
        return ((MapClientEntity)this.entity).getRootUrl();
    }

    public void setRootUrl(String url) {
        ((MapClientEntity)this.entity).setRootUrl(url);
    }

    public String getBaseUrl() {
        return ((MapClientEntity)this.entity).getBaseUrl();
    }

    public void setBaseUrl(String url) {
        ((MapClientEntity)this.entity).setBaseUrl(url);
    }

    public boolean isBearerOnly() {
        Boolean bearerOnly = ((MapClientEntity)this.entity).isBearerOnly();
        return bearerOnly == null ? false : bearerOnly;
    }

    public void setBearerOnly(boolean only) {
        ((MapClientEntity)this.entity).setBearerOnly(only);
    }

    public String getClientAuthenticatorType() {
        return ((MapClientEntity)this.entity).getClientAuthenticatorType();
    }

    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        ((MapClientEntity)this.entity).setClientAuthenticatorType(clientAuthenticatorType);
    }

    public boolean validateSecret(String secret) {
        return MessageDigest.isEqual(secret.getBytes(), ((MapClientEntity)this.entity).getSecret().getBytes());
    }

    public String getSecret() {
        return ((MapClientEntity)this.entity).getSecret();
    }

    public void setSecret(String secret) {
        ((MapClientEntity)this.entity).setSecret(secret);
    }

    public int getNodeReRegistrationTimeout() {
        Integer nodeReRegistrationTimeout = ((MapClientEntity)this.entity).getNodeReRegistrationTimeout();
        return nodeReRegistrationTimeout == null ? 0 : nodeReRegistrationTimeout;
    }

    public void setNodeReRegistrationTimeout(int timeout) {
        ((MapClientEntity)this.entity).setNodeReRegistrationTimeout(timeout);
    }

    public String getRegistrationToken() {
        return ((MapClientEntity)this.entity).getRegistrationToken();
    }

    public void setRegistrationToken(String registrationToken) {
        ((MapClientEntity)this.entity).setRegistrationToken(registrationToken);
    }

    public String getProtocol() {
        return ((MapClientEntity)this.entity).getProtocol();
    }

    public void setProtocol(String protocol) {
        if (!Objects.equals(((MapClientEntity)this.entity).getProtocol(), protocol)) {
            ((MapClientEntity)this.entity).setProtocol(protocol);
            this.session.getKeycloakSessionFactory().publish((ProviderEvent)((ClientModel.ClientProtocolUpdatedEvent)() -> this));
        }
    }

    public void setAttribute(String name, String value) {
        boolean valueUndefined;
        boolean bl = valueUndefined = value == null || "".equals(value.trim());
        if (valueUndefined) {
            this.removeAttribute(name);
            return;
        }
        ((MapClientEntity)this.entity).setAttribute(name, Collections.singletonList(value));
    }

    public void removeAttribute(String name) {
        ((MapClientEntity)this.entity).removeAttribute(name);
    }

    public String getAttribute(String name) {
        List<String> attribute = ((MapClientEntity)this.entity).getAttribute(name);
        if (attribute == null || attribute.isEmpty()) {
            return null;
        }
        return attribute.get(0);
    }

    public Map<String, String> getAttributes() {
        Map<String, List<String>> attributes = ((MapClientEntity)this.entity).getAttributes();
        Map<Object, Object> a = attributes == null ? Collections.emptyMap() : attributes;
        return a.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            if (((List)entry.getValue()).isEmpty()) {
                return null;
            }
            if (((List)entry.getValue()).size() > 1) {
                LOG.warnf("Client '%s' realm '%s' has attribute '%s' with %d values, retrieving only the first", new Object[]{this.getClientId(), this.getRealm().getName(), entry.getKey(), ((List)entry.getValue()).size()});
            }
            return (String)((List)entry.getValue()).get(0);
        }));
    }

    public String getAuthenticationFlowBindingOverride(String binding) {
        return ((MapClientEntity)this.entity).getAuthenticationFlowBindingOverride(binding);
    }

    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        Map<String, String> authenticationFlowBindingOverrides = ((MapClientEntity)this.entity).getAuthenticationFlowBindingOverrides();
        return authenticationFlowBindingOverrides == null ? Collections.emptyMap() : authenticationFlowBindingOverrides;
    }

    public void removeAuthenticationFlowBindingOverride(String binding) {
        ((MapClientEntity)this.entity).removeAuthenticationFlowBindingOverride(binding);
    }

    public void setAuthenticationFlowBindingOverride(String binding, String flowId) {
        ((MapClientEntity)this.entity).setAuthenticationFlowBindingOverride(binding, flowId);
    }

    public boolean isFrontchannelLogout() {
        Boolean frontchannelLogout = ((MapClientEntity)this.entity).isFrontchannelLogout();
        return frontchannelLogout == null ? false : frontchannelLogout;
    }

    public void setFrontchannelLogout(boolean flag) {
        ((MapClientEntity)this.entity).setFrontchannelLogout(flag);
    }

    public boolean isFullScopeAllowed() {
        Boolean fullScopeAllowed = ((MapClientEntity)this.entity).isFullScopeAllowed();
        return fullScopeAllowed == null ? false : fullScopeAllowed;
    }

    public void setFullScopeAllowed(boolean value) {
        ((MapClientEntity)this.entity).setFullScopeAllowed(value);
    }

    public boolean isPublicClient() {
        Boolean publicClient = ((MapClientEntity)this.entity).isPublicClient();
        return publicClient == null ? false : publicClient;
    }

    public void setPublicClient(boolean flag) {
        ((MapClientEntity)this.entity).setPublicClient(flag);
    }

    public boolean isConsentRequired() {
        Boolean consentRequired = ((MapClientEntity)this.entity).isConsentRequired();
        return consentRequired == null ? false : consentRequired;
    }

    public void setConsentRequired(boolean consentRequired) {
        ((MapClientEntity)this.entity).setConsentRequired(consentRequired);
    }

    public boolean isStandardFlowEnabled() {
        Boolean standardFlowEnabled = ((MapClientEntity)this.entity).isStandardFlowEnabled();
        return standardFlowEnabled == null ? false : standardFlowEnabled;
    }

    public void setStandardFlowEnabled(boolean standardFlowEnabled) {
        ((MapClientEntity)this.entity).setStandardFlowEnabled(standardFlowEnabled);
    }

    public boolean isImplicitFlowEnabled() {
        Boolean implicitFlowEnabled = ((MapClientEntity)this.entity).isImplicitFlowEnabled();
        return implicitFlowEnabled == null ? false : implicitFlowEnabled;
    }

    public void setImplicitFlowEnabled(boolean implicitFlowEnabled) {
        ((MapClientEntity)this.entity).setImplicitFlowEnabled(implicitFlowEnabled);
    }

    public boolean isDirectAccessGrantsEnabled() {
        Boolean directAccessGrantsEnabled = ((MapClientEntity)this.entity).isDirectAccessGrantsEnabled();
        return directAccessGrantsEnabled == null ? false : directAccessGrantsEnabled;
    }

    public void setDirectAccessGrantsEnabled(boolean directAccessGrantsEnabled) {
        ((MapClientEntity)this.entity).setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
    }

    public boolean isServiceAccountsEnabled() {
        Boolean serviceAccountsEnabled = ((MapClientEntity)this.entity).isServiceAccountsEnabled();
        return serviceAccountsEnabled == null ? false : serviceAccountsEnabled;
    }

    public void setServiceAccountsEnabled(boolean serviceAccountsEnabled) {
        ((MapClientEntity)this.entity).setServiceAccountsEnabled(serviceAccountsEnabled);
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getNotBefore() {
        Long notBefore = ((MapClientEntity)this.entity).getNotBefore();
        return notBefore == null ? 0 : TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(notBefore);
    }

    public void setNotBefore(int notBefore) {
        ((MapClientEntity)this.entity).setNotBefore(TimeAdapter.fromIntegerWithTimeInSecondsToLongWithTimeAsInSeconds(notBefore));
    }

    public Stream<RoleModel> getScopeMappingsStream() {
        Collection<String> scopeMappings = ((MapClientEntity)this.entity).getScopeMappings();
        return scopeMappings == null ? Stream.empty() : scopeMappings.stream().map(arg_0 -> ((RealmModel)this.realm).getRoleById(arg_0)).filter(Objects::nonNull);
    }

    public void addScopeMapping(RoleModel role) {
        String id;
        String string = id = role == null ? null : role.getId();
        if (id != null) {
            ((MapClientEntity)this.entity).addScopeMapping(id);
        }
    }

    public void deleteScopeMapping(RoleModel role) {
        String id;
        String string = id = role == null ? null : role.getId();
        if (id != null) {
            ((MapClientEntity)this.entity).removeScopeMapping(id);
        }
    }

    public boolean hasDirectScope(RoleModel role) {
        String id;
        String string = id = role == null ? null : role.getId();
        if (id != null && ((MapClientEntity)this.entity).getScopeMappings().contains(id)) {
            return true;
        }
        return this.getRolesStream().anyMatch(r -> Objects.equals(r, role));
    }

    public boolean hasScope(RoleModel role) {
        if (this.isFullScopeAllowed()) {
            return true;
        }
        String id = role == null ? null : role.getId();
        Collection<String> scopeMappings = ((MapClientEntity)this.entity).getScopeMappings();
        if (id != null && scopeMappings != null && scopeMappings.contains(id)) {
            return true;
        }
        if (this.getScopeMappingsStream().anyMatch(r -> r.hasRole(role))) {
            return true;
        }
        return this.getRolesStream().anyMatch(r -> Objects.equals(r, role) || r.hasRole(role));
    }

    @Deprecated
    public Stream<String> getDefaultRolesStream() {
        return this.realm.getDefaultRole().getCompositesStream().filter(this::isClientRole).map(RoleModel::getName);
    }

    private boolean isClientRole(RoleModel role) {
        return role.isClientRole() && Objects.equals(role.getContainerId(), this.getId());
    }

    @Deprecated
    public void addDefaultRole(String name) {
        this.realm.getDefaultRole().addCompositeRole(this.getOrAddRoleId(name));
    }

    private RoleModel getOrAddRoleId(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        return role;
    }

    @Deprecated
    public void removeDefaultRoles(String ... defaultRoles) {
        for (String defaultRole : defaultRoles) {
            this.realm.getDefaultRole().removeCompositeRole(this.getRole(defaultRole));
        }
    }

    private String safeGetProtocol() {
        return ((MapClientEntity)this.entity).getProtocol() == null ? "openid-connect" : ((MapClientEntity)this.entity).getProtocol();
    }

    public Stream<ProtocolMapperModel> getProtocolMappersStream() {
        Map<String, MapProtocolMapperEntity> protocolMappers = ((MapClientEntity)this.entity).getProtocolMappers();
        return protocolMappers == null ? Stream.empty() : protocolMappers.values().stream().distinct().map(this.pmUtils::toModel);
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (model == null) {
            return null;
        }
        MapProtocolMapperEntity pm = MapProtocolMapperUtils.fromModel(model);
        if (pm.getId() == null) {
            String id = KeycloakModelUtils.generateId();
            pm.setId(id);
        }
        if (model.getConfig() == null) {
            pm.setConfig(new HashMap<String, String>());
        }
        ((MapClientEntity)this.entity).setProtocolMapper(pm.getId(), pm);
        return this.pmUtils.toModel(pm);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        String id;
        String string = id = mapping == null ? null : mapping.getId();
        if (id != null) {
            ((MapClientEntity)this.entity).removeProtocolMapper(id);
        }
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        String id;
        String string = id = mapping == null ? null : mapping.getId();
        if (id != null) {
            ((MapClientEntity)this.entity).setProtocolMapper(id, MapProtocolMapperUtils.fromModel(mapping));
        }
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        MapProtocolMapperEntity protocolMapper = ((MapClientEntity)this.entity).getProtocolMapper(id);
        return protocolMapper == null ? null : this.pmUtils.toModel(protocolMapper);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        Map<String, MapProtocolMapperEntity> protocolMappers = ((MapClientEntity)this.entity).getProtocolMappers();
        if (!Objects.equals(protocol, this.safeGetProtocol())) {
            return null;
        }
        return protocolMappers == null ? null : (ProtocolMapperModel)protocolMappers.values().stream().filter(pm -> Objects.equals(pm.getName(), name)).map(this.pmUtils::toModel).findAny().orElse(null);
    }

    public String toString() {
        return String.format("%s@%08x", this.getClientId(), System.identityHashCode(this));
    }
}

