/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapCrudOperations;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapKeycloakTransaction;
import org.keycloak.models.map.storage.chm.MapFieldPredicates;
import org.keycloak.models.map.storage.chm.MapModelCriteriaBuilder;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.StreamsUtil;

public class ConcurrentHashMapStorage<K, V extends AbstractEntity & UpdatableEntity, M>
implements MapStorage<V, M>,
ConcurrentHashMapCrudOperations<V, M> {
    protected final ConcurrentMap<K, V> store = new ConcurrentHashMap();
    protected final Map<SearchableModelField<? super M>, MapModelCriteriaBuilder.UpdatePredicatesFunc<K, V, M>> fieldPredicates;
    protected final StringKeyConverter<K> keyConverter;
    protected final DeepCloner cloner;

    public ConcurrentHashMapStorage(Class<M> modelClass, StringKeyConverter<K> keyConverter, DeepCloner cloner) {
        this.fieldPredicates = MapFieldPredicates.getPredicates(modelClass);
        this.keyConverter = keyConverter;
        this.cloner = cloner;
    }

    @Override
    public V create(V value) {
        K key = this.keyConverter.fromStringSafe(value.getId());
        if (key == null) {
            key = this.keyConverter.yieldNewUniqueKey();
            value = this.cloner.from(this.keyConverter.keyToString(key), value);
        }
        this.store.putIfAbsent(key, value);
        return value;
    }

    @Override
    public V read(String key) {
        Objects.requireNonNull(key, "Key must be non-null");
        K k = this.keyConverter.fromStringSafe(key);
        return (V)((AbstractEntity)this.store.get(k));
    }

    @Override
    public V update(V value) {
        K key = this.getKeyConverter().fromStringSafe(value.getId());
        return (V)((AbstractEntity)this.store.replace(key, value));
    }

    @Override
    public boolean delete(String key) {
        K k = this.getKeyConverter().fromStringSafe(key);
        return this.store.remove(k) != null;
    }

    @Override
    public long delete(QueryParameters<M> queryParameters) {
        DefaultModelCriteria<M> criteria = queryParameters.getModelCriteriaBuilder();
        if (criteria == null) {
            long res = this.store.size();
            this.store.clear();
            return res;
        }
        MapModelCriteriaBuilder<K, V, M> mcb = criteria.flashToModelCriteriaBuilder(this.createCriteriaBuilder());
        Predicate keyFilter = mcb.getKeyFilter();
        Predicate entityFilter = mcb.getEntityFilter();
        Stream storeStream = this.store.entrySet().stream();
        AtomicLong res = new AtomicLong(0L);
        if (!queryParameters.getOrderBy().isEmpty()) {
            Comparator comparator = MapFieldPredicates.getComparator(queryParameters.getOrderBy().stream());
            storeStream = storeStream.sorted((entry1, entry2) -> comparator.compare((AbstractEntity)entry1.getValue(), (AbstractEntity)entry2.getValue()));
        }
        StreamsUtil.paginatedStream(storeStream.filter(next -> keyFilter.test(next.getKey()) && entityFilter.test(next.getValue())), (Integer)queryParameters.getOffset(), (Integer)queryParameters.getLimit()).peek(item -> res.incrementAndGet()).map(Map.Entry::getKey).forEach(this.store::remove);
        return res.get();
    }

    @Override
    public MapKeycloakTransaction<V, M> createTransaction(KeycloakSession session) {
        MapKeycloakTransaction sessionTransaction = (MapKeycloakTransaction)session.getAttribute("map-transaction-" + this.hashCode(), MapKeycloakTransaction.class);
        return sessionTransaction == null ? new ConcurrentHashMapKeycloakTransaction<K, V, M>(this, this.keyConverter, this.cloner, this.fieldPredicates) : sessionTransaction;
    }

    public MapModelCriteriaBuilder<K, V, M> createCriteriaBuilder() {
        return new MapModelCriteriaBuilder<K, V, M>(this.keyConverter, this.fieldPredicates);
    }

    public StringKeyConverter<K> getKeyConverter() {
        return this.keyConverter;
    }

    @Override
    public Stream<V> read(QueryParameters<M> queryParameters) {
        DefaultModelCriteria<M> criteria = queryParameters.getModelCriteriaBuilder();
        if (criteria == null) {
            return Stream.empty();
        }
        MapModelCriteriaBuilder<K, V, M> mcb = criteria.flashToModelCriteriaBuilder(this.createCriteriaBuilder());
        Stream stream = this.store.entrySet().stream();
        Predicate keyFilter = mcb.getKeyFilter();
        Predicate entityFilter = mcb.getEntityFilter();
        Stream<AbstractEntity> valueStream = stream.filter(me -> keyFilter.test(me.getKey()) && entityFilter.test(me.getValue())).map(Map.Entry::getValue);
        if (!queryParameters.getOrderBy().isEmpty()) {
            valueStream = valueStream.sorted(MapFieldPredicates.getComparator(queryParameters.getOrderBy().stream()));
        }
        return StreamsUtil.paginatedStream(valueStream, (Integer)queryParameters.getOffset(), (Integer)queryParameters.getLimit());
    }

    @Override
    public long getCount(QueryParameters<M> queryParameters) {
        return this.read(queryParameters).count();
    }
}

