/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.chm.CriteriaOperator;
import org.keycloak.storage.SearchableModelField;

public class MapModelCriteriaBuilder<K, V extends AbstractEntity, M>
implements ModelCriteriaBuilder<M, MapModelCriteriaBuilder<K, V, M>> {
    protected static final Predicate<Object> ALWAYS_TRUE = e -> true;
    protected static final Predicate<Object> ALWAYS_FALSE = e -> false;
    private final Predicate<? super K> keyFilter;
    private final Predicate<? super V> entityFilter;
    private final Map<SearchableModelField<? super M>, UpdatePredicatesFunc<K, V, M>> fieldPredicates;
    private final StringKeyConverter<K> keyConverter;

    public MapModelCriteriaBuilder(StringKeyConverter<K> keyConverter, Map<SearchableModelField<? super M>, UpdatePredicatesFunc<K, V, M>> fieldPredicates) {
        this(keyConverter, fieldPredicates, ALWAYS_TRUE, ALWAYS_TRUE);
    }

    protected MapModelCriteriaBuilder(StringKeyConverter<K> keyConverter, Map<SearchableModelField<? super M>, UpdatePredicatesFunc<K, V, M>> fieldPredicates, Predicate<? super K> indexReadFilter, Predicate<? super V> sequentialReadFilter) {
        this.keyConverter = keyConverter;
        this.fieldPredicates = fieldPredicates;
        this.keyFilter = indexReadFilter;
        this.entityFilter = sequentialReadFilter;
    }

    @Override
    public MapModelCriteriaBuilder<K, V, M> compare(SearchableModelField<? super M> modelField, ModelCriteriaBuilder.Operator op, Object ... values) {
        UpdatePredicatesFunc<K, V, M> method = this.fieldPredicates.get(modelField);
        if (method == null) {
            throw new IllegalArgumentException("Filter not implemented for field " + modelField);
        }
        return method.apply(this, op, values);
    }

    @SafeVarargs
    public final MapModelCriteriaBuilder<K, V, M> and(MapModelCriteriaBuilder<K, V, M> ... builders) {
        Predicate resIndexFilter = Stream.of(builders).map(MapModelCriteriaBuilder.class::cast).map(MapModelCriteriaBuilder::getKeyFilter).reduce(this.keyFilter, Predicate::and);
        Predicate resEntityFilter = Stream.of(builders).map(MapModelCriteriaBuilder.class::cast).map(MapModelCriteriaBuilder::getEntityFilter).reduce(this.entityFilter, Predicate::and);
        return this.instantiateNewInstance(this.keyConverter, this.fieldPredicates, resIndexFilter, resEntityFilter);
    }

    @SafeVarargs
    public final MapModelCriteriaBuilder<K, V, M> or(MapModelCriteriaBuilder<K, V, M> ... builders) {
        Predicate resIndexFilter = Stream.of(builders).map(MapModelCriteriaBuilder.class::cast).map(MapModelCriteriaBuilder::getKeyFilter).reduce(ALWAYS_FALSE, Predicate::or);
        Predicate resEntityFilter = Stream.of(builders).map(MapModelCriteriaBuilder.class::cast).map(MapModelCriteriaBuilder::getEntityFilter).reduce(ALWAYS_FALSE, Predicate::or);
        return this.instantiateNewInstance(this.keyConverter, this.fieldPredicates, v -> this.keyFilter.test(v) && resIndexFilter.test(v), v -> this.entityFilter.test(v) && resEntityFilter.test(v));
    }

    @Override
    public MapModelCriteriaBuilder<K, V, M> not(MapModelCriteriaBuilder<K, V, M> builder) {
        Predicate<Object> resIndexFilter = builder.getKeyFilter() == ALWAYS_TRUE ? ALWAYS_TRUE : builder.getKeyFilter().negate();
        Predicate<Object> resEntityFilter = builder.getEntityFilter() == ALWAYS_TRUE ? ALWAYS_TRUE : builder.getEntityFilter().negate();
        return this.instantiateNewInstance(this.keyConverter, this.fieldPredicates, v -> this.keyFilter.test(v) && resIndexFilter.test(v), v -> this.entityFilter.test(v) && resEntityFilter.test(v));
    }

    public Predicate<? super K> getKeyFilter() {
        return this.keyFilter;
    }

    public Predicate<? super V> getEntityFilter() {
        return this.entityFilter;
    }

    protected MapModelCriteriaBuilder<K, V, M> idCompare(ModelCriteriaBuilder.Operator op, Object[] values) {
        Object[] convertedValues = this.convertValuesToKeyType(values);
        switch (op) {
            case LT: 
            case LE: 
            case GT: 
            case GE: 
            case EQ: 
            case NE: 
            case EXISTS: 
            case NOT_EXISTS: 
            case IN: {
                return this.instantiateNewInstance(this.keyConverter, this.fieldPredicates, this.keyFilter.and(CriteriaOperator.predicateFor(op, convertedValues)), this.entityFilter);
            }
        }
        throw new AssertionError((Object)("Invalid operator: " + (Object)((Object)op)));
    }

    protected Object[] convertValuesToKeyType(Object[] values) {
        if (values == null) {
            return null;
        }
        Object[] res = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            if (v instanceof String) {
                res[i] = this.keyConverter.fromStringSafe((String)v);
                continue;
            }
            if (v instanceof Stream) {
                res[i] = ((Stream)v).map(o -> o instanceof String ? this.keyConverter.fromStringSafe((String)o) : o);
                continue;
            }
            if (v instanceof Collection) {
                res[i] = ((List)v).stream().map(o -> o instanceof String ? this.keyConverter.fromStringSafe((String)o) : o).collect(Collectors.toList());
                continue;
            }
            if (v == null) {
                res[i] = null;
                continue;
            }
            throw new IllegalArgumentException("Unknown type: " + v);
        }
        return res;
    }

    protected MapModelCriteriaBuilder<K, V, M> fieldCompare(ModelCriteriaBuilder.Operator op, Function<V, ?> getter, Object[] values) {
        Predicate<Object> valueComparator = CriteriaOperator.predicateFor(op, values);
        return this.fieldCompare(valueComparator, getter);
    }

    protected MapModelCriteriaBuilder<K, V, M> fieldCompare(Predicate<Object> valueComparator, Function<V, ?> getter) {
        Predicate<Object> resEntityFilter;
        if (this.entityFilter == ALWAYS_FALSE) {
            resEntityFilter = ALWAYS_FALSE;
        } else {
            Predicate<AbstractEntity> p = v -> valueComparator.test(getter.apply(v));
            resEntityFilter = p.and(this.entityFilter);
        }
        return this.instantiateNewInstance(this.keyConverter, this.fieldPredicates, this.keyFilter, resEntityFilter);
    }

    protected MapModelCriteriaBuilder<K, V, M> instantiateNewInstance(StringKeyConverter<K> keyConverter, Map<SearchableModelField<? super M>, UpdatePredicatesFunc<K, V, M>> fieldPredicates, Predicate<? super K> indexReadFilter, Predicate<? super V> sequentialReadFilter) {
        return new MapModelCriteriaBuilder<K, V, M>(keyConverter, fieldPredicates, indexReadFilter, sequentialReadFilter);
    }

    @FunctionalInterface
    public static interface UpdatePredicatesFunc<K, V extends AbstractEntity, M> {
        public MapModelCriteriaBuilder<K, V, M> apply(MapModelCriteriaBuilder<K, V, M> var1, ModelCriteriaBuilder.Operator var2, Object[] var3);
    }
}

