/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntity;

public class SessionExpiration {
    public static void setClientSessionExpiration(MapAuthenticatedClientSessionEntity entity, RealmModel realm, ClientModel client) {
        long timestamp;
        long l = timestamp = entity.getTimestamp() != null ? entity.getTimestamp() : 0L;
        if (Boolean.TRUE.equals(entity.isOffline())) {
            long sessionExpires = timestamp + (long)realm.getOfflineSessionIdleTimeout();
            if (realm.isOfflineSessionMaxLifespanEnabled()) {
                sessionExpires = timestamp + (long)realm.getOfflineSessionMaxLifespan();
                String clientOfflineSessionMaxLifespanPerClient = client.getAttribute("client.offline.session.max.lifespan");
                long clientOfflineSessionMaxLifespan = clientOfflineSessionMaxLifespanPerClient != null && !clientOfflineSessionMaxLifespanPerClient.trim().isEmpty() ? Long.parseLong(clientOfflineSessionMaxLifespanPerClient) : (long)realm.getClientOfflineSessionMaxLifespan();
                if (clientOfflineSessionMaxLifespan > 0L) {
                    long clientOfflineSessionMaxExpiration = timestamp + clientOfflineSessionMaxLifespan;
                    sessionExpires = Math.min(sessionExpires, clientOfflineSessionMaxExpiration);
                }
            }
            long expiration = timestamp + (long)realm.getOfflineSessionIdleTimeout();
            String clientOfflineSessionIdleTimeoutPerClient = client.getAttribute("client.offline.session.idle.timeout");
            long clientOfflineSessionIdleTimeout = clientOfflineSessionIdleTimeoutPerClient != null && !clientOfflineSessionIdleTimeoutPerClient.trim().isEmpty() ? Long.parseLong(clientOfflineSessionIdleTimeoutPerClient) : (long)realm.getClientOfflineSessionIdleTimeout();
            if (clientOfflineSessionIdleTimeout > 0L) {
                long clientOfflineSessionIdleExpiration = timestamp + clientOfflineSessionIdleTimeout;
                expiration = Math.min(expiration, clientOfflineSessionIdleExpiration);
            }
            entity.setExpiration(Math.min(expiration, sessionExpires));
        } else {
            long sessionExpires = timestamp + (long)(realm.getSsoSessionMaxLifespanRememberMe() > 0 ? realm.getSsoSessionMaxLifespanRememberMe() : realm.getSsoSessionMaxLifespan());
            String clientSessionMaxLifespanPerClient = client.getAttribute("client.session.max.lifespan");
            long clientSessionMaxLifespan = clientSessionMaxLifespanPerClient != null && !clientSessionMaxLifespanPerClient.trim().isEmpty() ? Long.parseLong(clientSessionMaxLifespanPerClient) : (long)realm.getClientSessionMaxLifespan();
            if (clientSessionMaxLifespan > 0L) {
                long clientSessionMaxExpiration = timestamp + clientSessionMaxLifespan;
                sessionExpires = Math.min(sessionExpires, clientSessionMaxExpiration);
            }
            long expiration = timestamp + (long)(realm.getSsoSessionIdleTimeoutRememberMe() > 0 ? realm.getSsoSessionIdleTimeoutRememberMe() : realm.getSsoSessionIdleTimeout());
            String clientSessionIdleTimeoutPerClient = client.getAttribute("client.session.idle.timeout");
            long clientSessionIdleTimeout = clientSessionIdleTimeoutPerClient != null && !clientSessionIdleTimeoutPerClient.trim().isEmpty() ? Long.parseLong(clientSessionIdleTimeoutPerClient) : (long)realm.getClientSessionIdleTimeout();
            if (clientSessionIdleTimeout > 0L) {
                long clientSessionIdleExpiration = timestamp + clientSessionIdleTimeout;
                expiration = Math.min(expiration, clientSessionIdleExpiration);
            }
            entity.setExpiration(Math.min(expiration, sessionExpires));
        }
    }

    public static void setUserSessionExpiration(MapUserSessionEntity entity, RealmModel realm) {
        long lastSessionRefresh;
        long started = entity.getStarted() != null ? entity.getStarted() : 0L;
        long l = lastSessionRefresh = entity.getLastSessionRefresh() != null ? entity.getLastSessionRefresh() : 0L;
        if (Boolean.TRUE.equals(entity.isOffline())) {
            long sessionExpires = lastSessionRefresh + (long)realm.getOfflineSessionIdleTimeout();
            if (realm.isOfflineSessionMaxLifespanEnabled()) {
                sessionExpires = started + (long)realm.getOfflineSessionMaxLifespan();
                long clientOfflineSessionMaxLifespan = realm.getClientOfflineSessionMaxLifespan();
                if (clientOfflineSessionMaxLifespan > 0L) {
                    long clientOfflineSessionMaxExpiration = started + clientOfflineSessionMaxLifespan;
                    sessionExpires = Math.min(sessionExpires, clientOfflineSessionMaxExpiration);
                }
            }
            long expiration = lastSessionRefresh + (long)realm.getOfflineSessionIdleTimeout();
            long clientOfflineSessionIdleTimeout = realm.getClientOfflineSessionIdleTimeout();
            if (clientOfflineSessionIdleTimeout > 0L) {
                long clientOfflineSessionIdleExpiration = (long)Time.currentTime() + clientOfflineSessionIdleTimeout;
                expiration = Math.min(expiration, clientOfflineSessionIdleExpiration);
            }
            entity.setExpiration(Math.min(expiration, sessionExpires));
        } else {
            long sessionExpires = started + (long)(Boolean.TRUE.equals(entity.isRememberMe()) && realm.getSsoSessionMaxLifespanRememberMe() > 0 ? realm.getSsoSessionMaxLifespanRememberMe() : realm.getSsoSessionMaxLifespan());
            long clientSessionMaxLifespan = realm.getClientSessionMaxLifespan();
            if (clientSessionMaxLifespan > 0L) {
                long clientSessionMaxExpiration = started + clientSessionMaxLifespan;
                sessionExpires = Math.min(sessionExpires, clientSessionMaxExpiration);
            }
            long expiration = lastSessionRefresh + (long)(Boolean.TRUE.equals(entity.isRememberMe()) && realm.getSsoSessionIdleTimeoutRememberMe() > 0 ? realm.getSsoSessionIdleTimeoutRememberMe() : realm.getSsoSessionIdleTimeout());
            long clientSessionIdleTimeout = realm.getClientSessionIdleTimeout();
            if (clientSessionIdleTimeout > 0L) {
                long clientSessionIdleExpiration = lastSessionRefresh + clientSessionIdleTimeout;
                expiration = Math.min(expiration, clientSessionIdleExpiration);
            }
            entity.setExpiration(Math.min(expiration, sessionExpires));
        }
    }
}

