/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import java.util.Objects;
import java.util.Set;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.user.MapUserConsentEntityImpl;
import org.keycloak.models.utils.KeycloakModelUtils;

@DeepCloner.Root
public interface MapUserConsentEntity
extends UpdatableEntity {
    public static MapUserConsentEntity fromModel(UserConsentModel model) {
        long currentTime = Time.currentTimeMillis();
        MapUserConsentEntityImpl consentEntity = new MapUserConsentEntityImpl();
        consentEntity.setClientId(model.getClient().getId());
        consentEntity.setCreatedDate(currentTime);
        consentEntity.setLastUpdatedDate(currentTime);
        model.getGrantedClientScopes().stream().map(ClientScopeModel::getId).forEach(consentEntity::addGrantedClientScopesId);
        return consentEntity;
    }

    public static UserConsentModel toModel(RealmModel realm, MapUserConsentEntity entity) {
        if (entity == null) {
            return null;
        }
        ClientModel client = realm.getClientById(entity.getClientId());
        if (client == null) {
            throw new ModelException("Client with id " + entity.getClientId() + " is not available");
        }
        UserConsentModel model = new UserConsentModel(client);
        model.setCreatedDate(entity.getCreatedDate());
        model.setLastUpdatedDate(entity.getLastUpdatedDate());
        Set<String> grantedClientScopesIds = entity.getGrantedClientScopesIds();
        if (grantedClientScopesIds != null && !grantedClientScopesIds.isEmpty()) {
            grantedClientScopesIds.stream().map(scopeId -> KeycloakModelUtils.findClientScopeById((RealmModel)realm, (ClientModel)client, (String)scopeId)).filter(Objects::nonNull).forEach(arg_0 -> ((UserConsentModel)model).addGrantedClientScope(arg_0));
        }
        return model;
    }

    public String getClientId();

    public void setClientId(String var1);

    public Set<String> getGrantedClientScopesIds();

    public void addGrantedClientScopesId(String var1);

    public void setGrantedClientScopesIds(Set<String> var1);

    public void removeGrantedClientScopesId(String var1);

    public Long getCreatedDate();

    public void setCreatedDate(Long var1);

    public Long getLastUpdatedDate();

    public void setLastUpdatedDate(Long var1);
}

