/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authSession;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionAdapter;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntityImpl;
import org.keycloak.models.map.common.ExpirationUtils;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.utils.SessionExpiration;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class MapRootAuthenticationSessionProvider
implements AuthenticationSessionProvider {
    private static final Logger LOG = Logger.getLogger(MapRootAuthenticationSessionProvider.class);
    private final KeycloakSession session;
    protected final MapKeycloakTransaction<MapRootAuthenticationSessionEntity, RootAuthenticationSessionModel> tx;
    private int authSessionsLimit;

    public MapRootAuthenticationSessionProvider(KeycloakSession session, MapStorage<MapRootAuthenticationSessionEntity, RootAuthenticationSessionModel> sessionStore, int authSessionsLimit) {
        this.session = session;
        this.tx = sessionStore.createTransaction(session);
        this.authSessionsLimit = authSessionsLimit;
        session.getTransactionManager().enlistAfterCompletion(this.tx);
    }

    private Function<MapRootAuthenticationSessionEntity, RootAuthenticationSessionModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> {
            if (ExpirationUtils.isExpired(origEntity, true)) {
                this.tx.delete(origEntity.getId());
                return null;
            }
            return new MapRootAuthenticationSessionAdapter(this.session, realm, (MapRootAuthenticationSessionEntity)origEntity, this.authSessionsLimit);
        };
    }

    private Predicate<MapRootAuthenticationSessionEntity> entityRealmFilter(String realmId) {
        if (realmId == null) {
            return c -> false;
        }
        return entity -> Objects.equals(realmId, entity.getRealmId());
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        return this.createRootAuthenticationSession(realm, null);
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm, String id) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        LOG.tracef("createRootAuthenticationSession(%s)%s", (Object)realm.getName(), StackUtil.getShortStackTrace());
        MapRootAuthenticationSessionEntity entity = new MapRootAuthenticationSessionEntityImpl();
        entity.setId(id);
        entity.setRealmId(realm.getId());
        long timestamp = Time.currentTimeMillis();
        entity.setTimestamp(timestamp);
        int authSessionLifespanSeconds = SessionExpiration.getAuthSessionLifespan((RealmModel)realm);
        entity.setExpiration(timestamp + TimeAdapter.fromSecondsToMilliseconds(authSessionLifespanSeconds));
        if (id != null && this.tx.read(id) != null) {
            throw new ModelDuplicateException("Root authentication session exists: " + entity.getId());
        }
        entity = this.tx.create(entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public RootAuthenticationSessionModel getRootAuthenticationSession(RealmModel realm, String authenticationSessionId) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        if (authenticationSessionId == null) {
            return null;
        }
        LOG.tracef("getRootAuthenticationSession(%s, %s)%s", (Object)realm.getName(), (Object)authenticationSessionId, StackUtil.getShortStackTrace());
        MapRootAuthenticationSessionEntity entity = this.tx.read(authenticationSessionId);
        return entity == null || !this.entityRealmFilter(realm.getId()).test(entity) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public void removeRootAuthenticationSession(RealmModel realm, RootAuthenticationSessionModel authenticationSession) {
        Objects.requireNonNull(authenticationSession, "The provided root authentication session can't be null!");
        this.tx.delete(authenticationSession.getId());
    }

    public void removeAllExpired() {
        LOG.tracef("removeAllExpired()%s", StackUtil.getShortStackTrace());
        LOG.warnf("Clearing expired entities should not be triggered manually. It is responsibility of the store to clear these.", new Object[0]);
    }

    public void removeExpired(RealmModel realm) {
        LOG.tracef("removeExpired(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        LOG.warnf("Clearing expired entities should not be triggered manually. It is responsibility of the store to clear these.", new Object[0]);
    }

    public void onRealmRemoved(RealmModel realm) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(RootAuthenticationSessionModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        this.tx.delete(QueryParameters.withCriteria(mcb));
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
    }

    public void updateNonlocalSessionAuthNotes(AuthenticationSessionCompoundId compoundId, Map<String, String> authNotesFragment) {
        if (compoundId == null) {
            return;
        }
        Objects.requireNonNull(authNotesFragment, "The provided authentication's notes map can't be null!");
    }

    public void close() {
    }
}

