package org.keycloak.models.map.user;
public class MapUserEntityDelegate implements org.keycloak.models.map.user.MapUserEntity {
    private final org.keycloak.models.map.common.delegate.DelegateProvider<org.keycloak.models.map.user.MapUserEntity> delegateProvider;
    public MapUserEntityDelegate(org.keycloak.models.map.common.delegate.DelegateProvider<org.keycloak.models.map.user.MapUserEntity> delegateProvider) {
        this.delegateProvider = delegateProvider;
    }
    @Override public boolean isUpdated() {
        return delegateProvider.isUpdated();
    }
    @Override public java.util.Map<String,java.util.List<String>> getAttributes() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.ATTRIBUTES).getAttributes();
    }
    @Override public void setAttributes(java.util.Map<String,java.util.List<String>> attributes) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.ATTRIBUTES, attributes).setAttributes(attributes);
    }
    @Override public java.util.List<String> getAttribute(String name) {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.ATTRIBUTES, name).getAttribute(name);
    }
    @Override public void setAttribute(String name, java.util.List<String> value) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.ATTRIBUTES, name, value).setAttribute(name, value);
    }
    @Override public void removeAttribute(String name) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.ATTRIBUTES, name).removeAttribute(name);
    }
    @Override public String getId() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.ID).getId();
    }
    @Override public void setId(String id) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.ID, id).setId(id);
    }
    @Override public String getRealmId() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.REALM_ID).getRealmId();
    }
    @Override public void setRealmId(String realmId) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.REALM_ID, realmId).setRealmId(realmId);
    }
    @Override public String getUsername() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.USERNAME).getUsername();
    }
    @Override public void setUsername(String username) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.USERNAME, username).setUsername(username);
    }
    @Override public String getFirstName() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.FIRST_NAME).getFirstName();
    }
    @Override public void setFirstName(String firstName) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.FIRST_NAME, firstName).setFirstName(firstName);
    }
    @Override public Long getCreatedTimestamp() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.CREATED_TIMESTAMP).getCreatedTimestamp();
    }
    @Override public void setCreatedTimestamp(Long createdTimestamp) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.CREATED_TIMESTAMP, createdTimestamp).setCreatedTimestamp(createdTimestamp);
    }
    @Override public String getLastName() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.LAST_NAME).getLastName();
    }
    @Override public void setLastName(String lastName) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.LAST_NAME, lastName).setLastName(lastName);
    }
    @Override public String getEmail() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.EMAIL).getEmail();
    }
    @Override public void setEmail(String email) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.EMAIL, email).setEmail(email);
    }
    @Override public void setEmail(String email, boolean duplicateEmailsAllowed) {
        delegateProvider.getDelegate(false, null, email, duplicateEmailsAllowed).setEmail(email, duplicateEmailsAllowed);
    }
    @Override public Boolean isEnabled() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.ENABLED).isEnabled();
    }
    @Override public void setEnabled(Boolean enabled) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.ENABLED, enabled).setEnabled(enabled);
    }
    @Override public Boolean isEmailVerified() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.EMAIL_VERIFIED).isEmailVerified();
    }
    @Override public void setEmailVerified(Boolean emailVerified) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.EMAIL_VERIFIED, emailVerified).setEmailVerified(emailVerified);
    }
    @Override public String getEmailConstraint() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.EMAIL_CONSTRAINT).getEmailConstraint();
    }
    @Override public void setEmailConstraint(String emailConstraint) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.EMAIL_CONSTRAINT, emailConstraint).setEmailConstraint(emailConstraint);
    }
    @Override public java.util.Set<String> getRequiredActions() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.REQUIRED_ACTIONS).getRequiredActions();
    }
    @Override public void setRequiredActions(java.util.Set<String> requiredActions) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.REQUIRED_ACTIONS, requiredActions).setRequiredActions(requiredActions);
    }
    @Override public void addRequiredAction(String requiredAction) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.REQUIRED_ACTIONS, requiredAction).addRequiredAction(requiredAction);
    }
    @Override public void removeRequiredAction(String requiredAction) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.REQUIRED_ACTIONS, requiredAction).removeRequiredAction(requiredAction);
    }
    @Override public java.util.List<org.keycloak.models.map.user.MapUserCredentialEntity> getCredentials() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.CREDENTIALS).getCredentials();
    }
    @Override public java.util.Optional<org.keycloak.models.map.user.MapUserCredentialEntity> getCredential(String id) {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.CREDENTIALS, id).getCredential(id);
    }
    @Override public void setCredentials(java.util.List<org.keycloak.models.map.user.MapUserCredentialEntity> credentials) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.CREDENTIALS, credentials).setCredentials(credentials);
    }
    @Override public void addCredential(org.keycloak.models.map.user.MapUserCredentialEntity credentialEntity) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.CREDENTIALS, credentialEntity).addCredential(credentialEntity);
    }
    @Override public Boolean removeCredential(org.keycloak.models.map.user.MapUserCredentialEntity credentialEntity) {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.CREDENTIALS, credentialEntity).removeCredential(credentialEntity);
    }
    @Override public Boolean removeCredential(String id) {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.CREDENTIALS, id).removeCredential(id);
    }
    @Override public Boolean moveCredential(String credentialId, String newPreviousCredentialId) {
        return delegateProvider.getDelegate(true, null, credentialId, newPreviousCredentialId).moveCredential(credentialId, newPreviousCredentialId);
    }
    @Override public java.util.Set<org.keycloak.models.map.user.MapUserFederatedIdentityEntity> getFederatedIdentities() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.FEDERATED_IDENTITIES).getFederatedIdentities();
    }
    @Override public java.util.Optional<org.keycloak.models.map.user.MapUserFederatedIdentityEntity> getFederatedIdentity(String identityProviderId) {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.FEDERATED_IDENTITIES, identityProviderId).getFederatedIdentity(identityProviderId);
    }
    @Override public void setFederatedIdentities(java.util.Set<org.keycloak.models.map.user.MapUserFederatedIdentityEntity> federatedIdentities) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.FEDERATED_IDENTITIES, federatedIdentities).setFederatedIdentities(federatedIdentities);
    }
    @Override public void addFederatedIdentity(org.keycloak.models.map.user.MapUserFederatedIdentityEntity federatedIdentity) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.FEDERATED_IDENTITIES, federatedIdentity).addFederatedIdentity(federatedIdentity);
    }
    @Override public Boolean removeFederatedIdentity(org.keycloak.models.map.user.MapUserFederatedIdentityEntity providerId) {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.FEDERATED_IDENTITIES, providerId).removeFederatedIdentity(providerId);
    }
    @Override public Boolean removeFederatedIdentity(String identityProviderId) {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.FEDERATED_IDENTITIES, identityProviderId).removeFederatedIdentity(identityProviderId);
    }
    @Override public java.util.Set<org.keycloak.models.map.user.MapUserConsentEntity> getUserConsents() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.USER_CONSENTS).getUserConsents();
    }
    @Override public java.util.Optional<org.keycloak.models.map.user.MapUserConsentEntity> getUserConsent(String clientId) {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.USER_CONSENTS, clientId).getUserConsent(clientId);
    }
    @Override public void setUserConsents(java.util.Set<org.keycloak.models.map.user.MapUserConsentEntity> userConsentEntity) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.USER_CONSENTS, userConsentEntity).setUserConsents(userConsentEntity);
    }
    @Override public void addUserConsent(org.keycloak.models.map.user.MapUserConsentEntity userConsentEntity) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.USER_CONSENTS, userConsentEntity).addUserConsent(userConsentEntity);
    }
    @Override public Boolean removeUserConsent(org.keycloak.models.map.user.MapUserConsentEntity userConsentEntity) {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.USER_CONSENTS, userConsentEntity).removeUserConsent(userConsentEntity);
    }
    @Override public Boolean removeUserConsent(String clientId) {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.USER_CONSENTS, clientId).removeUserConsent(clientId);
    }
    @Override public java.util.Set<String> getGroupsMembership() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.GROUPS_MEMBERSHIP).getGroupsMembership();
    }
    @Override public void setGroupsMembership(java.util.Set<String> groupsMembership) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.GROUPS_MEMBERSHIP, groupsMembership).setGroupsMembership(groupsMembership);
    }
    @Override public void addGroupsMembership(String groupId) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.GROUPS_MEMBERSHIP, groupId).addGroupsMembership(groupId);
    }
    @Override public void removeGroupsMembership(String groupId) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.GROUPS_MEMBERSHIP, groupId).removeGroupsMembership(groupId);
    }
    @Override public java.util.Set<String> getRolesMembership() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.ROLES_MEMBERSHIP).getRolesMembership();
    }
    @Override public void setRolesMembership(java.util.Set<String> rolesMembership) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.ROLES_MEMBERSHIP, rolesMembership).setRolesMembership(rolesMembership);
    }
    @Override public void addRolesMembership(String roleId) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.ROLES_MEMBERSHIP, roleId).addRolesMembership(roleId);
    }
    @Override public void removeRolesMembership(String roleId) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.ROLES_MEMBERSHIP, roleId).removeRolesMembership(roleId);
    }
    @Override public String getFederationLink() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.FEDERATION_LINK).getFederationLink();
    }
    @Override public void setFederationLink(String federationLink) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.FEDERATION_LINK, federationLink).setFederationLink(federationLink);
    }
    @Override public String getServiceAccountClientLink() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.SERVICE_ACCOUNT_CLIENT_LINK).getServiceAccountClientLink();
    }
    @Override public void setServiceAccountClientLink(String serviceAccountClientLink) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.SERVICE_ACCOUNT_CLIENT_LINK, serviceAccountClientLink).setServiceAccountClientLink(serviceAccountClientLink);
    }
    @Override public Long getNotBefore() {
        return delegateProvider.getDelegate(true, org.keycloak.models.map.user.MapUserEntityFields.NOT_BEFORE).getNotBefore();
    }
    @Override public void setNotBefore(Long notBefore) {
        delegateProvider.getDelegate(false, org.keycloak.models.map.user.MapUserEntityFields.NOT_BEFORE, notBefore).setNotBefore(notBefore);
    }
}
