/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authSession;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authSession.AbstractRootAuthenticationSessionModel;
import org.keycloak.models.map.authSession.MapAuthenticationSessionAdapter;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntityImpl;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntity;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.utils.SessionExpiration;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class MapRootAuthenticationSessionAdapter
extends AbstractRootAuthenticationSessionModel<MapRootAuthenticationSessionEntity> {
    private static final Logger LOG = Logger.getLogger(MapRootAuthenticationSessionAdapter.class);
    private int authSessionsLimit;
    private static Comparator<MapAuthenticationSessionEntity> TIMESTAMP_COMPARATOR = Comparator.comparingLong(MapAuthenticationSessionEntity::getTimestamp);

    public MapRootAuthenticationSessionAdapter(KeycloakSession session, RealmModel realm, MapRootAuthenticationSessionEntity entity, int authSessionsLimit) {
        super(session, realm, entity);
        this.authSessionsLimit = authSessionsLimit;
    }

    public String getId() {
        return ((MapRootAuthenticationSessionEntity)this.entity).getId();
    }

    public RealmModel getRealm() {
        return this.session.realms().getRealm(((MapRootAuthenticationSessionEntity)this.entity).getRealmId());
    }

    public int getTimestamp() {
        return TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(TimeAdapter.fromMilliSecondsToSeconds(((MapRootAuthenticationSessionEntity)this.entity).getTimestamp()));
    }

    public void setTimestamp(int timestamp) {
        ((MapRootAuthenticationSessionEntity)this.entity).setTimestamp(TimeAdapter.fromSecondsToMilliseconds(timestamp));
        ((MapRootAuthenticationSessionEntity)this.entity).setExpiration(TimeAdapter.fromSecondsToMilliseconds(SessionExpiration.getAuthSessionExpiration((RealmModel)this.realm, (int)timestamp)));
    }

    public Map<String, AuthenticationSessionModel> getAuthenticationSessions() {
        return Optional.ofNullable(((MapRootAuthenticationSessionEntity)this.entity).getAuthenticationSessions()).orElseGet(Collections::emptySet).stream().collect(Collectors.toMap(MapAuthenticationSessionEntity::getTabId, this::toAdapter));
    }

    public AuthenticationSessionModel getAuthenticationSession(ClientModel client, String tabId) {
        if (client == null || tabId == null) {
            return null;
        }
        return ((MapRootAuthenticationSessionEntity)this.entity).getAuthenticationSession(tabId).map(this::toAdapter).map(this::setAuthContext).orElse(null);
    }

    public AuthenticationSessionModel createAuthenticationSession(ClientModel client) {
        String tabId;
        Objects.requireNonNull(client, "The provided client can't be null!");
        Set<MapAuthenticationSessionEntity> authenticationSessions = ((MapRootAuthenticationSessionEntity)this.entity).getAuthenticationSessions();
        if (authenticationSessions != null && authenticationSessions.size() >= this.authSessionsLimit && (tabId = (String)authenticationSessions.stream().min(TIMESTAMP_COMPARATOR).map(MapAuthenticationSessionEntity::getTabId).orElse(null)) != null) {
            LOG.debugf("Reached limit (%s) of active authentication sessions per a root authentication session. Removing oldest authentication session with TabId %s.", this.authSessionsLimit, (Object)tabId);
            ((MapRootAuthenticationSessionEntity)this.entity).removeAuthenticationSession(tabId);
        }
        MapAuthenticationSessionEntityImpl authSessionEntity = new MapAuthenticationSessionEntityImpl();
        authSessionEntity.setClientUUID(client.getId());
        long timestamp = Time.currentTimeMillis();
        authSessionEntity.setTimestamp(timestamp);
        String tabId2 = this.generateTabId();
        authSessionEntity.setTabId(tabId2);
        ((MapRootAuthenticationSessionEntity)this.entity).addAuthenticationSession(authSessionEntity);
        ((MapRootAuthenticationSessionEntity)this.entity).setTimestamp(timestamp);
        int authSessionLifespanSeconds = SessionExpiration.getAuthSessionLifespan((RealmModel)this.realm);
        ((MapRootAuthenticationSessionEntity)this.entity).setExpiration(timestamp + TimeAdapter.fromSecondsToMilliseconds(authSessionLifespanSeconds));
        return ((MapRootAuthenticationSessionEntity)this.entity).getAuthenticationSession(tabId2).map(this::toAdapter).map(this::setAuthContext).orElse(null);
    }

    public void removeAuthenticationSessionByTabId(String tabId) {
        Boolean result = ((MapRootAuthenticationSessionEntity)this.entity).removeAuthenticationSession(tabId);
        if (result == null || result.booleanValue()) {
            if (((MapRootAuthenticationSessionEntity)this.entity).getAuthenticationSessions().isEmpty()) {
                this.session.authenticationSessions().removeRootAuthenticationSession(this.realm, (RootAuthenticationSessionModel)this);
            } else {
                long timestamp = Time.currentTimeMillis();
                ((MapRootAuthenticationSessionEntity)this.entity).setTimestamp(timestamp);
                int authSessionLifespanSeconds = SessionExpiration.getAuthSessionLifespan((RealmModel)this.realm);
                ((MapRootAuthenticationSessionEntity)this.entity).setExpiration(timestamp + TimeAdapter.fromSecondsToMilliseconds(authSessionLifespanSeconds));
            }
        }
    }

    public void restartSession(RealmModel realm) {
        ((MapRootAuthenticationSessionEntity)this.entity).setAuthenticationSessions(null);
        long timestamp = Time.currentTimeMillis();
        ((MapRootAuthenticationSessionEntity)this.entity).setTimestamp(timestamp);
        int authSessionLifespanSeconds = SessionExpiration.getAuthSessionLifespan((RealmModel)realm);
        ((MapRootAuthenticationSessionEntity)this.entity).setExpiration(timestamp + TimeAdapter.fromSecondsToMilliseconds(authSessionLifespanSeconds));
    }

    private String generateTabId() {
        return Base64Url.encode((byte[])SecretGenerator.getInstance().randomBytes(8));
    }

    private MapAuthenticationSessionAdapter toAdapter(MapAuthenticationSessionEntity entity) {
        return new MapAuthenticationSessionAdapter(this.session, this, entity.getTabId(), entity);
    }

    private MapAuthenticationSessionAdapter setAuthContext(MapAuthenticationSessionAdapter adapter) {
        this.session.getContext().setAuthenticationSession((AuthenticationSessionModel)adapter);
        return adapter;
    }
}

