/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage;

import java.util.stream.Stream;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.QueryParameters;

public interface CrudOperations<V extends AbstractEntity & UpdatableEntity, M> {
    public V create(V var1);

    public V read(String var1);

    public V update(V var1);

    public boolean delete(String var1);

    public long delete(QueryParameters<M> var1);

    public Stream<V> read(QueryParameters<M> var1);

    public long getCount(QueryParameters<M> var1);

    default public boolean exists(String key) {
        return this.read(key) != null;
    }

    default public boolean exists(QueryParameters<M> queryParameters) {
        return this.getCount(queryParameters) > 0L;
    }

    default public String determineKeyFromValue(V value) {
        return value == null ? null : value.getId();
    }
}

