/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapClientEntityImpl;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntityImpl;
import org.keycloak.models.map.common.DeepCloner;

public class MapClientEntityClonerTest {
    private static final DeepCloner CLONER = new DeepCloner.Builder().constructor(MapClientEntityImpl.class, MapClientEntityImpl::new).constructor(MapProtocolMapperEntity.class, MapProtocolMapperEntityImpl::new).build();

    @Test
    public void testNewInstance() {
        MapClientEntity newInstance = (MapClientEntity)CLONER.newInstance(MapClientEntity.class);
        MatcherAssert.assertThat((Object)newInstance, (Matcher)Matchers.instanceOf(MapClientEntityImpl.class));
        MatcherAssert.assertThat((Object)newInstance.getId(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testNewInstanceWithId() {
        MapClientEntity newInstance = (MapClientEntity)CLONER.newInstance(MapClientEntity.class);
        newInstance.setId("my-id");
        MatcherAssert.assertThat((Object)newInstance, (Matcher)Matchers.instanceOf(MapClientEntityImpl.class));
        MatcherAssert.assertThat((Object)newInstance.getId(), (Matcher)Matchers.is((Object)"my-id"));
    }

    @Test
    public void testCloneAsNewInstance() {
        MapClientEntity newInstance = (MapClientEntity)CLONER.newInstance(MapClientEntity.class);
        newInstance.setId("my-id");
        newInstance.setClientId("a-client-id");
        newInstance.setAttribute("attr", Arrays.asList("aa", "bb", "cc"));
        MapClientEntity clonedInstance = (MapClientEntity)CLONER.from((Object)newInstance);
        MatcherAssert.assertThat((Object)clonedInstance, (Matcher)Matchers.instanceOf(MapClientEntityImpl.class));
        MatcherAssert.assertThat((Object)clonedInstance.getId(), (Matcher)Matchers.is((Object)"my-id"));
        MatcherAssert.assertThat((Object)clonedInstance.getClientId(), (Matcher)Matchers.is((Object)"a-client-id"));
        MatcherAssert.assertThat((Object)clonedInstance.getAttributes(), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)newInstance.getAttributes())));
        MatcherAssert.assertThat(clonedInstance.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr"}));
        MatcherAssert.assertThat((Object)((List)clonedInstance.getAttributes().get("attr")), (Matcher)Matchers.contains((Object[])new String[]{"aa", "bb", "cc"}));
        MatcherAssert.assertThat((Object)((List)clonedInstance.getAttributes().get("attr")), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)((List)newInstance.getAttributes().get("attr")))));
        MatcherAssert.assertThat((Object)clonedInstance.getAuthenticationFlowBindingOverrides(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)clonedInstance.getRegistrationToken(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testCloneToExistingInstance() {
        MapClientEntity newInstance = (MapClientEntity)CLONER.newInstance(MapClientEntity.class);
        newInstance.setId("my-id");
        newInstance.setClientId("a-client-id");
        newInstance.setAttribute("attr", Arrays.asList("aa", "bb", "cc"));
        MapProtocolMapperEntity pmm = (MapProtocolMapperEntity)DeepCloner.DUMB_CLONER.newInstance(MapProtocolMapperEntity.class);
        pmm.setId("pmm-id");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("key1", "value1");
        config.put("key2", "value2");
        pmm.setConfig(config);
        newInstance.addProtocolMapper(pmm);
        newInstance.setAttribute("attr", Arrays.asList("aa", "bb", "cc"));
        MapClientEntity clonedInstance = (MapClientEntity)CLONER.newInstance(MapClientEntity.class);
        MatcherAssert.assertThat((Object)((MapClientEntity)CLONER.deepCloneNoId((Object)newInstance, (Object)clonedInstance)), (Matcher)Matchers.sameInstance((Object)clonedInstance));
        MatcherAssert.assertThat((Object)clonedInstance, (Matcher)Matchers.instanceOf(MapClientEntityImpl.class));
        clonedInstance.setId("my-id2");
        MatcherAssert.assertThat((Object)clonedInstance.getId(), (Matcher)Matchers.is((Object)"my-id2"));
        MatcherAssert.assertThat((Object)clonedInstance.getClientId(), (Matcher)Matchers.is((Object)"a-client-id"));
        MatcherAssert.assertThat((Object)clonedInstance.getAttributes(), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)newInstance.getAttributes())));
        MatcherAssert.assertThat(clonedInstance.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr"}));
        MatcherAssert.assertThat((Object)((List)clonedInstance.getAttributes().get("attr")), (Matcher)Matchers.contains((Object[])new String[]{"aa", "bb", "cc"}));
        MatcherAssert.assertThat((Object)((List)clonedInstance.getAttributes().get("attr")), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)((List)newInstance.getAttributes().get("attr")))));
        MatcherAssert.assertThat((Object)clonedInstance.getProtocolMappers(), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)newInstance.getProtocolMappers())));
        MatcherAssert.assertThat((Object)clonedInstance.getProtocolMapper("pmm-id").isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)newInstance.getProtocolMapper("pmm-id").isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((MapProtocolMapperEntity)clonedInstance.getProtocolMapper("pmm-id").get()), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)((MapProtocolMapperEntity)newInstance.getProtocolMapper("pmm-id").get()))));
        MatcherAssert.assertThat((Object)((MapProtocolMapperEntity)clonedInstance.getProtocolMapper("pmm-id").get()), (Matcher)Matchers.equalTo((Object)((MapProtocolMapperEntity)newInstance.getProtocolMapper("pmm-id").get())));
        MatcherAssert.assertThat((Object)((MapProtocolMapperEntity)clonedInstance.getProtocolMapper("pmm-id").get()).getConfig(), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)((MapProtocolMapperEntity)newInstance.getProtocolMapper("pmm-id").get()).getConfig())));
        MatcherAssert.assertThat((Object)((MapProtocolMapperEntity)clonedInstance.getProtocolMapper("pmm-id").get()).getConfig(), (Matcher)Matchers.equalTo((Object)((MapProtocolMapperEntity)newInstance.getProtocolMapper("pmm-id").get()).getConfig()));
        MatcherAssert.assertThat((Object)clonedInstance.getAuthenticationFlowBindingOverrides(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)clonedInstance.getRegistrationToken(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testCloneToExistingInstanceDumb() {
        MapClientEntity newInstance = (MapClientEntity)DeepCloner.DUMB_CLONER.newInstance(MapClientEntity.class);
        newInstance.setId("my-id");
        newInstance.setClientId("a-client-id");
        newInstance.setAttribute("attr", Arrays.asList("aa", "bb", "cc"));
        MapProtocolMapperEntity pmm = (MapProtocolMapperEntity)DeepCloner.DUMB_CLONER.newInstance(MapProtocolMapperEntity.class);
        pmm.setId("pmm-id");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("key1", "value1");
        config.put("key2", "value2");
        pmm.setConfig(config);
        newInstance.addProtocolMapper(pmm);
        newInstance.setAttribute("attr", Arrays.asList("aa", "bb", "cc"));
        MapClientEntity clonedInstance = (MapClientEntity)CLONER.newInstance(MapClientEntity.class);
        MatcherAssert.assertThat((Object)((MapClientEntity)CLONER.deepCloneNoId((Object)newInstance, (Object)clonedInstance)), (Matcher)Matchers.sameInstance((Object)clonedInstance));
        MatcherAssert.assertThat((Object)clonedInstance, (Matcher)Matchers.instanceOf(MapClientEntityImpl.class));
        clonedInstance.setId("my-id2");
        MatcherAssert.assertThat((Object)clonedInstance.getId(), (Matcher)Matchers.is((Object)"my-id2"));
        MatcherAssert.assertThat((Object)clonedInstance.getClientId(), (Matcher)Matchers.is((Object)"a-client-id"));
        MatcherAssert.assertThat((Object)clonedInstance.getAttributes(), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)newInstance.getAttributes())));
        MatcherAssert.assertThat(clonedInstance.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr"}));
        MatcherAssert.assertThat((Object)((List)clonedInstance.getAttributes().get("attr")), (Matcher)Matchers.contains((Object[])new String[]{"aa", "bb", "cc"}));
        MatcherAssert.assertThat((Object)((List)clonedInstance.getAttributes().get("attr")), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)((List)newInstance.getAttributes().get("attr")))));
        MatcherAssert.assertThat((Object)clonedInstance.getProtocolMappers(), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)newInstance.getProtocolMappers())));
        MatcherAssert.assertThat((Object)clonedInstance.getProtocolMapper("pmm-id").isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)newInstance.getProtocolMapper("pmm-id").isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((MapProtocolMapperEntity)clonedInstance.getProtocolMapper("pmm-id").get()), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)((MapProtocolMapperEntity)newInstance.getProtocolMapper("pmm-id").get()))));
        MatcherAssert.assertThat((Object)((MapProtocolMapperEntity)clonedInstance.getProtocolMapper("pmm-id").get()), (Matcher)Matchers.equalTo((Object)((MapProtocolMapperEntity)newInstance.getProtocolMapper("pmm-id").get())));
        MatcherAssert.assertThat((Object)((MapProtocolMapperEntity)clonedInstance.getProtocolMapper("pmm-id").get()).getConfig(), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)((MapProtocolMapperEntity)newInstance.getProtocolMapper("pmm-id").get()).getConfig())));
        MatcherAssert.assertThat((Object)((MapProtocolMapperEntity)clonedInstance.getProtocolMapper("pmm-id").get()).getConfig(), (Matcher)Matchers.equalTo((Object)((MapProtocolMapperEntity)newInstance.getProtocolMapper("pmm-id").get()).getConfig()));
        MatcherAssert.assertThat((Object)clonedInstance.getAuthenticationFlowBindingOverrides(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)clonedInstance.getRegistrationToken(), (Matcher)Matchers.nullValue());
    }
}

