/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.models.map.common.StreamUtils;

public class StreamUtilsTest {
    @Test
    public void testLeftInnerJoinStream() {
        Stream<Integer> a = Stream.of(0, 1, 2, 3, 4);
        Stream[] b = new Stream[]{Stream.of(1, 2), Stream.of(1, 2), null, null, Stream.of(5, 6, 7)};
        try (Stream res = StreamUtils.leftInnerJoinStream(a, n -> b[n]);){
            List l = res.collect(Collectors.toList());
            Assert.assertEquals(l, Arrays.asList(new StreamUtils.Pair((Object)0, (Object)1), new StreamUtils.Pair((Object)0, (Object)2), new StreamUtils.Pair((Object)1, (Object)1), new StreamUtils.Pair((Object)1, (Object)2), new StreamUtils.Pair((Object)4, (Object)5), new StreamUtils.Pair((Object)4, (Object)6), new StreamUtils.Pair((Object)4, (Object)7)));
        }
    }

    @Test
    public void testLeftInnerJoinIterable() {
        Stream<Integer> a = Stream.of(0, 1, 2, 3, 4);
        Iterable[] b = new Iterable[]{Arrays.asList(1, 2), Arrays.asList(1, 2), null, null, Arrays.asList(5, 6, 7)};
        try (Stream res = StreamUtils.leftInnerJoinIterable(a, n -> b[n]);){
            List l = res.collect(Collectors.toList());
            Assert.assertEquals(l, Arrays.asList(new StreamUtils.Pair((Object)0, (Object)1), new StreamUtils.Pair((Object)0, (Object)2), new StreamUtils.Pair((Object)1, (Object)1), new StreamUtils.Pair((Object)1, (Object)2), new StreamUtils.Pair((Object)4, (Object)5), new StreamUtils.Pair((Object)4, (Object)6), new StreamUtils.Pair((Object)4, (Object)7)));
        }
    }
}

