/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common.delegate;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapClientEntityFields;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.delegate.EntityFieldDelegate;
import org.keycloak.models.map.common.delegate.PerFieldDelegateProvider;
import org.keycloak.models.map.storage.tree.TreeStorageNodeInstance;
import org.keycloak.models.map.storage.tree.TreeStorageNodePrescription;

public class PerFieldDelegateProviderPrimarySourceTest {
    private MapClientEntity upperEnt;
    private MapClientEntity lowerEnt;
    private HashMap<String, Object> upperNodeProperties;
    private EnumMap<MapClientEntityFields, Object> upperPrimarySourceFor;
    private EnumMap<MapClientEntityFields, Object> upperPrimarySourceForExcluded;
    private HashMap<String, Object> lowerNodeProperties;
    private EnumMap<MapClientEntityFields, Object> lowerPrimarySourceFor;
    private EnumMap<MapClientEntityFields, Object> lowerPrimarySourceForExcluded;
    private TreeStorageNodeInstance<MapClientEntity> upperTsni;
    private TreeStorageNodeInstance<MapClientEntity> lowerTsni;
    AtomicInteger lowerEntSupplierCallCount = new AtomicInteger();

    @Before
    public void initEntities() {
        this.upperEnt = (MapClientEntity)DeepCloner.DUMB_CLONER.newInstance(MapClientEntity.class);
        this.lowerEnt = (MapClientEntity)DeepCloner.DUMB_CLONER.newInstance(MapClientEntity.class);
        this.upperEnt.setProtocol("upper-protocol");
        this.upperEnt.addRedirectUri("upper-redirectUri-1");
        this.upperEnt.addRedirectUri("upper-redirectUri-2");
        this.upperEnt.setClientId("upper-clientId-1");
        this.upperEnt.setAttribute("attr1", Arrays.asList("upper-value-1"));
        this.upperEnt.setAttribute("attr2", Arrays.asList("upper-value-2"));
        this.upperEnt.setAttribute("attr3", Arrays.asList("upper-value-3"));
        this.lowerEnt.setProtocol("lower-protocol");
        this.lowerEnt.addRedirectUri("lower-redirectUri-1");
        this.lowerEnt.addRedirectUri("lower-redirectUri-2");
        this.lowerEnt.setClientId("lower-clientId-1");
        this.lowerEnt.setAttribute("attr1", Arrays.asList("lower-value-1"));
        this.lowerEnt.setAttribute("attr3", Arrays.asList("lower-value-3"));
        this.lowerEnt.setAttribute("attr4", Arrays.asList("lower-value-4"));
        this.upperNodeProperties = new HashMap();
        this.upperPrimarySourceFor = new EnumMap(MapClientEntityFields.class);
        this.upperPrimarySourceForExcluded = new EnumMap(MapClientEntityFields.class);
        this.lowerNodeProperties = new HashMap();
        this.lowerPrimarySourceFor = new EnumMap(MapClientEntityFields.class);
        this.lowerPrimarySourceForExcluded = new EnumMap(MapClientEntityFields.class);
        this.lowerEntSupplierCallCount.set(0);
    }

    private MapClientEntity prepareEntityAndTreeNodeInstances() {
        TreeStorageNodePrescription upperTsnp = new TreeStorageNodePrescription(this.upperNodeProperties, null, null);
        TreeStorageNodePrescription lowerTsnp = new TreeStorageNodePrescription(this.lowerNodeProperties, null, null);
        this.upperTsni = new TreeStorageNodeInstance(null, upperTsnp);
        this.lowerTsni = new TreeStorageNodeInstance(null, lowerTsnp);
        TreeStorageNodeInstance<MapClientEntity> treeStorageNodeInstance = this.upperTsni;
        Objects.requireNonNull(treeStorageNodeInstance);
        PerFieldDelegateProvider fieldProvider = new PerFieldDelegateProvider(new TreeStorageNodeInstance.WithEntity(treeStorageNodeInstance, (AbstractEntity)this.upperEnt), () -> {
            this.lowerEntSupplierCallCount.incrementAndGet();
            return this.lowerEnt;
        });
        return (MapClientEntity)DeepCloner.DUMB_CLONER.entityFieldDelegate(MapClientEntity.class, (EntityFieldDelegate)fieldProvider);
    }

    @Test
    public void testGet_NoPrimarySource() {
        MapClientEntity ent = this.prepareEntityAndTreeNodeInstances();
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)ent.getProtocol(), (Matcher)Matchers.is((Object)"upper-protocol"));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr1"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-1"}));
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr2"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-2"}));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr3"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-3"}));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr4"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)ent.getClientId(), (Matcher)Matchers.is((Object)"upper-clientId-1"));
        MatcherAssert.assertThat(ent.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr2", "attr3"}));
        MatcherAssert.assertThat((Object)ent.getAttributes(), (Matcher)Matchers.hasEntry((Object)"attr1", Arrays.asList("upper-value-1")));
        MatcherAssert.assertThat((Object)ent.getAttributes(), (Matcher)Matchers.hasEntry((Object)"attr2", Arrays.asList("upper-value-2")));
        MatcherAssert.assertThat((Object)ent.getAttributes(), (Matcher)Matchers.hasEntry((Object)"attr3", Arrays.asList("upper-value-3")));
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testSet_NoPrimarySource() {
        MapClientEntity ent = this.prepareEntityAndTreeNodeInstances();
        ent.setProtocol("modified-protocol");
        ent.setAttribute("attr1", Arrays.asList("modified-value-1"));
        ent.setAttribute("attrX", Arrays.asList("modified-value-X"));
        ent.addRedirectUri("added-redirectUri");
        ent.removeRedirectUri("upper-redirectUri-2");
        ent.removeRedirectUri("lower-redirectUri-2");
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)ent.getClientId(), (Matcher)Matchers.is((Object)"upper-clientId-1"));
        MatcherAssert.assertThat((Object)this.upperEnt.getClientId(), (Matcher)Matchers.is((Object)"upper-clientId-1"));
        MatcherAssert.assertThat((Object)this.lowerEnt.getClientId(), (Matcher)Matchers.is((Object)"lower-clientId-1"));
        MatcherAssert.assertThat((Object)ent.getProtocol(), (Matcher)Matchers.is((Object)"modified-protocol"));
        MatcherAssert.assertThat((Object)this.upperEnt.getProtocol(), (Matcher)Matchers.is((Object)"modified-protocol"));
        MatcherAssert.assertThat((Object)this.lowerEnt.getProtocol(), (Matcher)Matchers.is((Object)"lower-protocol"));
        MatcherAssert.assertThat((Object)ent.getRedirectUris(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"upper-redirectUri-1", "added-redirectUri"}));
        MatcherAssert.assertThat((Object)this.upperEnt.getRedirectUris(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"upper-redirectUri-1", "added-redirectUri"}));
        MatcherAssert.assertThat((Object)this.lowerEnt.getRedirectUris(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"lower-redirectUri-1", "lower-redirectUri-2"}));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr1"), (Matcher)Matchers.contains((Object[])new String[]{"modified-value-1"}));
        MatcherAssert.assertThat((Object)this.upperEnt.getAttribute("attr1"), (Matcher)Matchers.contains((Object[])new String[]{"modified-value-1"}));
        MatcherAssert.assertThat((Object)this.lowerEnt.getAttribute("attr1"), (Matcher)Matchers.contains((Object[])new String[]{"lower-value-1"}));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr3"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-3"}));
        MatcherAssert.assertThat((Object)this.upperEnt.getAttribute("attr3"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-3"}));
        MatcherAssert.assertThat((Object)this.lowerEnt.getAttribute("attr3"), (Matcher)Matchers.contains((Object[])new String[]{"lower-value-3"}));
        MatcherAssert.assertThat((Object)ent.getAttribute("attrX"), (Matcher)Matchers.contains((Object[])new String[]{"modified-value-X"}));
        MatcherAssert.assertThat((Object)this.upperEnt.getAttribute("attrX"), (Matcher)Matchers.contains((Object[])new String[]{"modified-value-X"}));
        MatcherAssert.assertThat((Object)this.lowerEnt.getAttribute("attrX"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat(ent.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr2", "attr3", "attrX"}));
        MatcherAssert.assertThat(this.upperEnt.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr2", "attr3", "attrX"}));
        MatcherAssert.assertThat(this.lowerEnt.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr3", "attr4"}));
    }

    @Test
    public void testGet_PrimarySourceFor() {
        this.upperPrimarySourceFor.put(MapClientEntityFields.CLIENT_ID, (Object)null);
        this.upperPrimarySourceFor.put(MapClientEntityFields.ATTRIBUTES, (Object)Arrays.asList("attr2", "attr3", "attr4"));
        this.upperNodeProperties.put("___primary-source-for___", this.upperPrimarySourceFor);
        MapClientEntity ent = this.prepareEntityAndTreeNodeInstances();
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)ent.getClientId(), (Matcher)Matchers.is((Object)"upper-clientId-1"));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr2"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-2"}));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr3"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-3"}));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr4"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)ent.getProtocol(), (Matcher)Matchers.is((Object)"lower-protocol"));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr1"), (Matcher)Matchers.contains((Object[])new String[]{"lower-value-1"}));
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat(ent.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr2", "attr3"}));
        MatcherAssert.assertThat((Object)ent.getAttributes(), (Matcher)Matchers.hasEntry((Object)"attr1", Arrays.asList("lower-value-1")));
        MatcherAssert.assertThat((Object)ent.getAttributes(), (Matcher)Matchers.hasEntry((Object)"attr2", Arrays.asList("upper-value-2")));
        MatcherAssert.assertThat((Object)ent.getAttributes(), (Matcher)Matchers.hasEntry((Object)"attr3", Arrays.asList("upper-value-3")));
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSet_PrimarySourceFor() {
        this.upperPrimarySourceFor.put(MapClientEntityFields.CLIENT_ID, (Object)null);
        this.upperPrimarySourceFor.put(MapClientEntityFields.ATTRIBUTES, (Object)Arrays.asList("attr2", "attr3", "attr4"));
        this.upperNodeProperties.put("___primary-source-for___", this.upperPrimarySourceFor);
        MapClientEntity ent = this.prepareEntityAndTreeNodeInstances();
        ent.setClientId("modified-client-id");
        ent.setProtocol("modified-protocol");
        ent.setAttribute("attr1", Arrays.asList("modified-value-1"));
        ent.setAttribute("attrX", Arrays.asList("modified-value-X"));
        ent.addRedirectUri("added-redirectUri");
        ent.removeRedirectUri("upper-redirectUri-2");
        ent.removeRedirectUri("lower-redirectUri-2");
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)ent.getClientId(), (Matcher)Matchers.is((Object)"modified-client-id"));
        MatcherAssert.assertThat((Object)this.upperEnt.getClientId(), (Matcher)Matchers.is((Object)"modified-client-id"));
        MatcherAssert.assertThat((Object)this.lowerEnt.getClientId(), (Matcher)Matchers.is((Object)"lower-clientId-1"));
        MatcherAssert.assertThat((Object)ent.getRedirectUris(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"lower-redirectUri-1", "added-redirectUri"}));
        MatcherAssert.assertThat((Object)this.upperEnt.getRedirectUris(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"upper-redirectUri-1", "upper-redirectUri-2"}));
        MatcherAssert.assertThat((Object)this.lowerEnt.getRedirectUris(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"lower-redirectUri-1", "added-redirectUri"}));
        MatcherAssert.assertThat((Object)ent.getProtocol(), (Matcher)Matchers.is((Object)"modified-protocol"));
        MatcherAssert.assertThat((Object)this.upperEnt.getProtocol(), (Matcher)Matchers.is((Object)"upper-protocol"));
        MatcherAssert.assertThat((Object)this.lowerEnt.getProtocol(), (Matcher)Matchers.is((Object)"modified-protocol"));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr1"), (Matcher)Matchers.contains((Object[])new String[]{"modified-value-1"}));
        MatcherAssert.assertThat((Object)this.upperEnt.getAttribute("attr1"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-1"}));
        MatcherAssert.assertThat((Object)this.lowerEnt.getAttribute("attr1"), (Matcher)Matchers.contains((Object[])new String[]{"modified-value-1"}));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr3"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-3"}));
        MatcherAssert.assertThat((Object)this.upperEnt.getAttribute("attr3"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-3"}));
        MatcherAssert.assertThat((Object)this.lowerEnt.getAttribute("attr3"), (Matcher)Matchers.contains((Object[])new String[]{"lower-value-3"}));
        MatcherAssert.assertThat((Object)ent.getAttribute("attrX"), (Matcher)Matchers.contains((Object[])new String[]{"modified-value-X"}));
        MatcherAssert.assertThat((Object)this.upperEnt.getAttribute("attrX"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.lowerEnt.getAttribute("attrX"), (Matcher)Matchers.contains((Object[])new String[]{"modified-value-X"}));
        MatcherAssert.assertThat(ent.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr2", "attr3", "attrX"}));
        MatcherAssert.assertThat(this.upperEnt.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr2", "attr3"}));
        MatcherAssert.assertThat(this.lowerEnt.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr3", "attr4", "attrX"}));
    }

    @Test
    public void testGet_PrimarySourceForExcluded() {
        this.upperPrimarySourceForExcluded.put(MapClientEntityFields.CLIENT_ID, (Object)null);
        this.upperPrimarySourceForExcluded.put(MapClientEntityFields.ATTRIBUTES, (Object)Arrays.asList("attr2", "attr3", "attr4"));
        this.upperNodeProperties.put("___primary-source-for-excluded___", this.upperPrimarySourceForExcluded);
        MapClientEntity ent = this.prepareEntityAndTreeNodeInstances();
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)ent.getProtocol(), (Matcher)Matchers.is((Object)"upper-protocol"));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr1"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-1"}));
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr2"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr3"), (Matcher)Matchers.contains((Object[])new String[]{"lower-value-3"}));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr4"), (Matcher)Matchers.contains((Object[])new String[]{"lower-value-4"}));
        MatcherAssert.assertThat((Object)ent.getClientId(), (Matcher)Matchers.is((Object)"lower-clientId-1"));
        MatcherAssert.assertThat(ent.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr3", "attr4"}));
        MatcherAssert.assertThat((Object)ent.getAttributes(), (Matcher)Matchers.hasEntry((Object)"attr1", Arrays.asList("upper-value-1")));
        MatcherAssert.assertThat((Object)ent.getAttributes(), (Matcher)Matchers.hasEntry((Object)"attr3", Arrays.asList("lower-value-3")));
        MatcherAssert.assertThat((Object)ent.getAttributes(), (Matcher)Matchers.hasEntry((Object)"attr4", Arrays.asList("lower-value-4")));
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSet_PrimarySourceForExcluded() {
        this.upperPrimarySourceForExcluded.put(MapClientEntityFields.CLIENT_ID, (Object)null);
        this.upperPrimarySourceForExcluded.put(MapClientEntityFields.ATTRIBUTES, (Object)Arrays.asList("attr2", "attr3", "attr4"));
        this.upperNodeProperties.put("___primary-source-for-excluded___", this.upperPrimarySourceForExcluded);
        MapClientEntity ent = this.prepareEntityAndTreeNodeInstances();
        ent.setClientId("modified-client-id-1");
        ent.setProtocol("modified-protocol");
        ent.setAttribute("attr4", Arrays.asList("modified-value-4"));
        ent.setAttribute("attrX", Arrays.asList("modified-value-X"));
        ent.addRedirectUri("added-redirectUri");
        ent.removeRedirectUri("upper-redirectUri-2");
        ent.removeRedirectUri("lower-redirectUri-2");
        MatcherAssert.assertThat((Object)this.lowerEntSupplierCallCount.get(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)ent.getClientId(), (Matcher)Matchers.is((Object)"modified-client-id-1"));
        MatcherAssert.assertThat((Object)this.upperEnt.getClientId(), (Matcher)Matchers.is((Object)"upper-clientId-1"));
        MatcherAssert.assertThat((Object)this.lowerEnt.getClientId(), (Matcher)Matchers.is((Object)"modified-client-id-1"));
        MatcherAssert.assertThat((Object)ent.getRedirectUris(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"upper-redirectUri-1", "added-redirectUri"}));
        MatcherAssert.assertThat((Object)this.upperEnt.getRedirectUris(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"upper-redirectUri-1", "added-redirectUri"}));
        MatcherAssert.assertThat((Object)this.lowerEnt.getRedirectUris(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"lower-redirectUri-1", "lower-redirectUri-2"}));
        MatcherAssert.assertThat((Object)ent.getProtocol(), (Matcher)Matchers.is((Object)"modified-protocol"));
        MatcherAssert.assertThat((Object)this.upperEnt.getProtocol(), (Matcher)Matchers.is((Object)"modified-protocol"));
        MatcherAssert.assertThat((Object)this.lowerEnt.getProtocol(), (Matcher)Matchers.is((Object)"lower-protocol"));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr1"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-1"}));
        MatcherAssert.assertThat((Object)this.upperEnt.getAttribute("attr1"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-1"}));
        MatcherAssert.assertThat((Object)this.lowerEnt.getAttribute("attr1"), (Matcher)Matchers.contains((Object[])new String[]{"lower-value-1"}));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr2"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.upperEnt.getAttribute("attr2"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-2"}));
        MatcherAssert.assertThat((Object)this.lowerEnt.getAttribute("attr2"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)ent.getAttribute("attr3"), (Matcher)Matchers.contains((Object[])new String[]{"lower-value-3"}));
        MatcherAssert.assertThat((Object)this.upperEnt.getAttribute("attr3"), (Matcher)Matchers.contains((Object[])new String[]{"upper-value-3"}));
        MatcherAssert.assertThat((Object)this.lowerEnt.getAttribute("attr3"), (Matcher)Matchers.contains((Object[])new String[]{"lower-value-3"}));
        MatcherAssert.assertThat((Object)ent.getAttribute("attr4"), (Matcher)Matchers.contains((Object[])new String[]{"modified-value-4"}));
        MatcherAssert.assertThat((Object)this.upperEnt.getAttribute("attr4"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.lowerEnt.getAttribute("attr4"), (Matcher)Matchers.contains((Object[])new String[]{"modified-value-4"}));
        MatcherAssert.assertThat((Object)ent.getAttribute("attrX"), (Matcher)Matchers.contains((Object[])new String[]{"modified-value-X"}));
        MatcherAssert.assertThat((Object)this.upperEnt.getAttribute("attrX"), (Matcher)Matchers.contains((Object[])new String[]{"modified-value-X"}));
        MatcherAssert.assertThat((Object)this.lowerEnt.getAttribute("attrX"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat(ent.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr3", "attr4", "attrX"}));
        MatcherAssert.assertThat(this.upperEnt.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr2", "attr3", "attrX"}));
        MatcherAssert.assertThat(this.lowerEnt.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr3", "attr4"}));
    }
}

