/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.realm.MapRealmEntity;

public class RealmEntityUndefinedValuesTest {
    public MapRealmEntity newMapRealmEntity() {
        return (MapRealmEntity)DeepCloner.DUMB_CLONER.newInstance(MapRealmEntity.class);
    }

    @Test
    public void testUndefinedValuesToCollection() {
        MapRealmEntity realmEntity = this.newMapRealmEntity();
        realmEntity.setEventsListeners(null);
        MatcherAssert.assertThat((Object)realmEntity.getEventsListeners(), (Matcher)CoreMatchers.nullValue());
        realmEntity.setEventsListeners(Collections.emptySet());
        MatcherAssert.assertThat((Object)realmEntity.getEventsListeners(), (Matcher)CoreMatchers.nullValue());
        realmEntity.setEventsListeners(Collections.singleton(null));
        MatcherAssert.assertThat((Object)realmEntity.getEventsListeners(), (Matcher)CoreMatchers.nullValue());
        realmEntity.setEventsListeners(Collections.singleton("listener1"));
        MatcherAssert.assertThat((Object)realmEntity.getEventsListeners(), (Matcher)Matchers.contains((Object[])new String[]{"listener1"}));
        realmEntity.setEventsListeners(Collections.emptySet());
        MatcherAssert.assertThat((Object)realmEntity.getEventsListeners(), (Matcher)CoreMatchers.nullValue());
        realmEntity.addOptionalClientScopeId(null);
        MatcherAssert.assertThat((Object)realmEntity.getOptionalClientScopeIds(), (Matcher)CoreMatchers.nullValue());
        realmEntity.addOptionalClientScopeId("id1");
        MatcherAssert.assertThat((Object)realmEntity.getOptionalClientScopeIds(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)realmEntity.getOptionalClientScopeIds(), (Matcher)Matchers.contains((Object[])new String[]{"id1"}));
        realmEntity.addOptionalClientScopeId(null);
        MatcherAssert.assertThat((Object)realmEntity.getOptionalClientScopeIds(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)realmEntity.getOptionalClientScopeIds(), (Matcher)Matchers.contains((Object[])new String[]{"id1"}));
    }

    @Test
    public void testAddUndefinedValuesToMapStringString() {
        MapRealmEntity realmEntity = this.newMapRealmEntity();
        HashMap<String, String> headers = new HashMap<String, String>();
        realmEntity.setBrowserSecurityHeaders(Collections.emptyMap());
        MatcherAssert.assertThat((Object)realmEntity.getBrowserSecurityHeaders(), (Matcher)CoreMatchers.nullValue());
        headers.put("key1", null);
        realmEntity.setBrowserSecurityHeaders(headers);
        MatcherAssert.assertThat((Object)realmEntity.getBrowserSecurityHeaders(), (Matcher)CoreMatchers.nullValue());
        headers.put("key1", "value1");
        realmEntity.setBrowserSecurityHeaders(headers);
        MatcherAssert.assertThat((Object)realmEntity.getBrowserSecurityHeaders(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)realmEntity.getBrowserSecurityHeaders(), (Matcher)Matchers.allOf((Matcher)Matchers.aMapWithSize((int)1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.equalTo((Object)"key1"), (Matcher)CoreMatchers.equalTo((Object)"value1"))));
        headers.put("key2", null);
        realmEntity.setBrowserSecurityHeaders(headers);
        MatcherAssert.assertThat((Object)realmEntity.getBrowserSecurityHeaders(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)realmEntity.getBrowserSecurityHeaders(), (Matcher)Matchers.allOf((Matcher)Matchers.aMapWithSize((int)1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.equalTo((Object)"key1"), (Matcher)CoreMatchers.equalTo((Object)"value1"))));
        realmEntity.setBrowserSecurityHeaders(Collections.emptyMap());
        MatcherAssert.assertThat((Object)realmEntity.getBrowserSecurityHeaders(), (Matcher)CoreMatchers.nullValue());
        realmEntity.setBrowserSecurityHeader("key1", null);
        MatcherAssert.assertThat((Object)realmEntity.getBrowserSecurityHeaders(), (Matcher)CoreMatchers.nullValue());
        realmEntity.setBrowserSecurityHeader("key1", "value1");
        MatcherAssert.assertThat((Object)realmEntity.getBrowserSecurityHeaders(), (Matcher)Matchers.allOf((Matcher)Matchers.aMapWithSize((int)1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.equalTo((Object)"key1"), (Matcher)CoreMatchers.equalTo((Object)"value1"))));
        realmEntity.setBrowserSecurityHeader("key2", null);
        MatcherAssert.assertThat((Object)realmEntity.getBrowserSecurityHeaders(), (Matcher)Matchers.allOf((Matcher)Matchers.aMapWithSize((int)1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.equalTo((Object)"key1"), (Matcher)CoreMatchers.equalTo((Object)"value1"))));
        realmEntity.setBrowserSecurityHeader("key1", null);
        MatcherAssert.assertThat((Object)realmEntity.getBrowserSecurityHeaders(), (Matcher)Matchers.anEmptyMap());
    }

    @Test
    public void testAddUndefinedValuesToMapStringList() {
        MapRealmEntity realmEntity = this.newMapRealmEntity();
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>();
        attributes.put("key1", Collections.emptyList());
        realmEntity.setAttributes(attributes);
        MatcherAssert.assertThat((Object)realmEntity.getAttributes(), (Matcher)CoreMatchers.nullValue());
        attributes.put("key1", Collections.singletonList(null));
        realmEntity.setAttributes(attributes);
        MatcherAssert.assertThat((Object)realmEntity.getAttributes(), (Matcher)CoreMatchers.nullValue());
        attributes.put("key1", Arrays.asList(null, null, null));
        realmEntity.setAttributes(attributes);
        MatcherAssert.assertThat((Object)realmEntity.getAttributes(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testAddUndefinedValuesToMapStringMap() {
        MapRealmEntity realmEntity = this.newMapRealmEntity();
        HashMap<String, String> localizationTexts = new HashMap<String, String>();
        realmEntity.setLocalizationText("en", Collections.emptyMap());
        MatcherAssert.assertThat((Object)realmEntity.getLocalizationText("en"), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)realmEntity.getLocalizationTexts(), (Matcher)CoreMatchers.nullValue());
        realmEntity.setLocalizationText("en", Collections.singletonMap("key1", null));
        MatcherAssert.assertThat((Object)realmEntity.getLocalizationText("en"), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)realmEntity.getLocalizationTexts(), (Matcher)CoreMatchers.nullValue());
        realmEntity.setLocalizationText("en", Collections.singletonMap("key1", "value1"));
        MatcherAssert.assertThat((Object)realmEntity.getLocalizationTexts(), (Matcher)Matchers.allOf((Matcher)Matchers.aMapWithSize((int)1), (Matcher)Matchers.hasKey((Object)"en")));
        MatcherAssert.assertThat((Object)realmEntity.getLocalizationText("en"), (Matcher)Matchers.allOf((Matcher)Matchers.aMapWithSize((int)1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.equalTo((Object)"key1"), (Matcher)CoreMatchers.equalTo((Object)"value1"))));
        localizationTexts.put("key1", "value1");
        localizationTexts.put("key2", null);
        realmEntity.setLocalizationText("en", localizationTexts);
        MatcherAssert.assertThat((Object)realmEntity.getLocalizationTexts(), (Matcher)Matchers.allOf((Matcher)Matchers.aMapWithSize((int)1), (Matcher)Matchers.hasKey((Object)"en")));
        MatcherAssert.assertThat((Object)realmEntity.getLocalizationText("en"), (Matcher)Matchers.allOf((Matcher)Matchers.aMapWithSize((int)1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.equalTo((Object)"key1"), (Matcher)CoreMatchers.equalTo((Object)"value1"))));
        localizationTexts.put("key1", null);
        localizationTexts.put("key2", null);
        realmEntity.setLocalizationText("en", localizationTexts);
        MatcherAssert.assertThat((Object)realmEntity.getLocalizationTexts(), (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)realmEntity.getLocalizationText("en"), (Matcher)CoreMatchers.nullValue());
    }
}

